/*
 *   port_types.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#ifndef _PORT_TYPES
#define _PORT_TYPES

#include <linux/version.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#include <linux/spinlock.h>
#else
#include <asm/spinlock.h>
#endif

#include <pthread.h>

#ifndef GMEM_MOVEABLE
#define GMEM_MOVEABLE 0x0002
#endif

#ifndef GMEM_ZEROINIT
#define GMEM_ZEROINIT 0x0040
#endif

#ifndef WM_USER
#define WM_USER 0x0400
#endif

#ifndef STATUS_ABANDONED_WAIT_0
#define STATUS_ABANDONED_WAIT_0 0x00000080
#endif

#ifndef WAIT_ABANDONED
#define WAIT_ABANDONED STATUS_ABANDONED_WAIT_0
#endif

#ifndef WAIT_OBJECT_0
#define WAIT_OBJECT_0 0
#endif

#ifndef APIENTRY
#define APIENTRY
#endif

#ifndef RC
//#define RC unsigned int
typedef unsigned long RC;
#endif

#ifndef _MAX_PATH
#define _MAX_PATH 260
#endif

#ifndef pascal
#define pascal
#endif

#ifndef far
#define far
#endif

#ifndef FAR
#define FAR
#endif

#ifndef _USHORT_
#define _USHORT_
//#define USHORT unsigned short
typedef unsigned short USHORT;
#endif

#ifndef _WORD_
#define _WORD_
//#define WORD unsigned short
typedef unsigned short WORD;
#endif

#ifndef _ULONG_
#define _ULONG_
//#define ULONG unsigned int
typedef unsigned long ULONG;
#endif

#ifndef _UINT_
#define _UINT_
//#define UINT unsigned int
typedef unsigned int UINT;
#endif

#ifndef INT
//#define INT int
typedef int INT;
#endif

#ifndef BYTE
//#define BYTE unsigned char
typedef unsigned char BYTE;
#endif

#ifndef CHAR
//#define CHAR char
typedef char CHAR;
#endif

#ifndef PCHAR
// define PCHAR char *
typedef char * PCHAR;
#endif

#ifndef TCHAR
//#define TCHAR char
typedef char TCHAR;
#endif

#ifndef UCHAR
//#define UCHAR unsigned char
typedef unsigned char UCHAR;
#endif

#ifndef VOID
//#define VOID void
typedef void VOID;
#endif 

#ifndef PVOID
typedef void * PVOID;
#endif

#ifndef PUSHORT
typedef unsigned short * PUSHORT;
#endif

#ifndef PULONG
typedef unsigned long * PULONG;
#endif

#ifndef PBYTE
typedef BYTE * PBYTE;
#endif

#ifndef PSZ
typedef char *PSZ;
#endif

#ifndef LONG
//#define LONG int
typedef long LONG;
#endif

#ifndef _SHORT_
#define _SHORT_
//#define SHORT short
typedef short SHORT;
#endif

#ifndef _DWORD_
#define _DWORD_
//#define DWORD unsigned int
typedef unsigned long DWORD;
#endif

#ifndef PDWORD
//#define PDWORD unsigned int *
typedef unsigned long * PDWORD;
#endif

#ifndef PFN
typedef  int   (APIENTRY _PFN) (void);
typedef _PFN  *PFN;
//typedef int (*PFN)();
#endif

#ifndef HFILE
//#define HFILE int
typedef int HFILE;
#endif

#ifndef HKEY
//#define HKEY int
typedef int HKEY;
#endif

#ifndef LPCTSTR
//#define LPCTSTR char *
typedef char * LPCTSTR;
#endif

#ifndef LPVOID
//#define LPVOID void *
typedef void * LPVOID;
#endif

#ifndef LPBYTE
//#define LPBYTE char *
typedef char * LPBYTE;
#endif

#ifndef LPTSTR
//#define LPTSTR char *
typedef char * LPTSTR;
#endif

#ifndef LPCSTR
//#define LPCSTR char *
typedef char * LPCSTR;
#endif

#ifndef LPSTR
//#define LPSTR char *
typedef char * LPSTR;
#endif

#ifndef HWND
typedef unsigned long int HWND;
#endif

#ifndef HANDLE
//#define HANDLE int
typedef int HANDLE;
#endif

#ifndef HGLOBAL
typedef HANDLE HGLOBAL;
#endif

#ifndef HINSTANCE
//#define HINSTANCE int
typedef int HINSTANCE;
#endif

#ifndef WPARAM
typedef UINT WPARAM;
#endif

#ifndef LPARAM
typedef LONG LPARAM;
#endif

#ifndef BOOL
//#define BOOL int
typedef int BOOL;
#define TRUE 1
#define FALSE 0
#define OK 0
#endif

#ifndef PASCAL
#define PASCAL
#endif

#ifndef CRITICAL_SECTION
//#define CRITICAL_SECTION spinlock_t
typedef spinlock_t CRITICAL_SECTION;
#endif

#ifndef TEXT
#define TEXT(quote) quote
#endif

#ifndef NULL
#define NULL 0
#endif

/* Argument 1 passed to the LibEntryProc. */
#define LIB_PROCESS_DETACH      0       /* detach process (unload library) */
#define LIB_PROCESS_ATTACH      1       /* attach process (load library) */
#define LIB_THREAD_ATTACH       2       /* attach new thread */
#define LIB_THREAD_DETACH       3       /* detach thread */

#define ERROR_SUCCESS 0

#define CALLBACK

/*
#ifndef _FARPROC_
#define _FARPROC_
typedef LRESULT CALLBACK (*FARPROC)();
#endif
*/
#ifndef LRESULT
#define LRESULT ULONG
#endif

#define FARPROC

/* The POINT structure */
typedef struct tagPOINT
{
	    LONG  x;
	        LONG  y;
} POINT, *PPOINT, *LPPOINT;

typedef struct tagMSG
{
	    HWND    hwnd;
	        UINT    message;
		    WPARAM  wParam;
		        LPARAM    lParam;
			    DWORD     time;
			        POINT   pt;
} MSG, *LPMSG;

#define SW_SHOWMINIMIZED    2
#define PM_REMOVE	0x0001
#define MB_TASKMODAL	0x00002000
#define MB_OK		0x00000000

#define _MAX_PATH  260
#define MAX_PATH   260
#define _MAX_DRIVE 3
#define _MAX_DIR   256
#define _MAX_FNAME 255
#define _MAX_EXT   256


/*
#ifndef PSECURITY_DESCRIPTOR
typedef PVOID PSECURITY_DESCRIPTOR;
#endif
*/

/*
#ifndef SID_IDENTIFIER_AUTHORITY_DEFINED
#define SID_IDENTIFIER_AUTHORITY_DEFINED
typedef struct {
	    BYTE Value[6];
} SID_IDENTIFIER_AUTHORITY,*PSID_IDENTIFIER_AUTHORITY,*LPSID_IDENTIFIER_AUTHORITY;  
#endif

#ifndef SID_DEFINED
#define SID_DEFINED
typedef struct _SID {
	    BYTE Revision;
	        BYTE SubAuthorityCount;
		    SID_IDENTIFIER_AUTHORITY IdentifierAuthority;
		        DWORD SubAuthority[1];
} SID,*PSID;
#endif


typedef struct _SECURITY_ATTRIBUTES
{
	    DWORD   nLength;
	        LPVOID  lpSecurityDescriptor;
		    BOOL  bInheritHandle;
} SECURITY_ATTRIBUTES, *PSECURITY_ATTRIBUTES, *LPSECURITY_ATTRIBUTES;

#ifndef SECURITY_DESCRIPTOR_CONTROL
typedef WORD SECURITY_DESCRIPTOR_CONTROL, *PSECURITY_DESCRIPTOR_CONTROL;
#endif

#ifndef SECURITY_DESCRIPTOR
typedef struct {
	    BYTE Revision;
	        BYTE Sbz1;
		    SECURITY_DESCRIPTOR_CONTROL Control;
		        PSID Owner;
			    PSID Group; 
			        PACL Sacl;
				    PACL Dacl;
} SECURITY_DESCRIPTOR, *PSECURITY_DESCRIPTOR;
#endif

*/

#define FIELDOFFSET(type,field) ((short)&(((type *)0)->field))

#define InitializeCriticalSection(pspinlock) spin_lock_init(pspinlock)
#define DeleteCriticalSection(pspinlock) 
#define EnterCriticalSection(pspinlock) spin_lock(pspinlock)
#define LeaveCriticalSection(pspinlock) spin_unlock(pspinlock)

#define IsBadReadPtr(lp,cb)     (FALSE)
#define IsBadWritePtr(lp,cb)    (FALSE)
#define IsBadStringPtr(lp,cb)   (FALSE)

#define gtid()    (int)pthread_self()

#include <port_functions.h>
#endif /* _PORT_TYPES */
