/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */


/*
 * Network client library for line oriented protocols.
 */

#ifndef _NET_LINE_CLIENT_H_
#define _NET_LINE_CLIENT_H_

#include <glib.h>
#include <openssl/ssl.h>

typedef enum {
  MSSSLError=-4,
  MSConnectError=-3,
  MSResolveError=-2,
  MSError=-1,
  MSDisconnected,
  MSConnected
} MClientState;


enum {
  MWReadOK=1,
  MWWriteOK=2
};


typedef struct {
  char subject[256];
  char issuer[256];

  char valid_not_before[32];
  char valid_not_after[32];
} MNetCertificateInfo;


typedef struct {
  int socket;
  SSL_CTX *ssl_ctx;
  SSL *ssl;

  MClientState state;

  // output buffer
  char *out_buffer;
  int out_buffer_len;
  int out_buffer_alloced;

  // incoming data buffer
  char *in_buffer;
  int in_buffer_len;
  int in_buffer_alloced;

  // incoming line buffer
  int in_lines_used;
  int in_lines_alloced;
  char **in_lines;
} MNetLineClient;





MNetLineClient *mnet_init_client(int line_buffer_size);
MNetLineClient *mnet_init_ssl_client(int line_buffer_size);

int mnet_client_get_certificate_info(MNetLineClient *client,
                                     MNetCertificateInfo *info);

int mnet_client_connect(MNetLineClient *client, const char *host, int port);

int mnet_client_disconnect(MNetLineClient *client);

int mnet_send_line(MNetLineClient *client, const char *line);
int mnet_send(MNetLineClient *client, const char *data, unsigned int len);
char *mnet_get_line(MNetLineClient *client);

int mnet_wait_ready(MNetLineClient *client, int max_wait_msec);
int mnet_read_data(MNetLineClient *client);
int mnet_flush_data(MNetLineClient *client);


#endif /* _NET_LINE_CLIENT_H_ */



