/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/*
  Create is done by simply remove the database from memory if it exists.
  Open creates the database when neaded
*/

#include "heapdef.h"

int heap_create(const char *name)
{
  DBUG_ENTER("heap_create");
  (void) heap_delete_all(name);
  DBUG_RETURN(0);
}

int heap_delete_all(const char *name)
{
  reg1 HP_SHARE *info;
  int found;
  DBUG_ENTER("heap_delete_all");
  pthread_mutex_lock(&THR_LOCK_heap);
  if ((info=_hp_find_named_heap(name)))
  {
    if (info->open_count == 0)
      _hp_free(info);
    found=0;
  }
  else
  {
    found=my_errno=ENOENT;
  }
  pthread_mutex_unlock(&THR_LOCK_heap);
  DBUG_RETURN(found);
}

void _hp_free(HP_SHARE *share)
{
  heap_share_list=list_delete(heap_share_list,&share->open_list);
  _hp_clear(share);			/* Remove blocks from memory */
#ifdef THREAD
  thr_lock_delete(&share->lock);
  VOID(pthread_mutex_destroy(&share->intern_lock));
#endif
  my_free((gptr) share->name,MYF(0));
  my_free((gptr) share,MYF(0));
  return;
}
