 * Program: Filesystem space usage plugin for NetSaint
 * License: GPL
 * Copyright (c) 1999 Adam G. Bowen (agbowen@bealenet.com)
 *
 * Description:
 *
 * This plugin will check the percent of used space in the filesystem on the
 * remote host at ipaddress and generate an alert if percentage is above one of
 * the threshold values.
 *
 * Other errors result in a STATE_UNKNOWN return.
 *
 * Command line:
 *
 * check_fs ipaddress sys_type filesystem mount_point
 * check_fs ipaddress sys_type filesystem mount_point <warn_%> <crit_%>
 *
 * Required input:
 *
 * ipaddress = The ipaddress of the remote system to run the check on.
 * sys_type = The remote system type.
 * filesystem = The filesystem to be checked.
 * mount_point = The mount point for the filesystem to be checked.
 *
 * Optional input:
 *
 * <warn_%> = Percent of used space necessary to result in a WARNING state.
 * <crit_%> = Percent of used space necessary to result in a CRITICAL state.
 *
 * Notes:
 *
 * If <warn_%> and <crit_%> are not passed on the command line, they will be set
 * to the default values in the check_fs config file.
 *
 * If the speicified filesystem does not exist, a STATE_CRITICAL is returned.
 *
 * If the speicified filesystem is not mounted, a STATE_CRITICAL is returned.
 *
 * If the speicified filesystem is mounted to the wrong mount point, a
 * STATE_CRITICAL is returned.
 *
 * sys_type is used to determine which config file to use to generate the
 * remote command.
 *
 * The configuration file /usr/local/netsaint/config/check_fs/local
 * contains the following values:
 *
 * RSH_COMMAND|<location of rsh command on netsaint system>|
 * AWK_COMMAND|<location of awk command on netsaint system>|
 * TAIL_COMMAND|<location of tail command on netsaint system>|
 * TAIL_OPTIONS|<tail options need on netsaint system to retrieve info>|
 * WARN_PERCENT|<default warn %>|
 * CRITICAL_PERCENT|<default crit %>|
 *
 * The configuration file /usr/local/netsaint/config/check_fs/<sys_type>
 * contains the following values:
 *
 * DF_COMMAND|<location of df command on system sys_type>|
 * DF_OPTIONS|<options for df command to retreive required info>|
 * AWK_OPTIONS|<options for awk command to retrieve required info>|
 *
 * The check_fs program expects all output to be in the following format:
 * filesystem;free space;% used;mount point;
