--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with System;
with System.Storage_Elements;
with System.Storage_Pools;

with Narval.Protected_Memory;

package Narval.Buffers is

   type Buffer_Type is new System.Storage_Pools.Root_Storage_Pool
     with private;

   procedure Allocate
     (Pool                     : in out Buffer_Type;
      Storage_Address          : out System.Address;
      Size_In_Storage_Elements : in System.Storage_Elements.Storage_Count;
      Alignment                : in System.Storage_Elements.Storage_Count);

   procedure Deallocate
     (Pool                     : in out Buffer_Type;
      Storage_Address          : in System.Address;
      Size_In_Storage_Elements : in System.Storage_Elements.Storage_Count;
      Alignment                : in System.Storage_Elements.Storage_Count);

   function Storage_Size (Pool : Buffer_Type)
                         return System.Storage_Elements.Storage_Count;

   procedure Initialise (Pool : in out Buffer_Type;
                         Memory : Protected_Memory.Memory_Access);

   procedure Set_Duplicate (Pool : in out Buffer_Type;
                            Duplicate : Boolean);

private
   type Buffer_Type is new System.Storage_Pools.Root_Storage_Pool with record
      Memory : Protected_Memory.Memory_Access;
      Duplicate : Boolean := False;
   end record;
end Narval.Buffers;
