--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with GNAT.Sockets;
with GNAT.OS_Lib;

with Options;

with Narval.Configurator.Abstract_Actors_Coordination;
with Narval.Configurator.Abstract_Actors_Coordination.Actors_Coordination;
with Narval.Narval_Naming_Registry;
with Narval.Coordination_Local_Hook;

with Log4ada.Loggers;

procedure Init_Sub_System_Coordinator is
   use Narval;
   use Configurator;
   use Coordination_Local_Hook;
begin
   declare
      Configuration_Name : constant String :=
        Options.Get_Option ("config_name");
   begin
      Abstract_Actors_Coordination.Actors_Coordination.Initialise
        (Configuration_Hook, Configuration_Name);
      Log4ada.Loggers.Debug_Out
        (Configuration_Hook.Logger'Access,
         "chef_orchestre just initialised");
      Narval_Naming_Registry.Add_Sub_System (Configuration_Name,
                                             GNAT.Sockets.Host_Name,
                                             Configuration_Hook'Access);
   end;
   loop
      delay 1.0;
      exit when
        Abstract_Actors_Coordination.Actors_Coordination.Have_To_End
        (Configuration_Hook);
   end loop;
   Log4ada.Loggers.Info_Out (Configuration_Hook.Logger'Access,
                             "chef_orchestre is going to finish");
   delay 0.3;
   GNAT.OS_Lib.OS_Exit (0);
exception
   when E : others =>
      Log4ada.Loggers.Fatal_Out
        (Narval.Coordination_Local_Hook.Configuration_Hook.Logger'Access,
         "unexpected exception", E);
end Init_Sub_System_Coordinator;
