--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Strings.Unbounded;

with Exception_Message;
with Error_Message;

with Narval.Actors;
with Narval.Configurator.Abstract_Actors_Coordination;
with Narval.Narval_Naming_Registry;

with McKae.XML.EZ_Out.String_Stream;

package body Get_Command is

   use Ada.Strings.Unbounded;
   use Narval.Configurator.Abstract_Actors_Coordination;

   ---------
   -- Get --
   ---------

   function Get (Shell_Line : String) return String is
      use Narval.Configurator;
   begin
      declare
         Arguments : constant Shell_Commands.Arguments_Array :=
           Shell_Commands.Arguments (Shell_Line);
         Config : Abstract_Actors_Coordination.Configuration_Access;
         Actor : Narval.Actors.Actor_Class_Access;
         use type Narval.Actors.Actor_Class_Access;
      begin
         if Arguments'Length = 1 then
            if Arguments (1) = "sub_systems" then
               return Narval.Narval_Naming_Registry.Get_Sub_Systems_Names;
            else
               return Syntax_String;
            end if;
         elsif Arguments'Length = 2 then
            Config := Narval.Narval_Naming_Registry.Get_Configuration
              (To_String (Arguments (2)));
            if Arguments (1) = "arguments" then
               return Abstract_Actors_Coordination.Arguments (Config);
            else
               return Abstract_Actors_Coordination.Get_Xml
                 (Config, To_String (Arguments (1)));
            end if;
         elsif Arguments'Length = 3 then
            Config := Narval.Narval_Naming_Registry.Get_Configuration
              (To_String (Arguments (2)));
            Actor := Abstract_Actors_Coordination.Get_Actor
              (Config, To_String (Arguments (3)));
            if Actor = null then
               return Error_Message ("get", "WARNING",
                                     "actor isn't loaded yet");
            end if;
            if Arguments (1) = "arguments" then
               return Narval.Actors.Arguments (Actor);
            else
               return Narval.Actors.Get_Xml (Actor,
                                              To_String (Arguments (1)));
            end if;
         else
            return Syntax_String;
         end if;
      end;
   exception
      when Shell_Commands.No_Argument =>
         return Syntax_String;
      when E : others =>
         return Exception_Message ("get", E);
   end Get;

   function Syntax_String
     (Status : Shell_Commands.Status_Type := Shell_Commands.Syntax_Error)
     return String is
      use McKae.XML.EZ_Out.String_Stream.String_Buffering;
      use McKae.XML.EZ_Out.String_Stream.XML_String_Buffer;
      Xml_Buffer : String_Buffer;
   begin
      Clear (Xml_Buffer);
      Start_Element (Xml_Buffer, "result",
                     ("cmd" = "get", "status" = Status'Img));
      Start_Element (Xml_Buffer, "message", "type" = "help");
      Output_Element (Xml_Buffer, "syntax",
                      "get argument_name sub_system_name");
      Output_Element (Xml_Buffer, "syntax",
                      "get argument_name sub_system_name actor_name");
      Output_Element (Xml_Buffer, "syntax",
                      "get arguments sub_system_name");
      Output_Element (Xml_Buffer, "syntax",
                      "get arguments sub_system_name actor_name");
      Output_Element (Xml_Buffer, "syntax",
                      "get sub_systems");
      Output_Element (Xml_Buffer, "syntax",
                      "get actors sub_system_name");
      End_Element (Xml_Buffer, "message");
      End_Element (Xml_Buffer, "result");
      declare
         String_To_Return : constant String := Get_String (Xml_Buffer);
      begin
         Full_Clear (Xml_Buffer);
         return String_To_Return;
      end;
   end Syntax_String;

end Get_Command;
