#nec_near_field_pattern.py

#header generated by SWIG

import _PyNEC

def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "this"):
        if isinstance(value, class_type):
            self.__dict__[name] = value.this
            if hasattr(value,"thisown"): self.__dict__["thisown"] = value.thisown
            del value.thisown
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name) or (name == "thisown"):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types

#end of the header generated by SWIG



import exceptions

#some utility functions

def _get_nfeh(arg0):
	"""
	Returns the flag indicating whether the result is a near electric or magnetic field pattern.
	"""
	return _PyNEC.nec_near_field_pattern_get_nfeh(arg0)    



#class "near_field_pattern"

class nec_near_field_pattern(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, nec_near_field_pattern, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, nec_near_field_pattern, name)
    def __init__(self): raise RuntimeError, "No constructor defined"
    def __repr__(self):
        return "<%s.%s; proxy of C++ nec_near_field_pattern instance at %s>" % (self.__class__.__module__, self.__class__.__name__, self.this,)
    
    
    def get_frequency(*args):
    	"""
	Returns the frequency in Herz.
	"""
    	return _PyNEC.nec_near_field_pattern_get_frequency(*args)
    
    
    def get_x(*args):
    	"""
	Returns the array of x-coordinate in meters of field points.
	"""
    	return _PyNEC.nec_near_field_pattern_get_x(*args)
	
	
    def get_y(*args):
    	"""
	Returns the array of y-coordinate in meters of field points.
	"""
    	return _PyNEC.nec_near_field_pattern_get_y(*args)
	
	
    def get_z(*args):
    	"""
	Returns the array of z-coordinate in meters of field points.
	"""
    	return _PyNEC.nec_near_field_pattern_get_z(*args)



    def get_e_x(*args):
    	"""
	Returns the array of x_components of the electric field.
	"""
    	if(_get_nfeh(*args) != 1):
		return _PyNEC.nec_near_field_pattern_get_field_x(*args)
	else:
		error_msg = "This result is a Near Magnetic Field Pattern. Try and get 'h_x' instead."
		raise exceptions.Warning(error_msg)
	
	
    def get_e_y(*args):
    	"""
	Returns the array of y_components of the electric field.
	"""
    	if(_get_nfeh(*args) != 1):
		return _PyNEC.nec_near_field_pattern_get_field_y(*args)
	else:
		error_msg = "This result is a Near Magnetic Field Pattern. Try and get 'h_y' instead."
		raise exceptions.Warning(error_msg)
	
		
    def get_e_z(*args):
    	"""
	Returns the array of z_components of the electric field.
	"""
    	if(_get_nfeh(*args) != 1):
		return _PyNEC.nec_near_field_pattern_get_field_z(*args)
	else:
		error_msg = "This result is a Near Magnetic Field Pattern. Try and get 'h_z' instead."
		raise exceptions.Warning(error_msg)



    def get_h_x(*args):
    	"""
	Returns the array of x_components of the magnetic field.
	"""
    	if(_get_nfeh(*args) == 1):
		return _PyNEC.nec_near_field_pattern_get_field_x(*args)
	else:
		error_msg = "This result is a Near Electric Field Pattern. Try and get 'e_x' instead."
		raise exceptions.Warning(error_msg)
	
	
    def get_h_y(*args):
    	"""
	Returns the array of y_components of the magnetic field.
	"""
    	if(_get_nfeh(*args) == 1):
		return _PyNEC.nec_near_field_pattern_get_field_y(*args)
	else:
		error_msg = "This result is a Near Electric Field Pattern. Try and get 'e_y' instead."
		raise exceptions.Warning(error_msg)
	
		
    def get_h_z(*args):
    	"""
	Returns the array of z_components of the magnetic field.
	"""
    	if(_get_nfeh(*args) == 1):
		return _PyNEC.nec_near_field_pattern_get_field_z(*args)
	else:
		error_msg = "This result is a Near Electric Field Pattern. Try and get 'e_z' instead."
		raise exceptions.Warning(error_msg)



class nec_near_field_patternPtr(nec_near_field_pattern):
    def __init__(self, this):
        _swig_setattr(self, nec_near_field_pattern, 'this', this)
        if not hasattr(self,"thisown"): _swig_setattr(self, nec_near_field_pattern, 'thisown', 0)
        _swig_setattr(self, nec_near_field_pattern,self.__class__,nec_near_field_pattern)
_PyNEC.nec_near_field_pattern_swigregister(nec_near_field_patternPtr)
