#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10141);

 name["english"] = "MetaInfo servers";
 name["francais"] = "MetaInfo servers";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The remote MetaInfo server
allows remote users to read arbitrary
files by entering '../' in the URL. 
For instance :

	GET ../smusers.txt HTTP/1.0
will read 'smusers.txt'.

Solution : disable this server or upgrade.

Risk factor : High";

 desc["francais"] = "Le serveur MetaInfo distant
permet aux utilisateurs de lire
des fichiers arbitraires, pourvu
que leur noms soit prcds par
'../'
Exemple :
	GET ../smusers.txt HTTP/1.0
Lira le fichier smusers.txt

Solution : dsactivez ce serveur ou mettez-le  jour.

Facteur de risque : Elev";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Read everything using '../' in the URL";
 summary["francais"] = "Accde  n'importe quel fichier en utilisant '../'";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Remote file access";
 family["francais"] = "Accs aux fichiers distants";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "httpver.nasl");
 script_require_ports(5000);
 exit(0);
}

#
# The script code starts here
#

port = 5000;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  buf = http_get(item:"../smusers.txt", port:port);
  send(socket:soc, data:buf);
  rep = recv_line(soc, length:4096);
  if(" 200 " >< rep)security_hole(port);
  close(soc);
 }
}
