#TRUSTED 6884299c3b045dbe1f6d4ba3f647899a20033be62e333bd97bfafd900553f05e72178ac6fb0e7b410496998f208229dc4c04acf6f732b92b193f2f8243ab24b753cc1f052501f8e83cf9797aed3b3cb629f71e2b9242b2189a7eab515923182ab8995519fac3d7927c0bf4db58ba2ea78a1ea9f325d45114ce01ed02e63fde5e9f6b65542b7704b43f8a4a819d06e613acb8653592cce53149c6de5ac78c96383394a99be02105e47be9b2ebacfe1dc239fd2c062a4d147d44cbe0de0e54a1eb8b985a2685d3ceac738bb5311ec1d08211f5c3be67d0719db178898624122b96f3d1c185ee65b8e384c7736bc48d65e7bd25c36f513d2b855a0eb260921f0271d74a7f8a29b32f2e6e6648c2cc7b56cb18f96a33ddea3f3ac0270f6e3ca26579e180fd39b2c07693387143194f231b6f90e81547a7a4ca5f72766caff0d23adb4e59215b2917dae4ebf90402e12664a47cceb2be48dccd6c90d3e2ea8eb9ad3d752ebaa111215d449fea86067f41db6152dd8a64b1406ef08b7b7eedbe621e5fad0b326393726dd031d8d8688e00581c20fe053a8f7b0a87192580d821ab61e7ea0699091f71cdde46e041b3243203383a773f466679f67f1dbf7efc6a2a85686cf95db3b5c2b34319b96e334b280c18ad04215a15cc5543839c90a7da19249d8b67d55243d23a9d65a97be3a805a8aced44f61db071ef473f65c9a22e40cfa0
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15873);
 script_version ("1.3");
 script_xref(name: "OWASP", value: "OWASP-AUTHN-004");
 script_xref(name: "OWASP", value: "OWASP-AUTHN-006");
 script_xref(name: "OWASP", value: "OWASP-AUTHN-010");
 name["english"] = "Hydra: HTTP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find HTTP passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force HTTP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 
 script_add_preference(name: "Web page :", value: "", type: "entry");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/www", 80);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "doublecheck_std_services.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/www");
if (! port) exit(0);	# port = 80;
if (! get_port_state(port)) exit(0);
if ( get_kb_item("Services/www/" + port + "/broken") ) exit(0);

# Check that the server is up & running
soc = open_sock_tcp(port);
if (! soc) exit(0);
send(socket: soc, data: 'GET / HTTP/1.0\r\n\r\n');
r = recv_line(socket: soc, length: 4096);
close(soc);
if (r !~ '^[0-9][0-9][0-9] ') exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
#if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
if ( tr >= ENCAPS_SSLv2 )
 argv[i++] = "https-get";
else
 argv[i++] = "http-get";

opt = script_get_preference("Web page :");
if (! opt)
{
  v = get_kb_list('www/'+port+'/content/auth_required');
  if (!isnull(v)) opt = v[0];
}
if (! opt) exit(0);
# Check that web page is forbidden
soc = http_open_socket(port);
if (! soc) exit(0);
send(socket: soc, data: 
 strcat('GET ', opt, ' HTTP/1.1\r\nHost: ', get_host_name(), '\r\n\r\n'));
r = recv_line(socket: soc, length: 512);
http_close_socket(soc);
if (r !~ "^HTTP/1\.[01] +403 ") exit(0);
#
argv[i++] = opt;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/http/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following HTTP accounts:\n' + report);
