#TRUSTED 888f5fdec94748b9e4119767857436e7b67a4fcb7fd987cb63b61c668dd38f386a550cbba80119a5fd32a9b567f12b588fa95a4671354656339d060592507f48af2aa791c07155ec13856d25e6e6e896966a584675b2651dd2d427b6f445da70c0dba72185c1ffe20ec8fe45e03e1b51a5b856cc6121ebdcf29a9cbe10eb59b9bb84e3299b4274f6eeb2e2021d3e100505aa67659af31d075afaec0256e1f4c9e09ad332727d72be20555faeaec10f111b6f6f4504e684d9d655938806e2ba48ca67e5e2b068f0e6a449e60b9318facf614f3abbea97bb4ad617125d9954cad8e5270a0aeacb31374305e080673e36220675b0faee003b08ee9b6d0a65583f07ba199453bd879c81aa04d3d929f1592dd18e2e6b484910d493eaf489e2224cb5666474c0b8aebeb13703efa5e603ff1312185e19423161c01773e0021bc48aa765fb86c4eec99653fdd6da626e9a46962d992d32e5e4902f60ca042ab4757f18618ffd044baafda7ce6d9e3f24e6d303c24b0ea4e97b4f1143f42fb8d88539d214bf0e472f8893d85be1f7a6c994f0e3b8056c4c8bb2b64c58f17ccbee9f3c4e1daf4d02304249f4724dfa2eb34be0dc29fb28a309f8ad76a5e653bcd455a81151fabfef9f377fc6d6b17d5b65f1be0a4e4ef1e3818f139b5c23976c7bd2f45a75b3af169f759b9db30bc51eafaba2db99a5906b1a73f2f5f324c190d0f3bb89
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15888);
 script_version ("1.3");
 name["english"] = "Hydra: SSH2";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SSH2 accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SSH2 authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/ssh");
 script_dependencies("hydra_options.nasl", "doublecheck_std_services.nasl", "ssh_detect.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
thorough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< thorough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/ssh");
if (! port) exit(0);	# port = 22;
if (! get_port_state(port)) exit(0);

# Check that the server is up & running
soc = open_sock_tcp(port);
if (! soc) exit(0);
r = recv_line(socket: soc, length: 1024);
close(soc);
if (r !~ '^SSH-') exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "ssh2";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/ssh2/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SSH accounts:\n' + report);
