#TRUSTED 9a8f3e98b6e783a36b2e75e7363ac3b58d494a8937cda8f3672ecde93df2b33f9d1c4c6361eb623dddb6506ba06c6bda96e97ccd2f8b44ba7f9726622d03f3928771fa70a6481276624313dc99b5ff690b3f20a852ebbd974b17aac76e802b76be49133151fa21fb455c8bbea40830556e8449a24047acb4e9a2fe16971ae912c7a6bc1ed8315e896247596f116c87f184d9edb67bfc081f557496360f4293841b84500a9a902563f52f47e089216347a069d16aec1b5f21a6304453596417ff724780ca285a7deecb69961236c89154d4c347c4b3f9557e3984b7e995da2267fad48ecfc1662f01e8cf7244d40e62c032f094799679b9760ec3dd351e10d8512de4a9e5e0b1e91a67c350d9bb8543f27650b0c5881ba155ea54653c640291b2cc4eff73777315700bb0020df52e702e42b9af6aaa56b06486d061ffa973711582385412b4aa0387e67dfc2e5227f9b0829f95b1103aca5bbac400285b5f549b69350fb70a83ab23d413e197bbb3a37aa9fec0a1f4001a306988ed225cc4ad0a8787bacb16d0b43d58e1ef79aa28d95bf6dddb9a4babbbd11019be84978b8fe12da3aeda7e29919f553e085bb78109cf40118389f1320e8c31a4796296ea844481948e6501f35cf64f8866af7d44178f1235d0bc583daf986d08ea24f77f7457d83bced8313dc37700905e293fb78fd4c764f3da72cbe578b4b4d9ff755e3263
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15875);
 script_version ("1.1");
 name["english"] = "Hydra: ICQ";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find ICQ accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force ICQ authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/icq", 5190);
 script_dependencies("hydra_options.nasl", "find_service.nes");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/icq");
if (! port) port = 5190;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "icq";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/icq/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following ICQ accounts:\n' + report);
