/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.javacard.templates;

import com.sun.javacard.AID;
import static org.netbeans.modules.javacard.templates.ClassicAppletDeploymentWizardPanel.PROP_APPLET_NAME;
import org.openide.util.NbBundle;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class ClassicAppletDeploymentVisualPanel extends JPanel implements ChangeListener {
    //XXX this is a copy of ExtendedAppletDeploymentVisualPanel

    private ClassicAppletDeploymentWizardPanel wizardPanel;

    ClassicAppletDeploymentVisualPanel(ClassicAppletDeploymentWizardPanel wizardPanel) {
        initComponents();
        this.wizardPanel = wizardPanel;
        aIDPanel1.setGenerateButtonVisible(false);
        aIDPanel1.addChangeListener(this);
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ClassicAppletDeploymentWizardPanel.class,
                "CONFIG_APPLET"); //NOI18N
    }

    /**
     * Fill the text field with defalt value. Do not modify users input.
     * 
     * @param className
     */
    void setClassName(String className) {
        classNameTextField.setText(className);
        aIDPanel1.setClassFqn(className);
        aIDPanel1.generateAid();
    }

    String getAppletAID() {
        AID result = aIDPanel1.getAID();
        return result == null ? "" : result.toString();
    }

    boolean isAddInfoSelected() {
        return addInfoCheckBox.isSelected();
    }

    boolean shouldCreateScript() {
        return createScriptCheckBox.isSelected();
    }
    boolean shouldCreateInstance() {
        return createInstanceCheckBox.isSelected();
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel3 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        classNameTextField = new javax.swing.JTextField();
        createScriptCheckBox = new javax.swing.JCheckBox();
        createInstanceCheckBox = new javax.swing.JCheckBox();
        addInfoCheckBox = new javax.swing.JCheckBox();
        aIDPanel1 = new org.netbeans.modules.javacard.common.AIDPanel();
        jSeparator1 = new javax.swing.JSeparator();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(ClassicAppletDeploymentVisualPanel.class, "LBL_servlet_name")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(ClassicAppletDeploymentVisualPanel.class, "LBL_servlet_instructions")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(ClassicAppletDeploymentVisualPanel.class, "LBL_class_name")); // NOI18N

        classNameTextField.setEditable(false);

        createScriptCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(createScriptCheckBox, "Create APDU Script file");

        createInstanceCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(createInstanceCheckBox, "Create Instance when Project is Run");

        addInfoCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(addInfoCheckBox, "Add information to Applet descriptor (applet.xml)");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(addInfoCheckBox)
                    .add(createInstanceCheckBox)
                    .add(createScriptCheckBox)
                    .add(aIDPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 430, Short.MAX_VALUE)
                    .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 430, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(jLabel2)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(classNameTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 367, Short.MAX_VALUE))
                    .add(jLabel1))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(classNameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(18, 18, 18)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(aIDPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(addInfoCheckBox)
                .add(4, 4, 4)
                .add(createScriptCheckBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(createInstanceCheckBox)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.netbeans.modules.javacard.common.AIDPanel aIDPanel1;
    private javax.swing.JCheckBox addInfoCheckBox;
    private javax.swing.JTextField classNameTextField;
    private javax.swing.JCheckBox createInstanceCheckBox;
    private javax.swing.JCheckBox createScriptCheckBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables
    

    @Override
    public void stateChanged(ChangeEvent e) {
        wizardPanel.fireChangeEvent();
        AID aid = aIDPanel1.getAID();
        firePropertyChange(PROP_APPLET_NAME, null, aid);
        if (aid == null) {
            wizardPanel.setProblem (aIDPanel1.getProblem());
        } else {
            wizardPanel.setProblem (null);
        }
    }
}

