/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_misc_h
#define __nd_misc_h

#include <stdlib.h>
#include <gtk/gtk.h>
#include <nd_packet.h>

u_int16_t nd_misc_ip_checksum(ND_Packet *p);
u_int16_t nd_misc_icmp_checksum(ND_Packet *p);
u_int16_t nd_misc_icmp_error_ip_checksum(ND_Packet *p);
u_int16_t nd_misc_tcp_checksum(ND_Packet *p);
u_int16_t nd_misc_udp_checksum(ND_Packet *p);

/* Checks whether a given file is in fact a tcpdump trace file ... */
int       nd_misc_is_tcpdump_file(char *name);

void      nd_misc_show_generic_dialog(char *message, char *gui_data, u_int max);
void      nd_misc_show_tcp_seqack_dialog(char *message, char *gui_data);
void      nd_misc_show_ip_dialog(char *message, char *gui_data);
void      nd_misc_show_mac_dialog(char *message, char *gui_data);

void      nd_misc_set_num_packets_label(void);

void      nd_misc_widget_init(void);
void      nd_misc_widget_set_red(GtkWidget *w, int onoff);
void      nd_misc_gtk_clist_select_all(GtkCList *clist);
void      nd_misc_gtk_clist_unselect_all(GtkCList *clist);

void      nd_misc_statusbar_set(char *text);
gint      nd_misc_statusbar_clear(gpointer data);

void      nd_misc_pbar_reset(int num_steps);
void      nd_misc_pbar_inc(void);
void      nd_misc_pbar_clear(void);
void      nd_misc_pbar_start_activity(void);
void      nd_misc_pbar_stop_activity(void);

void      nd_misc_menu_adjust(void);
void      nd_misc_popupmenu_adjust(GtkWidget *w);

void      nd_misc_set_windowtitle(char *filename);

void      nd_misc_tcpdump_list_remove_selected_rows(void);
void      nd_misc_tcpdump_list_incomplete_column_visibility(gboolean visible);
void      nd_misc_tcpdump_list_set_row_incomplete(int row, gboolean incomplete);

int       nd_misc_can_exec(char *filename);
#endif
     
