/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_tcb_h
#define __nd_tcb_h

#ifdef LINUX
#define __FAVOR_BSD
#endif
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

#include <nd_packet.h>

typedef struct nd_tcb
{
  u_int32_t      snd_ip;
  u_int32_t      snd_seq;
  u_int32_t      rec_ip;
  u_int32_t      rec_seq;
}
ND_TCB;


void        nd_tcb_init(void);
void        nd_tcb_clear(void);
ND_TCB     *nd_tcb_lookup(ND_Packet *p);
void        nd_tcb_insert(ND_Packet *p);
void        nd_tcb_remove(ND_Packet *p);
gboolean    nd_tcb_rec_known(ND_TCB *tcb);
void        nd_tcb_set_rec(ND_TCB *tcb, ND_Packet *p);
gboolean    nd_tcb_get_rel_seq(ND_TCB *tcb, ND_Packet *p,
			       u_int32_t *seq_start, u_int32_t *seq_end);
u_int32_t   nd_tcb_get_rel_ack(ND_TCB *tcb, ND_Packet *p, gboolean force_rel);

#endif
     
