/*  backend.h
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  Netspeed Applet was writen by Jrgen Scheibengruber <mfcn@gmx.de>
 */

#ifndef _BACKEND_H
#define _BACKEND_H

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <glib.h>
#ifdef USE_GLIBTOP
#include <glibtop/netload.h>
#endif

/* Some information about the selected network device
 */
typedef struct
{
	char *name;
	char *ip;
	char *netmask; 
	char *hwaddr;
	char *ptpip;
	gboolean up, running;
	guint64 tx, rx;
} DevInfo;

GList*
get_available_devices();

void
free_devices_list(GList *list);

void
free_device_info(DevInfo *devinfo);

DevInfo
get_device_info(const char *device);

gboolean
compare_device_info(const DevInfo *a, const DevInfo *b);

#endif /* _BACKEND_H */
