/*
 * Decompiled with CFR 0.152.
 */
package bossa.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HashMultiTable {
    private HashMap table = new HashMap();
    private int elementCount = 0;

    public boolean containsKey(Object key) {
        return this.table.containsKey(key);
    }

    public Object getLast(Object key) {
        Bucket bucket = (Bucket)this.table.get(key);
        if (bucket == null) {
            return null;
        }
        return bucket.value;
    }

    public void put(Object key, Object value) {
        Bucket bucket = (Bucket)this.table.get(key);
        this.table.put(key, new Bucket(value, bucket));
        ++this.elementCount;
    }

    public void remove(Object key, Object value) {
        Bucket bucket = (Bucket)this.table.get(key);
        if (bucket == null) {
            return;
        }
        if (bucket.value == value) {
            if (bucket.next == null) {
                this.table.remove(key);
            } else {
                this.table.put(key, bucket.next);
            }
            --this.elementCount;
            return;
        }
        do {
            if (bucket.next == null || bucket.next.value != value) continue;
            bucket.next = bucket.next.next;
            --this.elementCount;
            return;
        } while ((bucket = bucket.next) != null);
    }

    public List getAll(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        Bucket walker = (Bucket)this.table.get(key);
        while (walker != null) {
            res.add(walker.value);
            walker = walker.next;
        }
        return res;
    }

    public int elementCount(Object key) {
        return Bucket.size((Bucket)this.table.get(key));
    }

    public int elementCount() {
        return this.elementCount;
    }

    public int keyCount() {
        return this.table.size();
    }

    public String toString() {
        return this.table.toString();
    }

    private static class Bucket {
        Object value;
        Bucket next;

        Bucket(Object value, Bucket next) {
            this.value = value;
            this.next = next;
        }

        static int size(Bucket bucket) {
            int result = 0;
            Bucket walker = bucket;
            while (walker != null) {
                ++result;
                walker = walker.next;
            }
            return result;
        }

        public String toString() {
            if (this.next == null) {
                return String.valueOf(this.value);
            }
            return this.value + ";" + this.next.toString();
        }
    }
}

