/* Watch stuff in the prefs workspace.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your watch) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/* Group watches with this.
 */

#define TYPE_WATCHGROUP (watchgroup_get_type())
#define WATCHGROUP( obj ) \
	(G_TYPE_CHECK_INSTANCE_CAST( (obj), TYPE_WATCHGROUP, Watchgroup ))
#define WATCHGROUP_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_CAST( (klass), TYPE_WATCHGROUP, WatchgroupClass))
#define IS_WATCHGROUP( obj ) \
	(G_TYPE_CHECK_INSTANCE_TYPE( (obj), TYPE_WATCHGROUP ))
#define IS_WATCHGROUP_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_TYPE( (klass), TYPE_WATCHGROUP ))
#define WATCHGROUP_GET_CLASS( obj ) \
	(G_TYPE_INSTANCE_GET_CLASS( (obj), TYPE_WATCHGROUP, WatchgroupClass ))

typedef struct _Watchgroup {
	iContainer parent_object;

	/* Workspaces we work within. Assume we are destroyed before this.
	 */
	Workspacegroup *workspacegroup;

	/* Name of workspace our watchers check for their syms.
	 */
	const char *name;

	/* Autosave timeout ... save our workspace automatically when this
	 * ticks away.
	 */
	guint auto_save_timeout;
} Watchgroup;

typedef struct _WatchgroupClass {
	iContainerClass parent_class;

	/* One of the watches in this group has changed. 
	 * People interested in several watches can connect to
	 * this, rather than having to try listening for many "changed" signals
	 * on the watches.
	 */
	void (*watch_changed)( Watchgroup *, Watch * );
} WatchgroupClass;

GType watchgroup_get_type( void );
Watchgroup *watchgroup_new( Workspacegroup *workspacegroup, const char *name );
void watchgroup_flush( Watchgroup *watchgroup );

/* Abstract base class for something that watches a row.
 */

#define TYPE_WATCH (watch_get_type())
#define WATCH( obj ) \
	(G_TYPE_CHECK_INSTANCE_CAST( (obj), TYPE_WATCH, Watch ))
#define WATCH_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_CAST( (klass), TYPE_WATCH, WatchClass))
#define IS_WATCH( obj ) \
	(G_TYPE_CHECK_INSTANCE_TYPE( (obj), TYPE_WATCH ))
#define IS_WATCH_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_TYPE( (klass), TYPE_WATCH ))
#define WATCH_GET_CLASS( obj ) \
	(G_TYPE_INSTANCE_GET_CLASS( (obj), TYPE_WATCH, WatchClass ))

typedef void (*WatchCallbackFn)( void * );

struct _Watch {
	iContainer parent_class;

	Row *row;			/* Row we watch */
	gboolean ok;			/* Value read OK on last change */

	guint destroy_sid;		/* Listen for events */
	guint changed_sid;
};

typedef struct _WatchClass {
	iContainerClass parent_class;

	/* Update value from row.
	 */
	gboolean (*update)( Watch * );

	/* Get a pointer to value.
	 */
	void *(*get_value)( Watch * );
} WatchClass;

Watch *watch_find( Watchgroup *watchgroup, const char *name );
GtkType watch_get_type( void );
void watch_relink_all( void );
void watch_vset( Watch *watch, const char *fmt, va_list args );
void watch_set( Watch *watch, const char *fmt, ... );

/* A watch that watches something with an int value.
 */

typedef struct _WatchInt WatchInt;

#define TYPE_WATCH_INT (watch_int_get_type())
#define WATCH_INT( obj ) \
	(G_TYPE_CHECK_INSTANCE_CAST( (obj), TYPE_WATCH_INT, WatchInt ))
#define WATCH_INT_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_CAST( (klass), TYPE_WATCH_INT, WatchIntClass))
#define IS_WATCH_INT( obj ) \
	(G_TYPE_CHECK_INSTANCE_TYPE( (obj), TYPE_WATCH_INT ))
#define IS_WATCH_INT_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_TYPE( (klass), TYPE_WATCH_INT ))
#define WATCH_INT_GET_CLASS( obj ) \
	(G_TYPE_INSTANCE_GET_CLASS( (obj), TYPE_WATCH_INT, WatchIntClass ))

struct _WatchInt {
	Watch parent_class;

	int value;
};

typedef struct _WatchIntClass {
	WatchClass parent_class;

} WatchIntClass;

GtkType watch_int_get_type( void );
int watch_int_get( Watchgroup *, const char *name, int fallback );

/* A watch that watches something with a double value.
 */

typedef struct _WatchDouble WatchDouble;

#define TYPE_WATCH_DOUBLE (watch_double_get_type())
#define WATCH_DOUBLE( obj ) \
	(G_TYPE_CHECK_INSTANCE_CAST( (obj), TYPE_WATCH_DOUBLE, WatchDouble ))
#define WATCH_DOUBLE_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_CAST( (klass), TYPE_WATCH_DOUBLE, WatchDoubleClass))
#define IS_WATCH_DOUBLE( obj ) \
	(G_TYPE_CHECK_INSTANCE_TYPE( (obj), TYPE_WATCH_DOUBLE ))
#define IS_WATCH_DOUBLE_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_TYPE( (klass), TYPE_WATCH_DOUBLE ))
#define WATCH_DOUBLE_GET_CLASS( obj ) \
	(G_TYPE_INSTANCE_GET_CLASS( (obj), TYPE_WATCH_DOUBLE, \
		WatchDoubleClass ))

struct _WatchDouble {
	Watch parent_class;

	double value;
};

typedef struct _WatchDoubleClass {
	WatchClass parent_class;

} WatchDoubleClass;

GtkType watch_double_get_type( void );
double watch_double_get( Watchgroup *, const char *name, double fallback );

/* A watch that watches a path.
 */

typedef struct _WatchPath WatchPath;

#define TYPE_WATCH_PATH (watch_path_get_type())
#define WATCH_PATH( obj ) \
	(G_TYPE_CHECK_INSTANCE_CAST( (obj), TYPE_WATCH_PATH, WatchPath ))
#define WATCH_PATH_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_CAST( (klass), TYPE_WATCH_PATH, WatchPathClass))
#define IS_WATCH_PATH( obj ) \
	(G_TYPE_CHECK_INSTANCE_TYPE( (obj), TYPE_WATCH_PATH ))
#define IS_WATCH_PATH_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_TYPE( (klass), TYPE_WATCH_PATH ))
#define WATCH_PATH_GET_CLASS( obj ) \
	(G_TYPE_INSTANCE_GET_CLASS( (obj), TYPE_WATCH_PATH, WatchPathClass ))

struct _WatchPath {
	Watch parent_class;

	GSList *value;
};

typedef struct _WatchPathClass {
	WatchClass parent_class;

} WatchPathClass;

GtkType watch_path_get_type( void );
GSList *watch_path_get( Watchgroup *, const char *name, GSList *fallback );

typedef struct _WatchBool WatchBool;

#define TYPE_WATCH_BOOL (watch_bool_get_type())
#define WATCH_BOOL( obj ) \
	(G_TYPE_CHECK_INSTANCE_CAST( (obj), TYPE_WATCH_BOOL, WatchBool ))
#define WATCH_BOOL_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_CAST( (klass), TYPE_WATCH_BOOL, WatchBoolClass))
#define IS_WATCH_BOOL( obj ) \
	(G_TYPE_CHECK_INSTANCE_TYPE( (obj), TYPE_WATCH_BOOL ))
#define IS_WATCH_BOOL_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_TYPE( (klass), TYPE_WATCH_BOOL ))
#define WATCH_BOOL_GET_CLASS( obj ) \
	(G_TYPE_INSTANCE_GET_CLASS( (obj), TYPE_WATCH_BOOL, WatchBoolClass ))

struct _WatchBool {
	Watch parent_class;

	gboolean value;
};

typedef struct _WatchBoolClass {
	WatchClass parent_class;

} WatchBoolClass;

GtkType watch_bool_get_type( void );
gboolean watch_bool_get( Watchgroup *, const char *name, gboolean fallback );

typedef struct _WatchString WatchString;

#define TYPE_WATCH_STRING (watch_string_get_type())
#define WATCH_STRING( obj ) \
	(G_TYPE_CHECK_INSTANCE_CAST( (obj), TYPE_WATCH_STRING, WatchString ))
#define WATCH_STRING_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_CAST( (klass), TYPE_WATCH_STRING, WatchStringClass))
#define IS_WATCH_STRING( obj ) \
	(G_TYPE_CHECK_INSTANCE_TYPE( (obj), TYPE_WATCH_STRING ))
#define IS_WATCH_STRING_CLASS( klass ) \
	(G_TYPE_CHECK_CLASS_TYPE( (klass), TYPE_WATCH_STRING ))
#define WATCH_STRING_GET_CLASS( obj ) \
	(G_TYPE_INSTANCE_GET_CLASS( (obj), TYPE_WATCH_STRING, \
		WatchStringClass ))

struct _WatchString {
	Watch parent_class;

	char *value;
};

typedef struct _WatchStringClass {
	WatchClass parent_class;

} WatchStringClass;

GtkType watch_string_get_type( void );
const char *watch_string_get( Watchgroup *, 
	const char *name, const char *fallback );
