if (typeof test === 'undefined') require('../test');

test('abs', function () {

  function t(expected, value){
    test.areEqual(String(expected), new Big(String(value)).abs().toString());
  }

  Big.DP = 20;
  Big.RM = 1;

  t(1, 1);
  t(1, -1);
  t(0.5, '0.5');
  t(0.5, '-0.5');
  t(0.1, 0.1);
  t(0.1, -0.1);
  t(1.1, 1.1);
  t(1.1, -1.1);
  t(1.5, '1.5');
  t(1.5, '-1.5');

  t(0.00001, '-1e-5');
  t(9000000000, '-9e9');
  t(123456.7891011, -123456.7891011);
  t(999.999, '-999.999');
  t(99, 99);
  t(1, new Big(-1));
  t(0.001, new Big(0.001));
  t(0.001, new Big('-0.001'));
  t(0, 0);
  t(0, -0);

  var minusZero = 1 / (-1 / 0);

  t(0, 0);
  t(0, -0);
  t(0, minusZero);

  test.isNegativeZero(new Big('-0'));
  test.isNegativeZero(new Big(minusZero));
  test.isPositiveZero(new Big(-0).abs());
  test.isPositiveZero(new Big('-0').abs());
  test.isPositiveZero(new Big(minusZero).abs());

  t(Number.MIN_VALUE, Number.MIN_VALUE);
  t(Number.MIN_VALUE, -Number.MIN_VALUE);
  t(Number.MAX_VALUE, Number.MAX_VALUE);
  t(Number.MAX_VALUE, -Number.MAX_VALUE);

  var two_30 = 1 << 30;

  t(two_30, two_30);
  t(two_30, -two_30);

  t(two_30 + 1, two_30 + 1);
  t(two_30 + 1, -two_30 - 1);

  t(two_30 - 1, two_30 - 1);
  t(two_30 - 1, -two_30 + 1);

  var two_31 = 2 * two_30;

  t(two_31, two_31);
  t(two_31, -two_31);

  t(two_31 + 1, two_31 + 1);
  t(two_31 + 1, -two_31 - 1);

  t(two_31 - 1, two_31 - 1);
  t(two_31 - 1, -two_31 + 1);

  t('0', '0');
  t('1', '-1');
  t('11.121', '11.121');
  t('0.023842', '-0.023842');
  t('1.19', '-1.19');
  t('9.622e-11', '-0.00000000009622');
  t('5.09e-10', '-0.000000000509');
  t('3838.2', '3838.2');
  t('127', '127.0');
  t('4.23073', '4.23073');
  t('2.5469', '-2.5469');
  t('29949', '-29949');
  t('277.1', '-277.10');
  t('4.97898e-15', '-0.00000000000000497898');
  t('53.456', '53.456');
  t('100564', '-100564');
  t('12431.9', '-12431.9');
  t('97633.7', '-97633.7');
  t('220', '220');
  t('188.67', '-188.67');
  t('35', '-35');
  t('2.6', '-2.6');
  t('2.2e-19', '-0.000000000000000000220');
  t('1.469', '-1.469');
  t('150.7', '-150.7');
  t('74', '-74');
  t('3.52e-9', '-0.00000000352');
  t('2221.7', '-2221.7');
  t('0.000004211', '-0.000004211');
  t('1', '-1');
  t('5.886', '-5.886');
  t('16', '16');
  t('4.4493e-9', '0.0000000044493');
  t('47.6', '47.6');
  t('1.6', '-1.60');
  t('1', '-1');
  t('1.5', '-1.5');
  t('5', '-5');
  t('1', '-1');
  t('8027', '8027');
  t('6.36e-16', '-0.000000000000000636');
  t('3.87766', '3.87766');
  t('7.4', '-7.4');
  t('4.449', '-4.449');
  t('5.2218e-19', '-0.000000000000000000522180');
  t('1.3769e-11', '-0.000000000013769');
  t('7.898e-13', '-0.0000000000007898');
  t('522.9', '-522.9');
  t('16.1', '-16.1');
  t('2.15', '2.15');
  t('4.3', '4.3');
  t('3', '-3');
  t('2.8', '-2.8');
  t('1', '-1');
  t('0.0000128696', '-0.0000128696');
  t('13.33', '-13.33');
  t('0.00000132177', '-0.00000132177');
  t('1.41516', '-1.41516');
  t('180.4', '-180.4');
  t('115079', '-115079');
  t('959', '959');
  t('714.4', '714.4');
  t('1.4544', '1.4544');
  t('53.691', '53.691');
  t('2.03832e-12', '-0.00000000000203832');
  t('1', '-1');
  t('10.8', '10.8');
  t('6189.2', '-6189.2');
  t('6.30866', '6.30866');
  t('62306', '62306');
  t('4', '-4.0');
  t('997.1', '-997.1');
  t('27.4', '-27.40');
  t('9242', '9242');
  t('31.1', '-31.1');
  t('23.4', '23.4');
  t('451818', '-451818');
  t('7', '-7');
  t('1.9', '-1.9');
  t('2', '-2');
  t('112.983', '-112.983');
  t('9.36e-8', '-0.0000000936');
  t('12.8515', '12.8515');
  t('73.1', '-73.1');
  t('18.15', '18.150');
  t('11997.8', '11997.8');
  t('23.1', '-23.1');
  t('82.022', '-82.022');
  t('3.916e-20', '-0.00000000000000000003916');
  t('3.3', '-3.3');
  t('892.1', '-892.1');
  t('24.4', '24.4');
  t('72', '72.0');
  t('0.0013346', '0.0013346');
  t('10.4', '-10.4');
  t('367.5', '367.5');
  t('7', '-7');
  t('127.195', '127.195');
  t('7.89e-13', '-0.000000000000789');
  t('63', '-63');
  t('85821.2', '-85821.2');
  t('95.6', '95.6');
  t('8.9e-14', '-0.000000000000089');
  t('112.1', '-112.1');
  t('3.68', '-3.68');
  t('9', '-9');
  t('0.0000975', '-0.0000975');
  t('393.6', '-393.6');
  t('7.4', '-7.4');
  t('69.62', '-69.62');
  t('5201.3', '5201.3');
  t('163', '163');
  t('4.30732', '4.30732');
  t('224.49', '-224.49');
  t('319.8', '-319.8');
  t('88.1', '-88.1');
  t('2.7762e-8', '0.000000027762');
  t('2.043e-7', '-0.0000002043');
  t('75459.3', '-75459.3');
  t('0.178', '0.178');
  t('0.00001633', '0.00001633');
  t('955', '955');
  t('373898', '-373898');
  t('9780.1', '9780.1');
  t('503.47', '503.47');
  t('3.44562', '-3.44562');
  t('1.6', '-1.6');
  t('1.22442', '-1.22442');
  t('1.4', '1.4');
  t('1219.1', '-1219.1');
  t('2.7', '-2.7');
  t('1057', '-1057');
  t('1938', '1938');
  t('1.1983', '1.1983');
  t('0.0012', '-0.0012');
  t('95.713', '-95.713');
  t('2', '-2');
  t('17.24', '-17.24');
  t('10.3', '-10.3');
  t('1', '-1');
  t('65.8', '-65.8');
  t('2.9', '2.9');
  t('54149', '54149');
  t('8', '-8');
  t('1', '1.0');
  t('4', '-4');
  t('6.3', '-6.3');
  t('5.25e-9', '0.00000000525');
  t('52.3', '-52.3');
  t('75290', '-75290');
  t('5.9', '-5.9');
  t('13.7', '13.7');
  t('2.3982e-9', '0.0000000023982');
  t('91.5', '-91.50');
  t('2072.39', '2072.39');
  t('385.6', '385.6');
  t('4.77', '4.77');
  t('18.72', '18.720');
  t('2817', '-2817');
  t('44535', '-44535');
  t('655', '655');
  t('2e-15', '-0.0000000000000020');
  t('0.625', '0.6250');
  t('2', '-2');
  t('5.315', '5.315');
  t('70.9', '70.90');
  t('6.4', '6.4');
  t('1824', '1824');
  t('52.595', '52.595');
  t('3662', '3662.0');
  t('3.1', '3.1');
  t('1.05032e-7', '0.000000105032');
  t('997.063', '-997.063');
  t('41746', '-41746');
  t('24.0402', '24.0402');
  t('0.009135', '0.009135');
  t('2.34e-9', '-0.00000000234');
  t('13.1', '13.1');
  t('228.8', '228.8');
  t('565.85', '565.85');
  t('4e-20', '0.000000000000000000040');
  t('1.73', '1.73');
  t('38.9', '38.9');
  t('1.02e-14', '-0.0000000000000102');
  t('302.8', '-302.8');
  t('7', '-7');
  t('1', '-1');
  t('0.00247', '0.00247');
  t('2', '-2');
  t('3.26', '-3.26');
  t('8.8', '8.8');
  t('90.6', '90.6');
  t('8.3053e-17', '-0.000000000000000083053');
  t('2.5', '-2.5');
  t('376.2', '-376.2');
  t('1.29', '1.29');
  t('1.379', '-1.379');
  t('40921.5', '-40921.5');
  t('1', '-1');
  t('12.5', '12.5');
  t('10.1', '10.1');
  t('1', '-1');
  t('226636', '226636');
  t('1', '-1');
  t('1.7', '-1.7');
  t('31.31', '31.31');
  t('79.9', '-79.9');
  t('4.027e-13', '0.0000000000004027');
  t('43.838', '43.838');
  t('6.47', '-6.47');
  t('5.292e-19', '0.0000000000000000005292');
  t('4.6', '-4.6');
  t('15918', '-15918.0');
  t('239.45', '239.45');
  t('1.02', '-1.02');
  t('14101', '-14101');
  t('7', '-7');
  t('367.34', '367.34');
  t('5', '-5');
  t('19.9', '-19.9');
  t('269.45', '-269.45');
  t('10.34', '-10.34');
  t('3.32882e-12', '-0.00000000000332882');
  t('5.9', '5.9');
  t('9', '-9.0');
  t('1.3597', '-1.3597');
  t('8', '8.0');
  t('1', '1.0');
  t('312.5', '312.5');
  t('1.554', '-1.554');
  t('210.985', '-210.985');
  t('1', '-1');
  t('1.24', '-1.24');
  t('513865', '-513865');
  t('6748', '-6748');
  t('591.51', '-591.51');
  t('2.2', '-2.2');
  t('19.5495', '19.5495');
  t('3.3', '3.3');
  t('30', '-30');
  t('94', '-94');
  t('217.55', '217.55');
  t('2', '-2');
  t('99', '99');
  t('4.067', '-4.067');
  t('702.57', '702.57');
  t('3.7', '-3.70');
  t('4', '4.0');
  t('192944', '192944');
  t('0.000022', '0.000022');
  t('47.6', '47.60');
  t('0.391', '0.3910');
  t('35', '-35');
  t('100', '-100');
  t('3.3', '-3.3');
  t('32.432', '32.432');
  t('1.07849e-18', '0.00000000000000000107849');
  t('2', '-2.0');
  t('23.27', '23.27');
  t('4.054e-15', '-0.000000000000004054');
  t('7.6', '-7.6');
  t('1305', '1305');
  t('1.501', '-1.501');
  t('3.4', '3.4');
  t('22.5', '-22.5');
  t('1.0916', '1.0916');
  t('2', '-2');
  t('58.271', '58.271');
  t('1.73e-12', '0.00000000000173');
  t('1.3458e-15', '0.0000000000000013458');
  t('309.87', '-309.87');
  t('5.318', '-5.318');
  t('1.5302e-8', '0.000000015302');
  t('596765', '596765');
  t('54.42', '-54.42');
  t('6.549e-20', '0.00000000000000000006549');
  t('29', '29');
  t('46.025', '46.025');
  t('2556.78', '-2556.78');
  t('0.00287721', '0.00287721');
  t('1.63', '-1.63');
  t('0.00041', '0.00041');
  t('698', '698');
  t('134.4', '134.4');
  t('2.1', '2.1');
  t('2.07', '-2.07');
  t('122.869', '122.869');
  t('0.00017', '-0.00017');
  t('18.6', '18.6');
  t('7', '-7');
  t('0.0180557', '0.0180557');
  t('5', '-5');
  t('6.2', '-6.2');
  t('8', '-8');
  t('450.96', '-450.96');
  t('20.2', '-20.2');
  t('176.52', '176.52');
  t('0.00017', '-0.000170');
  t('5', '-5');
  t('1', '-1');
  t('1.37856e-14', '0.0000000000000137856');
  t('76.3048', '76.3048');
  t('1803.7', '-1803.7');
  t('74', '74');
  t('1.7e-12', '0.0000000000017');
  t('48.7', '-48.7');
  t('4.48', '-4.48');
  t('1.4', '-1.4');
  t('7.69', '-7.69');
  t('23.5987', '23.5987');
  t('3074', '3074.0');
  t('8.06e-15', '-0.00000000000000806');
  t('21.3757', '-21.3757');
  t('35', '35');
  t('11.056', '11.0560');
  t('3.36e-14', '-0.0000000000000336');
  t('49139.4', '-49139.4');
  t('32.654', '-32.654');
  t('34035.4', '34035.4');
  t('15.22', '15.22');
  t('62', '62.0');
  t('8.89156', '-8.89156');
  t('14', '14');
  t('0.006', '-0.0060');
  t('1.5', '1.5');
  t('7', '-7');
  t('1.6e-11', '0.000000000016');
  t('26.6427', '26.6427');
  t('1.5e-18', '-0.0000000000000000015');
  t('1.52838e-15', '0.00000000000000152838');
  t('119.1', '119.1');
  t('0.004283', '0.004283');
  t('818', '-818');
  t('194', '194');
  t('104.788', '-104.788');
  t('3.74e-11', '0.0000000000374');
  t('6.162', '-6.162');
  t('5.19214e-18', '-0.00000000000000000519214');
  t('1.4', '-1.4');
  t('1.27', '-1.27');
  t('7.83822e-12', '-0.00000000000783822');
  t('1', '-1');
  t('4.4', '4.4');
  t('7.37382e-12', '0.00000000000737382');
  t('13.618', '13.618');
  t('1.03', '-1.03');
  t('3.7457e-13', '0.00000000000037457');
  t('5.2', '-5.2');
  t('3.5', '3.5');
  t('364', '-364');
  t('7.336', '7.336');
  t('1.1447e-16', '-0.00000000000000011447');
  t('510.63', '-510.63');
  t('5.8', '5.8');
  t('7.8', '7.8');
  t('2.96', '-2.96');
  t('15.64', '-15.64');
  t('187863', '-187863');
  t('2.73', '-2.73');
  t('2.671', '-2.671');
  t('18.179', '-18.179');
  t('855885', '855885');
  t('4.16', '4.16');
  t('5.722e-18', '0.000000000000000005722');
  t('67.62', '67.62');
  t('813.31', '813.31');
  t('40.2', '40.20');
  t('0.00002515', '0.00002515');
  t('0.0196', '0.01960');
  t('13.165', '13.165');
  t('6.743', '-6.743');
  t('1', '-1');
  t('200.56', '-200.56');
  t('1.932', '1.932');
  t('92.9', '92.90');
  t('16.74', '16.74');
  t('4.5554e-7', '-0.00000045554');
  t('2.1296e-15', '-0.0000000000000021296');
  t('2.088', '2.088');
  t('2577', '2577');
  t('45.4', '-45.4');
  t('41.3', '-41.3');
  t('3.63', '-3.63');
  t('1.09', '-1.09');
  t('1', '-1');
  t('3.7', '-3.7');
  t('204.54', '204.54');
  t('235.6', '235.6');
  t('384', '-384');
  t('0.0207', '0.02070');
  t('680', '680');
  t('1.09', '1.09');
  t('109.2', '109.2');
  t('0.00010117', '0.00010117');
  t('13.81', '13.81');
  t('192.3', '192.3');
  t('1', '-1');
  t('1.2', '1.2');
  t('4.1', '-4.1');
  t('2.5', '2.5');
  t('8.4076', '-8.4076');
  t('0.0517', '0.0517');
  t('6.3923', '-6.3923');
  t('506.179', '-506.179');
  t('375886', '375886');
  t('618858', '-618858');
  t('8.5e-11', '0.000000000085');
  t('6', '-6.0');
  t('2.4', '2.40');
  t('0.0000013', '-0.0000013');
  t('1.064', '-1.064');
  t('1', '-1');
  t('4', '-4');
  t('4.5', '-4.5');
  t('93.6206', '93.6206');
  t('3.07e-18', '0.00000000000000000307');

  t('52.452468128', '-5.2452468128e+1');
  t('14152590525718936.5008396', '1.41525905257189365008396e+16');
  t('274306808392.8', '2.743068083928e+11');
  t('1.52993064722314247378724599e+26', '-1.52993064722314247378724599e+26');
  t('37205576746', '3.7205576746e+10');
  t('868099644460934347.2665', '8.680996444609343472665e+17');
  t('1254.549', '1.254549e+3');
  t('6.23417196172381875892300762819e-18', '6.23417196172381875892300762819e-18');
  t('13117994082191928443.1', '1.31179940821919284431e+19');
  t('97697726.168', '9.7697726168e+7');
  t('2.663e-10', '-2.663e-10');
  t('1052', '1.052e+3');
  t('3.815873266712e-20', '-3.815873266712e-20');
  t('18', '1.8e+1');
  t('1.033525906631680944018544811261e-13', '1.033525906631680944018544811261e-13');
  t('3.805493087068952925e-11', '-3.805493087068952925e-11');
  t('0.0173948', '1.73948e-2');
  t('5.784e-15', '5.784e-15');
  t('4.448338479762497e-8', '4.448338479762497e-8');
  t('390080230.52', '3.9008023052e+8');
  t('3', '3e+0');
  t('8.61435e-9', '8.61435e-9');
  t('43.7', '-4.37e+1');
  t('8.4034159379836e-18', '-8.4034159379836e-18');
  t('20028573.55721079885824481', '2.002857355721079885824481e+7');
  t('7000871.862', '-7.000871862e+6');
});
