import java.util.*;
import java.io.*;
import java.net.*;
import java.sql.*;

public class ODBCServer {
  private Connection connection;

  private boolean checkForWarning (SQLWarning warn) {
    boolean rc = false;

    // If a SQLWarning object was given, display the
    // warning messages.  Note that there could be
    // multiple warnings chained together
    try {
      if (warn != null) {
    	System.out.println ("\n *** Warning ***\n");
    	rc = true;
    	while (warn != null) {
    	  System.out.println ("SQLState: " +
    			      warn.getSQLState ());
    	  System.out.println ("Message:  " +
    			      warn.getMessage ());
    	  System.out.println ("");
    	  warn = warn.getNextWarning ();
    	}
      }
      return rc;
    } catch(Exception e) {
      return(true);
    }
  }

  public ODBCServer(String dbName) {
    try {
      Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        
      connection = DriverManager.getConnection("jdbc:odbc:NTOP");
      checkForWarning(connection.getWarnings());
      //connection.setAutoCommit(true); // Automatic transaction commitment
    } catch (Exception e) {
      e.printStackTrace();
      System.exit(-1);
    }
  }

  public void executeStatement(String statement) {
       PreparedStatement stmt;
       int rc;
       
        try {
          stmt = connection.prepareStatement(statement); // Insert record in the HostInfo table
          rc = stmt.executeUpdate();
          stmt.close(); // Close the statement
        } catch(Exception ex) {
          ex.printStackTrace();
        }
  }
  
  
  public static void main(String args[])
  {
        byte buffer[];
        int bufLength = 1514;
        ODBCServer odbcServer;
        DatagramSocket socket = null;
        DatagramPacket pkt;
        
        System.out.println("Starting up...");
        
        try {
            socket = new DatagramSocket(4000);
        } catch (Exception e) {
          e.printStackTrace();
          System.exit(-1);
        }
       
        buffer = new byte[bufLength];
        pkt = new DatagramPacket(buffer, buffer.length);
        odbcServer = new ODBCServer("NTOP");
        
        while(true) {
            try {
               socket.receive(pkt);    
               String statement = new String(buffer, 0, pkt.getLength());
               
               System.out.println("["+pkt.getLength()+"] '"+statement+"'");  
               
               odbcServer.executeStatement(statement);
               
               pkt.setLength(bufLength);
            } catch (Exception e) {
              e.printStackTrace();
            }
        }

        /*
        socket.close();
        System.out.println("Done.");
        */
  }

}
