/*
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 * close.c - close a network interface.
 *
 * Luca Deri     <deri@ntop.org>
 * Rocco Carbone <rocco@ntop.org>
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
 * ntop header file(s)
 */
#include "ntop.h"

#include "intop.h"


/*
 * Deallocate a LBNL packet capture descriptor
 * and close network resources.
 */
int intop_close (int argc, char * argv [])
{
  /*
   * Notice the command name.
   */
  char * commandname = argv [0];

  int c;
#define USAGE(xxx) \
  printf ("Usage: %s [-h]\n\
           [-i interface]\n", xxx)
  char * optstring = "hi:";

  /*
   * Reserve here space for the local variables.
   */
  char * interface = NULL;
  int current;

  optind = 0;
  optarg = NULL;

  /*
   * Parse command line options to the application via standard system calls.
   */
  while ((c = getopt (argc, argv, optstring)) != -1)
    {
      switch (c)
	{
	case 'h':
	  USAGE (commandname);
	  return (0);

	default:
	  USAGE (commandname);
	  return (-1);

	case 'i':
	  interface = optarg;
	  break;
	}
    }

  if (optind < argc)
    {
      printf ("\nWrong option(s): \" ");
      while (optind < argc)
	printf ("%s ", argv [optind ++]);
      printf ("\"\n");
      USAGE (commandname);
      printf ("\n");
      return (-1);
    }


  /*
   * Safe to play with the 'active' interface (if any)
   * in case no specific one was chosen by the user.
   */
  if (! interface && ! (interface = intop_interface (active)))
    {
      printf ("%s: no interface is currently enabled for packet sniffing.\n", commandname);
      return (-1);
    }

  /*
   * Lookup for the given name in the table of enabled interfaces.
   */
  current = intop_lookup_interface (interface);
  if (current == -1)
    {
      printf ("%s: unknown interface %s.\n", commandname, interface);
      return (-1);
    }

  /*
   * Time to close LBNL pcap for the specified interface.
   */
  pcap_close (intop_pcap (current));

  /*
   * Free the descriptor in the table of network interfaces.
   */
  intopfree (current);

  if (current == active)
    {
      active = previous;
      previous = -1;
    }
  else if (current == previous)
    previous = -1;

  /*
   * Update user prompt to include the previous interface (if any).
   */
  userprompt (intop_interface (active));

  /*
   * Additional initialization only to make happy the ntop engine.
   */

  numDevices --;

  device [numDevices] . pcapPtr = NULL;
  strcpy (device [numDevices] . name, "");
  /* strcpy (& device[numDevices] . ifAddr, ""); */

  device [numDevices] . network . s_addr = 0L;
  device [numDevices] . netmask . s_addr   = 0L;

  device [numDevices] . datalink = 0;

  return (0);
}
