/*
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 * init.c - perform all initialization steps for the ntop engine.
 *
 * Luca Deri     <deri@ntop.org>
 * Rocco Carbone <rocco@ntop.org>
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
 * ntop header file(s)
 */
#include "ntop.h"

/*
 * Initialize all variables used at run-time by ntop engine.
 *
 * Shamelessly ripped from ntop's main.c source file
 * and adapted to do the job.
 */
void intop_init (void)
{
  static int initialized = 0;     /* true if the ntop engine has been initialized */

  /* Initialization of local variables */
  char rulesFile[128];
  char * localAddresses = NULL;
  char flowSpecs[2048];

  if (initialized)
    return;

  printf ("Initializing intop engine.... Please wait.\n");
  fflush (stdout);

  isLsofPresent  = 0;
  isNmapPresent  = 0;

  rulesFile[0] = '\0';
  flowSpecs[0] = '\0';
  flowsList = NULL;
  logTimeout = 0;
  tcpChain = NULL, udpChain = NULL, icmpChain = NULL;

  numericFlag=0;
  rFileName=NULL;

  domainName[0] = '\0';

  actTime = time(NULL);
  strcpy(dbPath, ".");

  initIPServices ();
  initGlobalValues ();

  if(numIpProtosToMonitor == 0)
    addDefaultProtocols ();
  
  initGdbm();

  if(localAddresses != NULL) {
    handleLocalAddresses(localAddresses);
    free(localAddresses);
    localAddresses = NULL;
  }

  initDeviceDatalink();

  /* Handle flows (if any) */
  if(flowSpecs[0] != '\0')
    handleFlowsSpecs(flowSpecs);

  /*
   * Please avoid to merge interfaces.
   */

  /*
   * ASK LUCA
   */
  numDevices = 0;
  initCounters (0);

  /*
   * enable ThUpdate, IdleHosts
   * disable enableDBsupport
   */
  initThreads (1, 1, 0);

  /*
   * Done. Initialization done.
   */
  initialized = 1;
}
