#include "common.h"
#include "upscommon.h"
#include "upsconf.h"

/* public functions & variables from main.c */
extern const char *progname;
extern const char *device_name;
extern const char *device_path;
void help(void);
void usage(void);

/* functions & variables required in each driver */
/* extern const char *upsdrv_version; */
void upsdrv_initups(void);
void upsdrv_initinfo(void);
void upsdrv_updateinfo(void);
void upsdrv_shutdown(void);
void upsdrv_help(void);
void upsdrv_usage(void);
void upsdrv_banner(void);
void upsdrv_arg(int i, char *optarg);
extern const char *driver_arguments;

/* driver provides the maximum number of entities into the info[] array */
int upsdrv_infomax(void);

/* --- details for the variable/value sharing --- */

/* main calls this driver function - it needs to call addvar */
void upsdrv_makevartable(void);

/* retrieve the value of variable <var> if possible */
char *getval(const char *var);

/* see if <var> has been defined, even if no value has been given to it */
int testvar(const char *var);

/* extended variable table - used for -x defines/flags */
typedef struct {
	int	vartype;	/* VAR_* value, below			 */
	char	*var;		/* left side of =, or whole word if none */
	char	*val;		/* right side of = 			 */
	char	*desc;		/* 40 character description for -h text	 */
	int	found;		/* set once encountered, for testvar()	 */
	void	*next;
}	vartab_t;

/* flags to define types in the vartab */

#define VAR_FLAG	0x0001	/* argument is a flag (no value needed) */
#define VAR_VALUE	0x0002	/* argument requires a value setting	*/

/* callback from driver - create the table for future -x entries */
void addvar(int vartype, const char *name, const char *desc);
