/* Written to work with MicroDowell BBox UPS.
   This model is based on MicroDowell (www.microdowell.com) models.
    
   Copyright (C) 2000  Gilberto Iob <research@microdowell.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include <sys/file.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/termios.h>
#include <limits.h>

#include "config.h"
#include "proto.h"
#include "shared.h"
#include "version.h"
#include "upscommon.h"
#include "common.h"
#include "timehead.h"

#define NUM_POLLING_BYTES	16
#define NUM_MODEL_BYTES		8
#define NUM_POLLS_KO		4

#define SEND_DATA		48
#define CMD_SETTIMER		49
#define CMD_SCHEDULING		50
#define CMD_STDBY		51
#define CMD_BEND		52
#define CMD_BATTEST		53
#define CMD_BUZOFF		54
#define SEND_MODEL		58

#define STATUS			2
#define UTILITY			3
#define BATTVOLT		4
#define UPSTEMP			5
#define LOADPCT			5
#define UPS_HOUR		6
#define UPS_MIN			7
#define UPS_SEC			8
#define UPS_HOUR_ON		9
#define UPS_MIN_ON		10
#define UPS_HOUR_OFF		11
#define SD_DELAY		12
#define ACFREQ_L		13
#define ACFREQ_H		14

#define MAINS_FAILURE		1
#define LOW_BAT			2
#define END_BAT			4
#define STANDBY			8
#define HIGH_TEMP		16
#define DANGER_TEMP		32
#define FREQ_FLAG		128

#define ST_ONLINE       	0x01
#define ST_ONBATT       	0x02
#define ST_LOWBATT      	0x04  
#define ST_FAIL		      	0x08  
#define ST_BADCOM	      	0x10  

#define LOAD_T0			3
#define LOAD_T1			10
#define LOAD_T2			22
#define LOAD_T3			37
#define LOAD_T4			47


#define CHAR_DELAY		200000


enum general {SHMOK = 1U, SEC_FOR_POWERKILL = 10U, 
	      NUM_OF_BYTES_FROM_UPS = 16U, MAINS_VOLTAGE = 230U};
enum commands { BATTERY_TEST = 0x03U, SHUTDOWN = 0xbcU};
enum data {LOAD_LEVEL = 0U, BAT_LEVEL = 1U, IN_AC_VOLT = 2U, OUT_AC_VOLT = 3U, IN_AC_FREQ = 4U};

/* The following vars must be global because other parts of the NUT package
 * use them as well. */

unsigned int	sddelay = 60;		/* by default, wait 60 seconds for shutdown */
unsigned int 	line_voltage = 230U; 	/* default value */

/* 9 entries in the info array for: 
	- ACFREQ, BATTVOLT, LOADPCT, MFR, MODEL, STATUS, UTILITY, UPSTEMP, SERIAL 
	- Commands: 8 entries
	- Other 2 are for MEMBERS and MSGID. 
*/

typedef struct {
	int     	status;
	int 		upsmodel;
	float 		acfreq;
	float 		utility;
	float 		upstemp;
	float 		battvolt;
	int 		loadpct;
	unsigned char	upshour;
	unsigned char	upsmin;
	unsigned char	upssec;
	unsigned char	houron;
	unsigned char	minon;
	unsigned char	houroff;
	unsigned char	sddelay;
	int 		maxbattruntime;
	int 		battruntime;
}	upstype;

upstype		myups;

static void updateinfo (unsigned int line_voltage, char *raw_data);
