#include <sys/time.h>

#include "starttest.h"
#include "diagnostic.h"  /* FAIL() LOG() */

static int sglobalnum = 0;
static double start_time = 0;

double get_timesincestart() {
	double elapsed_time;
	struct timeval tv;
	double now;
  
	/* if we just started, record the time and return 0 */
	gettimeofday(&tv,NULL);
	now = tv.tv_sec + (tv.tv_usec / 1000000.0);
	elapsed_time = 0;

	if(start_time == 0.0) {
		start_time = now;
	} else {
		elapsed_time = now - start_time;
	}

	return (elapsed_time);
}

int 
starttest(float *result) {
	double elapsed_time;

	sglobalnum++;

	elapsed_time = get_timesincestart();
	*result = (float)elapsed_time;
	return (sglobalnum);
}

int
StartAvailable(const char *opts) {
	return 1;
}

void
StartUseSkill(  const char *opts,
		int *length,
		SkillResult **results) {
	float result;
	int rc;

	/* there is no options for startTime, so we don't need to parse
	 * the options */
	rc = starttest(&result);
	if (rc < 0) {
		AppendResult(startTime, "", 0, 0.0, length, results);
	} else {
		AppendResult(startTime, "", 1, (double)result, length, results);
	}
}

