#include "portable.h"
#include <stdio.h>
#include <sys/time.h>
#include "slap.h"
#include <ldap_pvt.h>
#include "external.h"
#include "nws_back_cache.h"
#include "nws_back.h"

#define USER_VOGRID_LIFETIME 900
#define REG_OBJ_UPDATE 300
#define SLEEP_TIME 300

void *
nws_cache_getreg(void *v)
{
  nwsBackConfig *nbc;
  struct timeval tv1, tv2;
  Rb_node rb_ptr;
  struct nws_series_collection *nser_coll;
  nwsList kill_list;
  char *kill_name;

  Debug(LDAP_DEBUG_TRACE, "==>nws_cache_getreg()\n", 0,0,0);

  nbc = (nwsBackConfig *)v;

  tv2.tv_sec = 0;

  nws_list_init(&kill_list);

  while(1) {

	if(gettimeofday(&tv1, NULL) == -1) {
	  perror("gettimeofday failed");
	}

	while((nbc->nws_reg_objs = nws_get_objs(nbc)) == NULL) {
	  Debug(LDAP_DEBUG_TRACE,
			"nws_cache_getreg(): nws_get_objs() returned NULL\n",0,0,0);
	  ldap_pvt_thread_sleep(30);
	}

	nws_cache_parse(nbc);

	if(nbc->nws_reg_objs != NULL) {
	  free(nbc->nws_reg_objs);
	}

	if (nbc->grid_count > 0) {
	  /* fix up the host collections */
	  
	  pthread_mutex_lock(&nbc->nser_coll_mutex);

	  for(rb_ptr = rb_first(nbc->nser_coll_tree);
		  rb_ptr != rb_nil(nbc->nser_coll_tree);
		  rb_ptr = rb_next(rb_ptr)) {

		nser_coll = (struct nws_series_collection *)rb_ptr->v.val; 
	    /*printf("nser_coll->name:%s\n",nser_coll->name); */

		if((!strcmp(nser_coll->type, "user")) &&
		   (nser_coll->lastseen.tv_sec + USER_VOGRID_LIFETIME <  tv1.tv_sec)) {
		  kill_name = strdup(nser_coll->name);
		  nws_list_add(&kill_list, kill_name);
		}
		else {
		  if((!strcmp(nser_coll->type, "file")) ||
			 (!strcmp(nser_coll->type, "user"))) { 
			/*printf("nser_coll->name: %s is type file.\n",nser_coll->name); */
			if(nser_coll->lastupdate.tv_sec == 0) {
			  nws_cache_infer(nbc, nbc->nws_obj_list, nser_coll);
			}
		  } 
		  else { 
			/*printf("nser_coll->name:%s is type clique\n",nser_coll->name);*/
			if(nser_coll->lastupdate.tv_sec == 0) {
			  nws_cache_relate(nbc->nws_obj_list, nser_coll);
			}
		  }
		}
	  }

	  while( (kill_name = nws_list_read(&kill_list)) != NULL ) {
		int i;
		rb_ptr = rb_find_key_n(nbc->nser_coll_tree, kill_name, &i);
		if(i != 1) {
		  printf("rb_find_key_n failed\n");
		  exit(-1);
		}
		nser_coll = (struct nws_series_collection *)rb_ptr->v.val;
		rb_delete_node(rb_ptr);
		nws_free_coll(nbc, nser_coll);
		free(kill_name);
	  }
	  
	  pthread_mutex_unlock(&nbc->nser_coll_mutex);
	}
	
	tv1.tv_sec += REG_OBJ_UPDATE; 

	while(tv1.tv_sec > tv2.tv_sec) {
 	  ldap_pvt_thread_sleep(SLEEP_TIME);  
	  if(gettimeofday(&tv2, NULL) == -1) {
		perror("gettimeofday failed");
	  }
	}
  }
}

int
nws_cache_infer(nwsBackConfig *nbc, NWSobj *nws_obj_list, struct nws_series_collection *nser_coll)
{
  NWSobj *obj;
  int i,j;
  int count;
  char buf1[512], buf2[512], buf3[512], buf4[512];
  char *tmpc1;
  struct nws_series_cache2coll **i_nc2c;
  struct timeval now;

  count = nser_coll->member_count;
/*   nser_coll->series_rel = malloc(sizeof(struct nws_series_cache2coll *) * nser_coll->member_count * nser_coll->member_count); */

  /* create a dynamically allocated 2d grid */
  for(i=0; i < count; i++) {
	nser_coll->series_rel_count++;
	nser_coll->series_rel = realloc(nser_coll->series_rel,
									sizeof(struct nws_series_cache2coll *)
									* nser_coll->series_rel_count + 1);
	nser_coll->series_rel[nser_coll->series_rel_count-1] = malloc(sizeof(struct nws_series_cache2coll *) * count);
	memset(nser_coll->series_rel[nser_coll->series_rel_count-1], 0, sizeof(struct nws_series_cache2coll *) * count);
  }

  
  for(i=0; i < count; i++) {
	i_nc2c = (struct nws_series_cache2coll **)nser_coll->series_rel[i];
	for(j=0; j < count; j++) {
	 /*  printf("%d,%d\n",i,j); */
	  if(i==j) {
		continue;
	  }
	  /* nser_coll->series_rel2[i][j] = NULL; */
	  i_nc2c[j] = malloc(sizeof(struct nws_series_cache2coll));
	  i_nc2c[j]->index0 = i;
	  i_nc2c[j]->index1 = j;
	  i_nc2c[j]->nser = NULL;
	  i_nc2c[j]->lat_nser = NULL;
	  i_nc2c[j]->ban_nser = NULL;

	  /*
	  printf("nws_cache_infer(): %s<->%s\n", nser_coll->member[i],
			 nser_coll->member[j]);
	  */

	  /* loop thru objs and try to find exact matches */
	  ldap_pvt_thread_mutex_lock(&nbc->obj_list_mutex);
	  obj = nws_obj_list;
	  while(obj != NULL) {
		if (!strcmp("nwsSeries", obj->type)) {
		  if(obj->at.ns.target != NULL) {
			if(!strncmp(obj->at.ns.host, nser_coll->member[i],
						sizeof(nser_coll->member[i]))) {
			  if(!strncmp(obj->at.ns.target, nser_coll->member[j],
						  sizeof(nser_coll->member[j]))) {
				/*
				  printf("obj->at.ns.resource is %s\n", obj->at.ns.resource);
				*/
				if(!strcmp(obj->at.ns.resource, "latencyTcp")) {
				  /*
				  printf("matched latencyTcp with %s.\n",
						 obj->at.ns.nsc->name);
				  */
				  i_nc2c[j]->lat_nser = obj->at.ns.nsc;
				}
				else if (!strcmp(obj->at.ns.resource, "bandwidthTcp")) {
				  i_nc2c[j]->ban_nser = obj->at.ns.nsc;
				  /*
				  printf("matched bandwidthTcp with %s\n",
						 obj->at.ns.nsc->name);
				  */
				}
				/*
				printf("%d,%d matches %s\n", i, j, obj->name);
				*/
			  }
			}
		  }  
		}
		obj = obj->next;
	  }
	  ldap_pvt_thread_mutex_unlock(&nbc->obj_list_mutex);
	}
  }

  for(i=0; i < count; i++) {
	i_nc2c = (struct nws_series_cache2coll **)nser_coll->series_rel[i];
	for(j=0; j < count; j++) {
	 /*  printf("%d,%d\n",i,j); */
	  if(i==j) {
		continue;
	  }
	  if(i_nc2c[j]->lat_nser == NULL) {
		if(i_nc2c[j]->ban_nser != NULL) {
		  printf("serious confusion\n");
		  exit(0);
		}
		/* step forward thru member[i] until 1st period. */
		tmpc1 = nser_coll->member[i];
		while(*tmpc1 != '.') {tmpc1++;}
		tmpc1++;
		strcpy(buf1, tmpc1);
		tmpc1 = buf1;
		while((*tmpc1 != ':') && (*tmpc1 != '\0')) {tmpc1++;}
		*tmpc1 = '\0';
		/* step forward thru member[j] until 1st period. */
		tmpc1 = nser_coll->member[j];
		while(*tmpc1 != '.') {tmpc1++;}
		tmpc1++;
		strcpy(buf2, tmpc1);
		tmpc1 = buf2;
		while((*tmpc1 != ':') && (*tmpc1 != '\0')) {tmpc1++;}
		*tmpc1 = '\0';
/* 		printf("now buf1 contains %s\n", buf1); */
/* 		printf("now buf2 contains %s\n", buf2); */

		obj = nws_obj_list;
		while(obj != NULL) {
		  if (!strcmp("nwsSeries", obj->type)) {
			if(obj->at.ns.target != NULL) {		
			  /* step forward thru obj->at.ns.host until 1st period. */
			  tmpc1 = obj->at.ns.host;
			  while(*tmpc1 != '.') {tmpc1++;}
			  tmpc1++;
			  strcpy(buf3, tmpc1);
			  tmpc1 = buf3;
			  
			  /* use strchr, you idiot */
			  while((*tmpc1 != ':') && (*tmpc1 != '\0')) {tmpc1++;}
			  *tmpc1 = '\0';
			  /* step forward thru obj->at.ns.target until 1st period. */
			  tmpc1 = obj->at.ns.target;
			  while(*tmpc1 != '.') {tmpc1++;}
			  tmpc1++;
			  strcpy(buf4, tmpc1);
			  tmpc1 = buf4;
			  while((*tmpc1 != ':') && (*tmpc1 != '\0')) {tmpc1++;}
			  *tmpc1 = '\0';
			  if((!strcmp(buf1,buf3)) && (!strcmp(buf2,buf4))) {
				/* printf("%s matches for %s - %s\n",obj->name, nser_coll->member[i], nser_coll->member[j]);  */
				if(!strcmp(obj->at.ns.resource, "latencyTcp")) {
				  i_nc2c[j]->lat_nser = obj->at.ns.nsc;
				}
				else if (!strcmp(obj->at.ns.resource, "bandwidthTcp")) {
				  i_nc2c[j]->ban_nser = obj->at.ns.nsc;
				}
			  }
			  /* printf("now buf3 contains %s\n", buf3);  */
 			  /* printf("now buf4 contains %s\n", buf4); */
			}
		  }
		  obj = obj->next;
		}
		if(i_nc2c[j]->lat_nser == NULL) {
		  printf("failed to match latency for %s - %s\n", nser_coll->member[i], nser_coll->member[j]);
		  exit(0);
		}
		if(i_nc2c[j]->ban_nser == NULL) {
		  printf("failed to match bandwidth for %s - %s\n", nser_coll->member[i], nser_coll->member[j]);
		  exit(0);
		}
	  }
	}
  }

  
  if(gettimeofday(&now, NULL) == -1) {
	  perror("gettimeofday failed");
  }
  nser_coll->lastupdate.tv_sec = now.tv_sec;
  nser_coll->lastupdate.tv_usec = now.tv_usec;
  return 0;
}

/* this function takes an nws_series_collection of type clique and  */
/* relates the appropriate series to it */
int
nws_cache_relate(NWSobj *nws_obj_list,
				 struct nws_series_collection *nser_coll) 
{
  NWSobj *obj;
  nwsSeriesCache *nser;
  struct nws_series_cache2coll *nser_c2c;
  int i;

  if(nser_coll->status == 1) {
	return(1);
  }

  if(0){
	for(i=0;i<nser_coll->member_count;i++) {
	  Debug(LDAP_DEBUG_TRACE,"%d: %s\n", i, nser_coll->member[i], 0); 
	}
  }

  /* find the series records that should be tied to this collection */
  obj = nws_obj_list;
  while(obj != NULL) {
	if (!strcmp("nwsSeries", obj->type)) {
	  if(obj->at.ns.activity != NULL) {
		if (!strcmp(nser_coll->name, obj->at.ns.activity)) {
		  /* 	XXX we either have to throw away all the previously related series and start over or check the names of the related series */
		  for(i=0;i<nser_coll->series_rel_count;i++) {
			if(!strcmp(obj->name, nser_coll->series_rel[i]->nser->name)) {
			  continue;
			}
		  }
		  nser = obj->at.ns.nsc;

		  /* printf("series %s is related to activity %s\n", obj->name, obj->at.ns.activity); */
		  /* host is equal to one of the indices in this host coll and
			 target is equal to another -- loop thru and figure this out.
			 Then store it in the cache2coll struct */

		  nser_c2c = malloc(sizeof(struct nws_series_cache2coll));
		  if(nser_c2c == NULL) {
			printf("nws_cache_reg(): malloc failed\n");
			exit(-1);
		  }
		  nser_c2c->nser = nser;
		  for(i=0;i<nser_coll->member_count;i++) {
			if(!strcmp(nser_coll->member[i], obj->at.ns.host)) {
			  nser_c2c->index0 = i;
			  /* printf("host %s in series %s is index %d of collection %s\n", obj->at.ns.host, obj->name, i, nser_coll->name); */
			}
			if(!strcmp(nser_coll->member[i], obj->at.ns.target)) {
			  nser_c2c->index1 = i;
			  /* 	printf("target %s in series %s is index %d of collection %s\n", obj->at.ns.target, obj->name, i, nser_coll->name); */
			}
		  }

		  nser_coll->series_rel_count++;
		  nser_coll->series_rel =
			realloc(nser_coll->series_rel,
					sizeof(struct nws_series_cache2coll *)
					* nser_coll->series_rel_count + 1);
		  nser_coll->series_rel[nser_coll->series_rel_count-1] = nser_c2c;

		}
	  }
	}
	obj = obj->next;
  }
  /* printf("series coll %s has %d series\n",nser_coll->name, nser_coll->series_count);  */

  nser_coll->status = 1;
  return(1);

}


char *
nws_get_objs(nwsBackConfig *nbc) {
  const char filter[] = "name=*";
  char *retrieved;
  unsigned int replySize;
  /* int timeout = -1; */
  unsigned int timeout = 5000;

  DataDescriptor filterDescriptor = SIMPLE_DATA(CHAR_TYPE, 0);
  DataDescriptor objectsDescriptor = SIMPLE_DATA(CHAR_TYPE, 0);

  Debug(LDAP_DEBUG_TRACE, "==>nws_get_objs()\n",0,0,0);

  nbc->ns_cookie.sd = NO_SOCKET;

  ldap_pvt_thread_mutex_lock(&nbc->nws_connect_mutex);
  if(!ConnectToHost(&nbc->ns_cookie, &nbc->ns_cookie.sd)) {
	printf("ConnectToHost failed for %s.\n", nbc->ns_cookie.name);
	return(NULL);
  }
  ldap_pvt_thread_mutex_unlock(&nbc->nws_connect_mutex);

  filterDescriptor.repetitions = strlen(filter) + 1;

  if(!SendMessageAndData(nbc->ns_cookie.sd,
                         NS_SEARCH,
                         filter,
                         &filterDescriptor,
                         1,
                         timeout)) {
	printf("SendMessageAndData() failed\n");
	DisconnectHost(&nbc->ns_cookie);
	return(NULL);
  }
  else if(!RecvMessage(nbc->ns_cookie.sd,
                       NS_SEARCHED,
                       &replySize,
                       timeout)) {

	printf("RecvMessage() failed\n");
	DisconnectHost(&nbc->ns_cookie);
	return(NULL);
  }

  retrieved = (ObjectSet)malloc(replySize);
  objectsDescriptor.repetitions = replySize;

  if(!RecvData(nbc->ns_cookie.sd,
               retrieved,
               &objectsDescriptor,
               1,
               timeout)) {
    free(retrieved);
	printf("RecvData() failed\n");
	DisconnectHost(&nbc->ns_cookie);
	return(NULL);
  }

  ldap_pvt_thread_mutex_lock(&nbc->nws_connect_mutex);
  DisconnectHost(&nbc->ns_cookie);
  ldap_pvt_thread_mutex_unlock(&nbc->nws_connect_mutex);

  Debug(LDAP_DEBUG_TRACE, "<==nws_get_objs()\n",0,0,0);
  return(retrieved);
}

