
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/******************************************************************************
**
**    File:      libosiris.h
**    Author:    Brian Wotring
**
**    Date:      June 22, 2001.
**    Project:   osiris
**
******************************************************************************/

#ifndef LIBOSIRIS_H_
#define LIBOSIRIS_H_

#include "config.h"

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#include <string.h>
#include <fcntl.h>

#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_FEATURES_H
#include <features.h>
#endif

#ifdef WIN32

#include <winsock.h>
#include <windows.h>
#include <process.h>
#include <io.h>
#include <time.h>

#else

#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/errno.h>

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#include <dirent.h>

#endif

#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rsa.h>
#include <openssl/pem.h>
#include <openssl/conf.h>
#include <openssl/rand.h>
#include <openssl/x509.h>
#include <openssl/x509v3.h>

#ifdef __cplusplus
extern "C"
{
#endif

#include "utilities.h"
#include "error.h"
#include "scan_record.h"
#include "filter.h"
#include "list.h"
#include "string_list.h"
#include "message.h"
#include "socketapi.h"
#include "ssl_utilities.h"
#include "status.h"
#include "configuration.h"
#include "strptime.h"
#include "strcasestr.h" 
#include "regex.h"
#include "debug.h"

#ifdef __cplusplus
}
#endif

#endif
