/***************************************************************************
  fileresource.h
  -------------------
  Definitions for serialization
  -------------------
  begin         September 25th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999, 2001, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  3. Neither name of the copyright holders nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef FILERESOURCE_H
#define FILERESOURCE_H

#include <qstring.h>

namespace FileResource {

// define file format versions
const QString QBREW_PREVIOUS        = "0.1.7";

const QString QBREW_OLDFORMAT       = "QBREW";
const QString QBREW_OLDVERSION      = "0.1";
const QString QBREW_OLDPREVIOUS     = "0.1";

//////////////////////////////////////////////////////////////////////////////
// XML Format Strings

const QString tagRecipe             = "recipe";
const QString attrGenerator         = "generator";
const QString tagTitle              = "title";
const QString tagBrewer             = "brewer";
const QString tagBatch              = "batch";
const QString attrSize              = "size";
const QString attrMash              = "mash";
// the rest of the tags/attrs are defined in calcresource.h


// group types to build hash with
const QString groupRecipe           = "RECIPE";
const int gidRecipe                 = 10010;
const QString groupDocGrains        = "GRAINS";
const int gidDocGrains              = 10011;
const QString groupDocHops          = "HOPS";
const int gidDocHops                = 10012;
const QString groupDocMisc          = "MISC";
const int gidDocMisc                = 10013;

// data fields to build hash with
const QString fieldTitle            = "Title";
const int fidTitle                  = 10100;
const QString fieldBrewer           = "Brewer";
const int fidBrewer                 = 10101;
const QString fieldStyle            = "Style";
const int fidStyle                  = 10102;
const QString fieldSize             = "BatchSize";
const int fidSize                   = 10103;
const QString fieldMash             = "Mash";
const int fidMash                   = 10104;

} // FileResource

#endif // FILERESOURCE_H
