/***************************************************************************
  miscingredient.cpp
  -------------------
  A miscellaneous ingredient class
  -------------------
  begin         October 20th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999, 2001, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include "miscingredient.h"

#include <cmath>

#include <qstringlist.h>

//////////////////////////////////////////////////////////////////////////////
// Construction, Destruction                                                //
//////////////////////////////////////////////////////////////////////////////

MiscIngredient::MiscIngredient(const QString &name, const double &quantity, const QString &notes)
    : name_(name), quantity_(quantity), notes_(notes)
{ ; }

MiscIngredient::MiscIngredient(const MiscIngredient &m)
    : name_(m.name_), quantity_(m.quantity_), notes_(m.notes_)
{ ; }

MiscIngredient::~MiscIngredient() {}

//////////////////////////////////////////////////////////////////////////////
// Operators                                                                //
//////////////////////////////////////////////////////////////////////////////

MiscIngredient MiscIngredient::operator=(const MiscIngredient &m)
{
    if (this != &m) {
        name_ = m.name_;
        quantity_ = m.quantity_;
        notes_ = m.notes_;
    }
    return *this;
}

bool MiscIngredient::operator==(const MiscIngredient &m)
{
    return (name_ == m.name_)
        && (quantity_ == m.quantity_)
        && (notes_ == m.notes_);
}

//////////////////////////////////////////////////////////////////////////////
// Serialization (deprecated)                                               //
//////////////////////////////////////////////////////////////////////////////

QString MiscIngredient::obsoleteSerializeOut()
{
    // converting to deprecated file format on the fly...
    return QString::number(quantity_ * 100.0) + ", " + notes_;
}

void MiscIngredient::obsoleteSerializeIn(const QString &name, const QString &value)
{
    QString valuestring = value;
    QStringList tokens;
    int pos;

    // get tokens
    while (valuestring.length() > 0) {
        pos = valuestring.find(',');
        if (pos > 0) {
            tokens += valuestring.left(pos);
            valuestring.remove(0, pos+1);
            valuestring = valuestring.stripWhiteSpace();
        } else {
            // get last token
            tokens += valuestring;
            valuestring = "";
        }
    }
    // create new misc ingredient
    // TODO: note that commas in the notes will cause problems
    name_       = name;
    // converting to deprecated file format on the fly...
    quantity_   = tokens[0].toDouble() / 100.0;
    notes_      = tokens[1];
}

//////////////////////////////////////////////////////////////////////////////
// MiscIngredientListItem Class                                             //
//////////////////////////////////////////////////////////////////////////////

MiscIngredientListItem::MiscIngredientListItem(QListView * parent, QString a, QString b,
    QString c, QString d, QString e, QString f, QString g, QString h)
    : QListViewItem(parent, a, b, c, d, e, f, g, h), mit_(0) { ; }

MiscIngredientListItem::~MiscIngredientListItem() { ; }

void MiscIngredientListItem::setToIterator()
{
    setText(0, (*mit_).name());
    setText(1, (*mit_).quantityString());
    setText(2, (*mit_).notes());
}
