/***************************************************************************
  oldstore.h
  -------------------
  general purpose file storage class (deprecated)
  -------------------
  begin         Thu Jun 3 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999, 2001, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  3. Neither name of the copyright holders nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

// This is version 0.5 of the Store class

#ifndef OLDSTORE_H
#define OLDSTORE_H

#include <qfile.h>
#include <qstring.h>

// NOTE: This class will soon be deprecated. I will be switching over to XML using
// QDom. Store will still be around for a while, but will only be used to convert
// old files to the new format

class OldStore {
public:
    // constructor
    OldStore(int mode, const QString &filename, const QString &format, QString version="");
    // destructor
    ~OldStore();
    
    // returns true if no file errors exist.
    bool good();
    // returns the file major version as an string
    const QString getVersion();
    
    // processes the next line of text. Returns false if at end of file */
    bool getLine();
    // returns the last read element group
    const QString getGroup();
    // returns the name for the current line
    const QString getName();
    // returns the value for the current line
    const QString getValue();
    // Write a new element group to file. Returns false if error.
    bool putGroup(const QString &group);
    // Write name and value to file. Returns false if file error.
    bool putLine(const QString &name, const QString &value);
    // Write name and value to file. Returns false if file error.
    bool putLine(const QString &name, const int &value);
    // Write a comment line to file. Returns false if file error.
    bool putComment(const QString &comment);
    // Write an additional comma and element to the line
    bool putElement(const QString &element);
    // Write an additional comma and element to the line
    bool putElement(const int &element);

private:
    bool getHeader();
    bool putHeader();
    QString nextValidLine();
    
private:
    QString filename_;
    QString format_;
    QString version_;
    int mode_;
    bool good_;
    QFile file_;
    QString group_;
    QString name_;
    QString value_;
};

//////////////////////////////////////////////////////////////////////////////
// Inlined Methods

inline const QString OldStore::getVersion()
    { return version_; }

inline bool OldStore::putLine(const QString &name, const int &value)
    { return putLine(name, QString::number(value)); }

inline bool OldStore::putElement(const int &element)
    { return putElement(QString::number(element)); }

#endif // OLDSTORE_H
