/***************************************************************************
  setupdialog.cpp
  -------------------
  A setup dialog for QBrew
  -------------------
  begin         September 22th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999, 2001, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include "resource.h"
#include "setupdialog.h"

#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>

#include "fixedspinbox.h"

//////////////////////////////////////////////////////////////////////////////
// Construction, Destruction                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// SetupDialog()
// -------------
// Constructor

SetupDialog::SetupDialog(QWidget* parent, const char* name)
    : QDialog(parent, name, true)
{
    // create label widgets
    qbrewlabel_ = new QLabel(this, "qbrewlabel_");
    qbrewlabel_->setText("QBrew Directory");
    widgetstylelabel_ = new QLabel(this, "widgetstylelabel_");
    widgetstylelabel_->setText("Qt Widget Style");
    batchlabel_ = new QLabel(this, "batchlabel_");
    batchlabel_->setText("Default Batch Size");
    efficiencylabel_ = new QLabel(this, "efficiencylabel_");
    efficiencylabel_->setText("Mash Efficiency");
    recipestylelabel_ = new QLabel(this, "recipestylelabel_");
    recipestylelabel_->setText("Default Recipe Style");
    separatorone_ = new QFrame(this, "separatorone_");
    separatorone_->setFrameStyle(QFrame::HLine | QFrame::Sunken);
    separatortwo_ = new QFrame(this, "separatortwo_");
    separatortwo_->setFrameStyle(QFrame::HLine | QFrame::Sunken);

    // create other widgets
    qbrewedit_ = new QLineEdit(this, "qbrewedit_");
    widgetstylebox_ = new QComboBox(this, "widgetstylebox_");
    batchspin_ = new FixedSpinBox(0.00, 100.00, 0.25, 2, this, "batchspin_");
    efficiencyspin_ = new FixedSpinBox(0.00, 1.0, 0.01, 2, this, "efficiencyspin_");
    recipestylebox_ = new QComboBox(this, "recipestylebox_");
    tinsethcheck_ = new QCheckBox(this, "tinsethcheck_");
    tinsethcheck_->setText("Use Tinseth Hop Calculation");
    cancelbutton_ = new QPushButton(this, "cancelbutton_");
    cancelbutton_->setText("Cancel");
    okbutton_ = new QPushButton(this, "okbutton_");
    okbutton_->setText("OK");
    okbutton_->setDefault(true);
    connect(okbutton_, SIGNAL(clicked()), SLOT(accept()));
    connect(cancelbutton_, SIGNAL(clicked()), SLOT(reject()));

    // create layout
    layout_ = new QGridLayout(this, 3, 9, 3, 3, "layout_");
    layout_->addColSpacing(1, 3);
    layout_->setColStretch(0, 1);
    layout_->setColStretch(2, 1);
    layout_->addWidget(qbrewlabel_, 0, 0, Qt::AlignRight);
    layout_->addWidget(qbrewedit_, 0, 2);
    layout_->addWidget(widgetstylelabel_, 1, 0, Qt::AlignRight);
    layout_->addWidget(widgetstylebox_, 1, 2);
    layout_->addMultiCellWidget(separatorone_, 2, 2, 0, 2);
    layout_->addWidget(batchlabel_, 3, 0, Qt::AlignRight);
    layout_->addWidget(batchspin_, 3, 2);
    layout_->addWidget(efficiencylabel_, 4, 0, Qt::AlignRight);
    layout_->addWidget(efficiencyspin_, 4, 2);
    layout_->addWidget(recipestylelabel_, 5, 0, Qt::AlignRight);
    layout_->addWidget(recipestylebox_, 5, 2);
    layout_->addMultiCellWidget(tinsethcheck_, 6, 6, 0, 2); // TODO: use a label so it will look aligned
    layout_->addMultiCellWidget(separatortwo_, 7, 7, 0, 2);
    layout_->addWidget(cancelbutton_, 8, 0, QLabel::AlignRight);
    layout_->addWidget(okbutton_, 8, 2, QLabel::AlignRight);

    widgetstylebox_->clear();
    recipestylebox_->clear();
    setCaption(AppResource::ID_TITLE + tr(" Setup"));
}

SetupDialog::~SetupDialog() { ; }

//////////////////////////////////////////////////////////////////////////////
// Miscellaneous                                                            //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// setStyle()
// ----------
// Set the Style combobox

void SetupDialog::setWidgetStyle(const QString &style)
{
    int item;
    // search combo box for widget style string
    for (item=0; item<=widgetstylebox_->count(); ++item) {
        if (widgetstylebox_->text(item) == style)
            break;
    }
    // if item not found, will set it to the last one
    widgetstylebox_->setCurrentItem(item);
}

void SetupDialog::setRecipeStyle(const QString &style)
{
    int item;
    // search combo box for recipe style string
    for (item=0; item<=recipestylebox_->count(); ++item) {
        if (recipestylebox_->text(item) == style)
            break;
    }
    // if item not found, will set it to the last one
    recipestylebox_->setCurrentItem(item);
}

void SetupDialog::setQBrewDir(const QString &qdir) { qbrewedit_->setText(qdir); }

const QString SetupDialog::qbrewDir() { return qbrewedit_->text(); }

const QString SetupDialog::widgetStyle() { return widgetstylebox_->currentText(); }

void SetupDialog::setBatch(const double batch) { batchspin_->setValue(batch); }

double SetupDialog::batch() { return batchspin_->value(); }

void SetupDialog::setEfficiency(const double eff) { efficiencyspin_->setValue(eff); }

double SetupDialog::efficiency() { return efficiencyspin_->value(); }

const QString SetupDialog::recipeStyle() { return recipestylebox_->currentText(); }

void SetupDialog::setTinseth(const bool tinseth) { tinsethcheck_->setChecked(tinseth); }

bool SetupDialog::tinseth() { return tinsethcheck_->isChecked(); }

void SetupDialog::addWidgetStyle(const QString &style) { widgetstylebox_->insertItem(style); }

void SetupDialog::setRecipeStyleBox(const QStringList &styles) {recipestylebox_->insertStringList(styles); }

