/*
 * Copyright 1996 Thierry Bousch
 * Licensed under the Gnu Public License, Version 2
 *
 * $Id: mp-arch.h,v 1.5 1996/09/13 22:56:58 bousch Exp $
 *
 * Architecture-dependant definitions for multiprecision arithmetic.
 */

#ifndef _SAML_MP_ARCH_H
#define _SAML_MP_ARCH_H
#include "saml-util.h"

#if defined(__alpha__) || defined(NO_ASM)

/*
 * FIXME: the following definitions are certainly far from optimal.
 * See longlong.h
 */

#define add_ssaaaa(sh, sl, ah, al, bh, bl)			\
    do {							\
	__u32 __x = (al) + (bl);				\
	(sh) = (ah) + (bh) + (__x < (al));			\
	(sl) = __x;						\
    } while(0)

#define sub_ddmmss(sh, sl, ah, al, bh, bl)			\
    do {							\
	__u32 __x = (al) - (bl);				\
	(sh) = (ah) - (bh) - (__x > (al));			\
	(sl) = __x;						\
    } while(0)

#define umul_ppmm(xh, xl, m0, m1)				\
    do {							\
	__u64 __tmp = (__u64)(m0) * (m1);			\
	(xl) = __tmp;						\
	(xh) = __tmp >> 32;					\
    } while(0)

#define udiv_qrnnd(q, r, n1, n0, d)				\
    do {							\
	__u64 __tmp = ((__u64)(n1) << 32) + (n0);		\
	__u64 __quot = __tmp / (d);				\
	__u64 __rem  = __tmp % (d);				\
	(q) = __quot;						\
	(r) = __rem;						\
    } while(0)

#else	/* not alpha */

/*
 * For 32-bit architectures, things are better. We don't support machines
 * without hardware division (like early sparcs); too much hassle, and
 * it would be too slow anyway. You can still get SAML to compile by
 * defining NO_ASM.
 */

#include "longlong.h"
#if UDIV_NEEDS_NORMALIZATION
#error "UDIV_NEEDS_NORMALIZATION must be zero"
#endif

#endif
#endif	/* _SAML_MP_ARCH_H */
