.TH sane-dc240 5 "23 March 2001"
.IX sane-dc240
.SH NAME
sane-dc240 \- SANE backend for Kodak DC240 Digital Camera
.SH DESCRIPTION
The
.B sane-dc240
library implements a SANE (Scanner Access Now Easy) backend that
provides access to the Kodak DC240 camera. THIS IS EXTREMELY ALPHA
CODE!  USE AT YOUR OWN RISK!!
.SH "DEVICE NAMES"
The current version of the backend only allows one camera to be
connected.  The device name is always "0".
.SH CONFIGURATION
The contents of the
.I dc240.conf
specify the serial port and baud rate to use.  The baud rate 
specifies the maximum rate to use while downloading pictures.  (The
camera is always initialized using 9600 baud, then switches to the
higher rate).  On a 450MHz Pentium, I usually have no problems downloading
at 115200 baud, though the camera sometimes has to resend packets due
to lost characters.  Results are better when 
the "interrupt-unmask flag" is set in the IDE driver (hdparm -u1).
Supported baud rates are: 9600, 19200, 38400, 57600, and 115200.
.PP
The dumpinquiry line causes some information about the camera to 
be printed.
.PP
cmdrespause specifies how many usec (1,000,000ths of a) between
writing the command and reading the result should be used. 125000
seems to be the lowest I could go reliably.
.PP
breakpause is the time in 1,000,000ths of a usec between sending the
"back to default" break sending commands.      
.PP
Empty lines and lines starting with a hash mark (#) are
ignored.  A sample configuration file is shown below:
.PP
.RS
port=/dev/ttyS0
.br
# this is a comment
.br
baud=115200
.br
dumpinquiry
.br
cmdrespause=125000
.br
breakpause=1000000
.RE
.PP
.SH FILES
.TP
.I @CONFIGDIR@/dc240.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane-dc240.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-dc240.so
The shared library implementing this backend (present on systems that
support dynamic loading).

.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP
.B SANE_DEBUG_DC240
If the library was compiled with debugging support enabled, this
environment variable controls the debug level for this backend. 
A value of 128 requests maximally copious debug output; smaller
levels reduce verbosity.

.SH "SEE ALSO"
sane(7)

.SH AUTHOR
Peter S. Fales

.PP
This backend borrows heavily from the dc210 backend by Brian J. Murrell
which is based somewhat on the dc25 backend by Peter Fales.
.PP
The manpage was largeley copied from the dc210 manpage.

.SH BUGS
The major limitation that I know of is that the backend assumes
the directory in the camera is 100dc240.  Once the camera has
taken more than 9999 pictures, the directory will increment to 101dc240. 
Not only should we check for the additional directory, but pictures may
actually be found in multiple directories.
.PP
More general comments, suggestions, and inquiries about frontends
or SANE should go to the SANE Developers mailing list 
(see http://www.mostang.com/sane/mail.html for details). 
You must be subscribed to the list, otherwise your mail won't be
sent to the subscribers.

