/*
 * Externally visible objects defined in scheme48heap.c.
 */

/* initialize top-level variables */
extern void	s48_heap_init(void);

/* heap-init interface */
extern char *	s48_initialize_heap(long, long, char *);
extern void	s48_register_static_areas(long, char **, long *,
					  long, char **, long *);

/* heap interface */
extern long	s48_available(void);
extern long	s48_heap_size(void);
extern long	s48_find_all(long);
extern long	s48_find_allint(long);
extern long	s48_find_all_records(long);
extern long	s48_gather_objects(char(*)(long), char(*)(char(*)(long)));

/* for writing images */
extern char *	s48_heap_begin(void);	
extern char *	s48_heap_pointer(void);	
extern char *	s48_oldspace_begin(void);	
extern char *	s48_oldspace_end(void);	

/* used by the space checking and allocation macros in scheme48mv-prelude.h */
extern char *	s48_ShpS;
extern char *	s48_SlimitS;

/* gc interface */
extern void	s48_collect();
extern long	s48_trace_value(long);
extern void	s48_trace_locationsB(char *, char *);
extern void	s48_trace_stob_contentsB(long);
extern void	s48_trace_continuation_contentsB(char *, char *, long);
extern char	s48_extantP(long);
extern long	s48_gc_count(void);

/* allocation interface */
extern void	s48_make_availableAgc(long);
extern char *	s48_allocate_small(long);
extern char *	s48_allocate_tracedAgc(long);
extern char *	s48_allocate_untracedAgc(long);

/* debugging */
extern char	s48_check_heap(long);
