/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.3:
 *   smidump -f scli TCP-MIB
 *
 * Derived from TCP-MIB:
 *   The MIB module for managing TCP implementations.
 *   
 *   Copyright (C) The Internet Society (2005). This version
 *   of this MIB module is a part of RFC 4022; see the RFC
 *   itself for full legal notices.
 *
 * Revision 2005-02-18 00:00:
 *   IP version neutral revision, published as RFC 4022.
 *
 * Revision 1994-11-01 00:00:
 *   Initial SMIv2 version, published as RFC 2012.
 *
 * Revision 1991-03-31 00:00:
 *   The initial revision of this MIB module was part of
 *   MIB-II.
 *
 * $Id: tcp-mib.h 1787 2006-02-21 20:45:55Z schoenw $
 */

#ifndef _TCP_MIB_H_
#define _TCP_MIB_H_

#include "gsnmp.h"

G_BEGIN_DECLS

/*
 * Tables to map enumerations to strings and vice versa.
 */

#define TCP_MIB_TCPRTOALGORITHM_OTHER    1
#define TCP_MIB_TCPRTOALGORITHM_CONSTANT 2
#define TCP_MIB_TCPRTOALGORITHM_RSRE     3
#define TCP_MIB_TCPRTOALGORITHM_VANJ     4
#define TCP_MIB_TCPRTOALGORITHM_RFC2988  5

extern GNetSnmpEnum const tcp_mib_enums_tcpRtoAlgorithm[];

#define TCP_MIB_TCPCONNSTATE_CLOSED      1
#define TCP_MIB_TCPCONNSTATE_LISTEN      2
#define TCP_MIB_TCPCONNSTATE_SYNSENT     3
#define TCP_MIB_TCPCONNSTATE_SYNRECEIVED 4
#define TCP_MIB_TCPCONNSTATE_ESTABLISHED 5
#define TCP_MIB_TCPCONNSTATE_FINWAIT1    6
#define TCP_MIB_TCPCONNSTATE_FINWAIT2    7
#define TCP_MIB_TCPCONNSTATE_CLOSEWAIT   8
#define TCP_MIB_TCPCONNSTATE_LASTACK     9
#define TCP_MIB_TCPCONNSTATE_CLOSING     10
#define TCP_MIB_TCPCONNSTATE_TIMEWAIT    11
#define TCP_MIB_TCPCONNSTATE_DELETETCB   12

extern GNetSnmpEnum const tcp_mib_enums_tcpConnState[];

#define TCP_MIB_TCPCONNECTIONSTATE_CLOSED      1
#define TCP_MIB_TCPCONNECTIONSTATE_LISTEN      2
#define TCP_MIB_TCPCONNECTIONSTATE_SYNSENT     3
#define TCP_MIB_TCPCONNECTIONSTATE_SYNRECEIVED 4
#define TCP_MIB_TCPCONNECTIONSTATE_ESTABLISHED 5
#define TCP_MIB_TCPCONNECTIONSTATE_FINWAIT1    6
#define TCP_MIB_TCPCONNECTIONSTATE_FINWAIT2    7
#define TCP_MIB_TCPCONNECTIONSTATE_CLOSEWAIT   8
#define TCP_MIB_TCPCONNECTIONSTATE_LASTACK     9
#define TCP_MIB_TCPCONNECTIONSTATE_CLOSING     10
#define TCP_MIB_TCPCONNECTIONSTATE_TIMEWAIT    11
#define TCP_MIB_TCPCONNECTIONSTATE_DELETETCB   12

extern GNetSnmpEnum const tcp_mib_enums_tcpConnectionState[];


/*
 * C type definitions for TCP-MIB::tcp.
 */

#define TCP_MIB_TCPRTOALGORITHM (1 << 0) 
#define TCP_MIB_TCPRTOMIN       (1 << 1) 
#define TCP_MIB_TCPRTOMAX       (1 << 2) 
#define TCP_MIB_TCPMAXCONN      (1 << 3) 
#define TCP_MIB_TCPACTIVEOPENS  (1 << 4) 
#define TCP_MIB_TCPPASSIVEOPENS (1 << 5) 
#define TCP_MIB_TCPATTEMPTFAILS (1 << 6) 
#define TCP_MIB_TCPESTABRESETS  (1 << 7) 
#define TCP_MIB_TCPCURRESTAB    (1 << 8) 
#define TCP_MIB_TCPINSEGS       (1 << 9) 
#define TCP_MIB_TCPOUTSEGS      (1 << 10) 
#define TCP_MIB_TCPRETRANSSEGS  (1 << 11) 
#define TCP_MIB_TCPINERRS       (1 << 12) 
#define TCP_MIB_TCPOUTRSTS      (1 << 13) 
#define TCP_MIB_TCPHCINSEGS     (1 << 14) 
#define TCP_MIB_TCPHCOUTSEGS    (1 << 15) 

typedef struct {
    gint32   *tcpRtoAlgorithm;     /* ro */
    gint32   *tcpRtoMin;           /* ro [milliseconds] */
    gint32   *tcpRtoMax;           /* ro [milliseconds] */
    gint32   *tcpMaxConn;          /* ro */
    guint32  *tcpActiveOpens;      /* ro SNMPv2-SMI::Counter32 */
    guint32  *tcpPassiveOpens;     /* ro SNMPv2-SMI::Counter32 */
    guint32  *tcpAttemptFails;     /* ro SNMPv2-SMI::Counter32 */
    guint32  *tcpEstabResets;      /* ro SNMPv2-SMI::Counter32 */
    guint32  *tcpCurrEstab;        /* ro SNMPv2-SMI::Gauge32 */
    guint32  *tcpInSegs;           /* ro SNMPv2-SMI::Counter32 */
    guint32  *tcpOutSegs;          /* ro SNMPv2-SMI::Counter32 */
    guint32  *tcpRetransSegs;      /* ro SNMPv2-SMI::Counter32 */
    guint32  *tcpInErrs;           /* ro SNMPv2-SMI::Counter32 */
    guint32  *tcpOutRsts;          /* ro SNMPv2-SMI::Counter32 */
    guint64  *tcpHCInSegs;         /* ro SNMPv2-SMI::Counter64 */
    guint64  *tcpHCOutSegs;        /* ro SNMPv2-SMI::Counter64 */
} tcp_mib_tcp_t;

extern tcp_mib_tcp_t *
tcp_mib_new_tcp(void);

extern void
tcp_mib_get_tcp(GNetSnmp *s, tcp_mib_tcp_t **tcp, gint64 mask);

extern void
tcp_mib_free_tcp(tcp_mib_tcp_t *tcp);

/*
 * C type definitions for TCP-MIB::tcpConnEntry.
 */

#define TCP_MIB_TCPCONNSTATE        (1 << 0) 
#define TCP_MIB_TCPCONNLOCALADDRESS (1 << 1) 
#define TCP_MIB_TCPCONNLOCALPORT    (1 << 2) 
#define TCP_MIB_TCPCONNREMADDRESS   (1 << 3) 
#define TCP_MIB_TCPCONNREMPORT      (1 << 4) 

typedef struct {
    guchar   tcpConnLocalAddress[4];  /* ro SNMPv2-SMI::IpAddress */
#define TCP_MIB_TCPCONNLOCALADDRESSLENGTH 4
    gint32   tcpConnLocalPort;         /* ro */
    guchar   tcpConnRemAddress[4];    /* ro SNMPv2-SMI::IpAddress */
#define TCP_MIB_TCPCONNREMADDRESSLENGTH 4
    gint32   tcpConnRemPort;           /* ro */
    gint32   *tcpConnState;            /* rw */
} tcp_mib_tcpConnEntry_t;

extern void
tcp_mib_get_tcpConnTable(GNetSnmp *s, tcp_mib_tcpConnEntry_t ***tcpConnEntry, gint64 mask);

extern void
tcp_mib_free_tcpConnTable(tcp_mib_tcpConnEntry_t **tcpConnEntry);

extern tcp_mib_tcpConnEntry_t *
tcp_mib_new_tcpConnEntry(void);

extern void
tcp_mib_get_tcpConnEntry(GNetSnmp *s, tcp_mib_tcpConnEntry_t **tcpConnEntry, guchar *tcpConnLocalAddress, gint32 tcpConnLocalPort, guchar *tcpConnRemAddress, gint32 tcpConnRemPort, gint64 mask);

extern void
tcp_mib_set_tcpConnEntry(GNetSnmp *s, tcp_mib_tcpConnEntry_t *tcpConnEntry, gint64 mask);

extern void
tcp_mib_free_tcpConnEntry(tcp_mib_tcpConnEntry_t *tcpConnEntry);

/*
 * C type definitions for TCP-MIB::tcpConnectionEntry.
 */

#define TCP_MIB_TCPCONNECTIONSTATE   (1 << 0) 
#define TCP_MIB_TCPCONNECTIONPROCESS (1 << 1) 

typedef struct {
    gint32   tcpConnectionLocalAddressType;   /* na INET-ADDRESS-MIB::InetAddressType */
    guchar   tcpConnectionLocalAddress[118];   /* na INET-ADDRESS-MIB::InetAddress */
#define TCP_MIB_TCPCONNECTIONLOCALADDRESSMINLENGTH 0
#define TCP_MIB_TCPCONNECTIONLOCALADDRESSMAXLENGTH 118
    guint16  _tcpConnectionLocalAddressLength;
    guint32  tcpConnectionLocalPort;    /* na INET-ADDRESS-MIB::InetPortNumber */
    gint32   tcpConnectionRemAddressType; /* na INET-ADDRESS-MIB::InetAddressType */
    guchar   tcpConnectionRemAddress[118]; /* na INET-ADDRESS-MIB::InetAddress */
#define TCP_MIB_TCPCONNECTIONREMADDRESSMINLENGTH 0
#define TCP_MIB_TCPCONNECTIONREMADDRESSMAXLENGTH 118
    guint16  _tcpConnectionRemAddressLength;
    guint32  tcpConnectionRemPort;      /* na INET-ADDRESS-MIB::InetPortNumber */
    gint32   *tcpConnectionState;       /* rw */
    guint32  *tcpConnectionProcess;     /* ro Unsigned32 */
} tcp_mib_tcpConnectionEntry_t;

extern void
tcp_mib_get_tcpConnectionTable(GNetSnmp *s, tcp_mib_tcpConnectionEntry_t ***tcpConnectionEntry, gint64 mask);

extern void
tcp_mib_free_tcpConnectionTable(tcp_mib_tcpConnectionEntry_t **tcpConnectionEntry);

extern tcp_mib_tcpConnectionEntry_t *
tcp_mib_new_tcpConnectionEntry(void);

extern void
tcp_mib_get_tcpConnectionEntry(GNetSnmp *s, tcp_mib_tcpConnectionEntry_t **tcpConnectionEntry, gint32 tcpConnectionLocalAddressType, guchar *tcpConnectionLocalAddress, guint16 _tcpConnectionLocalAddressLength, guint32 tcpConnectionLocalPort, gint32 tcpConnectionRemAddressType, guchar *tcpConnectionRemAddress, guint16 _tcpConnectionRemAddressLength, guint32 tcpConnectionRemPort, gint64 mask);

extern void
tcp_mib_set_tcpConnectionEntry(GNetSnmp *s, tcp_mib_tcpConnectionEntry_t *tcpConnectionEntry, gint64 mask);

extern void
tcp_mib_free_tcpConnectionEntry(tcp_mib_tcpConnectionEntry_t *tcpConnectionEntry);

/*
 * C type definitions for TCP-MIB::tcpListenerEntry.
 */

#define TCP_MIB_TCPLISTENERPROCESS (1 << 0) 

typedef struct {
    gint32   tcpListenerLocalAddressType;   /* na INET-ADDRESS-MIB::InetAddressType */
    guchar   tcpListenerLocalAddress[118];   /* na INET-ADDRESS-MIB::InetAddress */
#define TCP_MIB_TCPLISTENERLOCALADDRESSMINLENGTH 0
#define TCP_MIB_TCPLISTENERLOCALADDRESSMAXLENGTH 118
    guint16  _tcpListenerLocalAddressLength;
    guint32  tcpListenerLocalPort;    /* na INET-ADDRESS-MIB::InetPortNumber */
    guint32  *tcpListenerProcess;     /* ro Unsigned32 */
} tcp_mib_tcpListenerEntry_t;

extern void
tcp_mib_get_tcpListenerTable(GNetSnmp *s, tcp_mib_tcpListenerEntry_t ***tcpListenerEntry, gint64 mask);

extern void
tcp_mib_free_tcpListenerTable(tcp_mib_tcpListenerEntry_t **tcpListenerEntry);

extern tcp_mib_tcpListenerEntry_t *
tcp_mib_new_tcpListenerEntry(void);

extern void
tcp_mib_get_tcpListenerEntry(GNetSnmp *s, tcp_mib_tcpListenerEntry_t **tcpListenerEntry, gint32 tcpListenerLocalAddressType, guchar *tcpListenerLocalAddress, guint16 _tcpListenerLocalAddressLength, guint32 tcpListenerLocalPort, gint64 mask);

extern void
tcp_mib_free_tcpListenerEntry(tcp_mib_tcpListenerEntry_t *tcpListenerEntry);


G_END_DECLS

#endif /* _TCP_MIB_H_ */
