/*  Sclient
 *  Copyright (C) 1999 Heathen (the.heathen@swipnet.se)
 *		  1999 Drizzt  (doc.day@swipnet.se)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _MANUAL_H_
#define _MANUAL_H_
#include "sclient.h"

/* The Manual text that will be inserted with the gtk_text_insert funtion!
 * NEEDS to be word wrapped at 72 signs per row */

/* Contents txt */
#define CONTENTS_MESSAGE "\

 What is SClient and how do I use it?

 Sclient is a small anf fast MUD client. Now you might wonder what is MUD?
 Mud is Multi User Dungeon wich is a nifty game where you can not just play,
 but you can play with or even sometimes against other people depending on wich
 kind of mud you connect to. You have the ability to communicate and be social
 with all the players in the game!

 Well, back to SClient and how it works.
 Sclient is merrely a fancy looking telnet application with some very mud uniqe
 functions built into it.

 Features:

 * Connection Wizard (see Connection wizard page for more info)
 * Separate input and output windows, avoiding the most annoying thing of using
   a regular telnet application where the incomming text is interspersed with what
   you type.
 * Easy to use, remebers mud host names, ports and optionally character name
   and password.
 * Scroll back buffer, no need for page pausing on the mudserver side.
 * Ansi color support, so you can view all those nice colors...
 * Macros (see Macro page for more info)
 * Aliases (see Aliases page for more info)
 * Triggers (see Triggers page for more info)
 * User selectable fonts (see fonts page for more info)
 * Input history, use arrow up or down to view/use commands allready sent to
   the mud. So you can repeat them quickly.
 * KeepText is used to make the text you type in the input window to stay after you
   have sent it...
 * EchoText is used to echo the text you send to the mud...
 * WordWrap is used to wordwrap the text in the main window...
 * Pause the text displayed by pulling up the scrollbar, can be usefull when you
   want to read something without the text moving all the time.
 * Logger (see Logger page for more info)
 * Logviewer, small less like editor (see Logviewer page for more info)
 * Colors (see Colors page for more info)

 Further questions and comments can be sent to:

 SClient Team (sclient@swipnet.se)
\n"

/* Wizard txt */
#define WIZARD_MESSAGE "\

 The Connection Wizard is used to save all you connections, so you don't have to
 type in the host and port every time you want to connect to a mud server. It also
 have a AutoLogin function that will save your character name and password and
 send them to the mud as you connect so you will enter the mudserver automaticlly.

 Example:

 Say that you would like to connect to : some.mudserver.com on port 1234!

 Then you should in the connection name entry type in the name YOU would like to
 call this connection.
 In the Host entry you should enter the adress to he server, in this case it will
 be: some.mudserver.com
 in the Port entry you'll type: 1234
 Now if you would like SClient to automaticlly login with your character, check the
 Auto Login toggle button and then type your character name in the player name entry
 and your password in the password entry. When your done with this you must click
 the Add button to add it to the Connections list on the left side.
 all you should have to do now is to push the connect button. (happy mudding)

 Remember to SAVE!
\n"

/* Macro txt */
#define MACROS_MESSAGE "\

 A macro is a string of user-specified text that will be sent to the mud when you hit
 a function key (F1-F10). To edit them, use the Tools/Macros menu. Their usage is
 fairly straight forward. Just enter the command/text in the entry box next to respective
 button label, click save and it is ready to be used.
\n"

/* Alias txt */
#define ALIAS_MESSAGE "\

 Aliases give you the power to create your own commands, or just shortcuts to
 lengthy commands. You enter your alias text to name the command shortcut you are
 making, this is the text you will type to activate the alias. In the Replacement
 field, you enter the resultant text that will be sent to the mud.
 To edit the aliases use the Tools/Aliases menu.

 Example:

 If you often had to type in the following : cast earthquake

 You might set your alias text to : earth
 and your Replacement to : cast earthquake

 then every time you typed : earth
 the client would send to the mud: cast earthquake

 Be careful that you don't set aliases for commonly typed words... for instance,
 you wouldn't want to set an alias text to sleep, because every time you tried to
 sleep, your alias would get executed instead.
\n"

/* Triggers txt */
#define TRIGGERS_MESSAGE "\

 A trigger is an action by the SClient  that is triggered by text that is received from the
 mud server. You have to enter in the trigger entry box the text that you want the client
 to look for to initiate the event.  When the SClient receives this text, it will send the text
 that you have entered in the output entry box's to the mud server. 

 A trigger can only span one line of input text, but can have multiple output lines of text.

 Make sure that the mud server you are playing on allows you to use triggers, some mud
 admins doesn't aprove of trigger usage on their servers. 
\n"

/* Logger txt */
#define LOGGER_MESSAGE "\

 The logger allows you to print the text to a file or append to an allready existing
 log file so you can go back and check it afterwards. This is very usefull for logging
 stuff you have to remember later, for example a certain zone/quest that has to much
 stuff in it to keep it in the head, and you really want to be able to do it again
 sometime. Or maybe you just would like to log a certain event... :)

 To turn on/off logging use the menu Tools/Logger.
\n"

/* Logviewer txt */
#define LOGVIEWER_MESSAGE "\

 The logviewer is a simple text viewer with a search function. There are no saving
 ability it's just for viewing not editing. This viewer is included only to make it
 easy to look at you log files made by the SClient, but it can be used to view any
 text file.

 To start the Logviewer use the menu Tools/Logviewer.
\n"

/* Font txt */
#define FONT_MESSAGE "\

 With the Options/Fonts menu you can change the font settings
 Standard font is: Courier (adobe)
 fonts will be saved when clicking the ok button after selecting font.
\n"

/* Color txt */
#define COLOR_MESSAGE "\

 With the Options/Colors menu you can change the color settings for the main window.
 The first 16 buttons are the default 16 colors that most muds uses.

 The last two buttons, are only used by the client to set the colors on the background
 color and the default color on text thats not colored from the mudserver.

\n"

#endif /* _MANUAL_H_ */
