#include "modify.h"
#include "modify.moc"
#include "config.h"
#ifdef HAVE_CMS
	#include <lcms.h>
extern bool SoftProofing;
extern bool CMSuse;
#endif
extern bool CMSavail;
extern QPixmap loadIcon(QString nam);

ModObj::ModObj( QWidget* parent, PageItem *b, CListe Farben, ScribusDoc *docu, ProfilesL *InputProfiles)
				: QDialog( parent, "Mod", true, 0 )
{
  	setIcon(loadIcon("AppIcon.xpm"));
    CurMod = b;
    doc = docu;
    bool embed = false;
    if (doc->Einheit == 0)
    	Umrech = 1.0;
    else
			Umrech = 0.3527777;
    ModObjLayout = new QVBoxLayout( this );
    ModObjLayout->setSpacing( 6 );
    ModObjLayout->setMargin( 0 );
    Layout5 = new QGridLayout;
    Layout5->setSpacing( 6 );
    Layout5->setMargin( 10 );
    GroupSpecial = new QGroupBox( this, "GroupSpecial" );
    GroupSpecial->setTitle( tr( "Other:" ) );
    GroupSpecial->setColumnLayout(0, Qt::Vertical );
    GroupSpecial->layout()->setSpacing( 0 );
    GroupSpecial->layout()->setMargin( 0 );
    GroupSpecialLayout = new QHBoxLayout( GroupSpecial->layout() );
    GroupSpecialLayout->setAlignment( Qt::AlignTop );
    GroupSpecialLayout->setSpacing( 6 );
    GroupSpecialLayout->setMargin( 10 );
    Layout2 = new QVBoxLayout;
    Layout2->setSpacing( 6 );
    Layout2->setMargin( 0 );
    FlippedH = new QCheckBox( GroupSpecial, "FlippedH" );
    FlippedH->setMinimumSize( QSize( 150, 22 ) );
    FlippedH->setText( tr( "Horizontal flipped" ) );
		FlippedH->setChecked(b->flippedH % 2 != 0);
    Layout2->addWidget( FlippedH );
    FlippedV = new QCheckBox( GroupSpecial, "FlippedV" );
    FlippedV->setMinimumSize( QSize( 150, 22 ) );
    FlippedV->setText( tr( "Vertical flipped" ) );
		FlippedV->setChecked(b->flippedV % 2 != 0);
    Layout2->addWidget( FlippedV );
    Textflow = new QCheckBox( GroupSpecial, "Textflow" );
    Textflow->setMinimumSize( QSize( 150, 22 ) );
    Textflow->setText( tr( "Text flows around Box" ) );
    Textflow->setChecked(b->Textflow);
    Layout2->addWidget( Textflow );
    Printable = new QCheckBox( GroupSpecial, "Printable" );
    Printable->setMinimumSize( QSize( 150, 22 ) );
    Printable->setText( tr( "Don't print" ) );
    Printable->setChecked(!b->isPrintable);
    Layout2->addWidget( Printable );
    GroupSpecialLayout->addLayout( Layout2 );
    Layout5->addWidget( GroupSpecial, 1, 0 );

    GroupPos = new QGroupBox( this, "GroupPos" );
    GroupPos->setTitle( tr( "Position:" ) );
    GroupPos->setColumnLayout(0, Qt::Vertical );
    GroupPos->layout()->setSpacing( 0 );
    GroupPos->layout()->setMargin( 0 );
    GroupPosLayout = new QHBoxLayout( GroupPos->layout() );
    GroupPosLayout->setAlignment( Qt::AlignTop );
    GroupPosLayout->setSpacing( 6 );
    GroupPosLayout->setMargin( 11 );
    Layout1 = new QGridLayout;
    Layout1->setSpacing( 3 );
    Layout1->setMargin( 0 );
    TextLabel1 = new QLabel( GroupPos, "TextLabel1" );
    TextLabel1->setText( tr( "X-Pos:" ) );
    Layout1->addWidget( TextLabel1, 0, 0 );
    TextLabel1_2 = new QLabel( GroupPos, "TextLabel1_2" );
    TextLabel1_2->setText( tr( "Y-Pos:" ) );
    Layout1->addWidget( TextLabel1_2, 1, 0 );
    TextLabel1_2_2 = new QLabel( GroupPos, "TextLabel1_2_2" );
    TextLabel1_2_2->setText( tr( "Width:" ) );
    Layout1->addWidget( TextLabel1_2_2, 2, 0 );
    TextLabel1_2_2_2 = new QLabel( GroupPos, "TextLabel1_2_2_2" );
    TextLabel1_2_2_2->setText( tr( "Height:" ) );
    Layout1->addWidget( TextLabel1_2_2_2, 3, 0 );
    TextLabel1_2_2_2_2 = new QLabel( GroupPos, "TextLabel1_2_2_2_2" );
    TextLabel1_2_2_2_2->setText( tr( "Angle:" ) );
    Layout1->addWidget( TextLabel1_2_2_2_2, 4, 0 );
    Xpos = new MSpinBox(GroupPos, 2);
    Xpos->setMinimumSize( QSize( 85, 22 ) );
    Xpos->setSuffix( tr( " pt" ) );
    Xpos->setMaxValue( 300000 );
    Xpos->setMinValue( -300000 );
    Xpos->setValue(qRound(b->Xpos*Umrech*100));
    Xpos->setLineStep(100);
    Layout1->addWidget( Xpos, 0, 1 );
		Ypos = new MSpinBox( GroupPos, 2);
		Ypos->setMinimumSize( QSize( 85, 22 ) );
    Ypos->setSuffix( tr( " pt" ) );
    Ypos->setMaxValue( 300000 );
    Ypos->setMinValue( -300000 );
    Ypos->setValue(qRound(b->Ypos*Umrech*100));
    Ypos->setLineStep(100);
    Layout1->addWidget( Ypos, 1, 1 );
    Width = new MSpinBox( GroupPos, 2 );
    Width->setMinimumSize( QSize( 85, 22 ) );
    Width->setSuffix( tr( " pt" ) );
    Width->setMaxValue( 300000 );
    Width->setMinValue( 0 );
    origWidth = qRound(b->Width*Umrech*100);
    Width->setValue(origWidth);
    Width->setLineStep(100);
    Layout1->addWidget( Width, 2, 1 );
    Height = new MSpinBox( GroupPos, 2 );
    Height->setMinimumSize( QSize( 85, 22 ) );
    Height->setSuffix( tr( " pt" ) );
    Height->setMaxValue( 300000 );
    Height->setMinValue( 0 );
    origHeight = qRound(b->Height*Umrech*100);
    Height->setValue(origHeight);
    Height->setLineStep(100);
    Layout1->addWidget( Height, 3, 1 );
    Angle = new MSpinBox( GroupPos, 2 );
    Angle->setMinimumSize( QSize( 85, 22 ) );
    Angle->setSuffix( tr( " " ) );
    Angle->setMaxValue( 300000 );
    Angle->setMinValue( -300000 );
    Angle->setValue(qRound(b->Rot*-100));
    Angle->setLineStep(100);
    Layout1->addWidget( Angle, 4, 1 );
    GroupPosLayout->addLayout( Layout1 );
    Layout5->addWidget( GroupPos, 0, 0 );
    Props = new QButtonGroup( this, "Props" );
    Props->setTitle( tr( "Properties:" ) );
    Props->setColumnLayout(0, Qt::Vertical );
    Props->layout()->setSpacing( 0 );
    Props->layout()->setMargin( 0 );
    PropsLayout = new QHBoxLayout( Props->layout() );
    PropsLayout->setAlignment( Qt::AlignTop );
    PropsLayout->setSpacing( 6 );
    PropsLayout->setMargin( 11 );
    Layout4 = new QGridLayout;
    Layout4->setSpacing( 6 );
    Layout4->setMargin( 0 );
		CListe::Iterator it;
		ProfilesL::Iterator itP;
		QPixmap pm;
    switch (b->PType)
    	{
    	case 4:
    		setCaption(tr("Modify Textframe"));
    		NormText = new QRadioButton( Props, "NormText" );
    		NormText->setMinimumSize(QSize(140, 22));
    		NormText->setText( tr( "Ordinary Text" ) );
    		Layout4->addMultiCellWidget( NormText, 0, 0, 0, 1 );
    		Bookmark = new QRadioButton( Props, "Bookmark" );
    		Bookmark->setMinimumSize(QSize(140, 22));
    		Bookmark->setText( tr( "Is PDF-Bookmark" ) );
    		Layout4->addMultiCellWidget( Bookmark, 1, 1, 0, 1 );
    		Annotation = new QRadioButton( Props, "Annotation" );
    		Annotation->setMinimumSize(QSize(140, 22));
    		Annotation->setText( tr( "Is PDF-Annotation" ) );
    		Layout4->addMultiCellWidget( Annotation, 2, 2, 0, 1 );
    		NormText->setChecked(true);
				if (b->isBookmark)
					{
    			Bookmark->setChecked(true);
					}
				if (b->isAnnotation)
					{
    			Annotation->setChecked(true);
					}
    		TextLabel3 = new QLabel( Props, "TextLabel3" );
    		TextLabel3->setMinimumSize(QSize(110, 22));
    		TextLabel3->setText( tr( "Textdistance" ) );
    		Layout4->addWidget( TextLabel3, 3, 0);
    		TextLabel1_3 = new QLabel( Props, "TextLabel1_3" );
    		TextLabel1_3->setMinimumSize(QSize(110, 22));
    		TextLabel1_3->setText( tr( "Background Color:" ) );
    		Layout4->addWidget( TextLabel1_3, 4, 0);
    		TextLabel2 = new QLabel( Props, "TextLabel2" );
    		TextLabel2->setMinimumSize(QSize(110, 22));
    		TextLabel2->setText( tr( "Shading:" ) );
    		Layout4->addWidget( TextLabel2, 5, 0);
    		Distance = new MSpinBox( Props, 1 );
    		Distance->setMinimumSize(QSize(65, 22));
    		Distance->setSuffix( tr( " pt" ) );
    		Distance->setMaxValue( 3000 );
    		Distance->setMinValue( 0 );
    		Distance->setValue(b->Extra*10);
    		Distance->setLineStep(10);
    		Layout4->addWidget( Distance, 3, 1, Qt::AlignLeft);
    		Background = new QComboBox( true, Props, "Background" );
    		Background->setMinimumSize(QSize(95, 21));
    		Background->setEditable(false);
    		Background->insertItem(tr("None"));
    		if (b->Pcolor == "None")
    			Background->setCurrentItem(Background->count()-1);
    		pm = QPixmap(15, 15);
				for (it = Farben.begin(); it != Farben.end(); ++it)
					{
					pm.fill(Farben[it.key()].getRGBColor());
					Background->insertItem(pm, it.key());
    			if (it.key() == b->Pcolor)
    				{
    				Background->setCurrentItem(Background->count()-1);
    				}
					}
    		Layout4->addWidget( Background, 4, 1);
    		Shade = new QSpinBox( Props, "Distance_2" );
    		Shade->setMinimumSize(QSize(65, 22));
    		Shade->setSuffix( tr( " %" ) );
    		Shade->setMaxValue( 100 );
    		Shade->setMinValue( 0 );
    		Shade->setValue( b->Shade );
    		Layout4->addWidget( Shade, 5, 1, Qt::AlignLeft);
		    TextLabel2_3b = new QLabel( Props, "TextLabel2_3b" );
    		TextLabel2_3b->setText( tr( "Corner Radius:" ) );
    		Layout4->addWidget( TextLabel2_3b, 6, 0 );
    		Radius = new QSpinBox(Props, "RR");
    		Radius->setMinimumSize( QSize( 65, 22 ) );
    		Radius->setSuffix( tr( " pt" ) );
   			Radius->setMaxValue(QMIN(b->Width,b->Height)/2 );
    		Radius->setMinValue(0);
    		Radius->setValue(qRound(b->RadRect));
    		if (b->ClipEdited)
    			Radius->setEnabled(false);
    		Layout4->addWidget( Radius, 6, 1, Qt::AlignLeft );
    		break;
    	case 2:
    		setCaption(tr("Modify Pictureframe"));
		    TextLabel3_2 = new QLabel( Props, "TextLabel3_2" );
		    TextLabel3_2->setMinimumSize(QSize(110, 22));
    		TextLabel3_2->setText( tr( "Local X-Pos:" ) );
    		Layout4->addWidget( TextLabel3_2, 0, 0);
		    TextLabel3_2_2 = new QLabel( Props, "TextLabel3_2_2" );
		    TextLabel3_2_2->setMinimumSize(QSize(110, 22));
    		TextLabel3_2_2->setText( tr( "Local Y-Pos:" ) );
    		Layout4->addWidget( TextLabel3_2_2, 1, 0);
				TextLabel3_2_2_2 = new QLabel( Props, "TextLabel3_2_2_2" );
				TextLabel3_2_2_2->setMinimumSize(QSize(110, 22));
    		TextLabel3_2_2_2->setText( tr( "Horizontal Scaling" ) );
    		Layout4->addWidget( TextLabel3_2_2_2, 2, 0);
    		TextLabel3_2_2_2_2 = new QLabel( Props, "TextLabel3_2_2_2_2" );
    		TextLabel3_2_2_2_2->setMinimumSize(QSize(110, 22));
    		TextLabel3_2_2_2_2->setText( tr( "Vertical Scaling" ) );
    		Layout4->addWidget( TextLabel3_2_2_2_2, 3, 0);
    		TextLabel1_3 = new QLabel( Props, "TextLabel1_3" );
    		TextLabel1_3->setMinimumSize(QSize(110, 22));
    		TextLabel1_3->setText( tr( "Background Color:" ) );
    		Layout4->addWidget( TextLabel1_3, 5, 0);
    		TextLabel2 = new QLabel( Props, "TextLabel2" );
    		TextLabel2->setMinimumSize(QSize(110, 22));
    		TextLabel2->setText( tr( "Shading:" ) );
    		Layout4->addWidget( TextLabel2, 6, 0);
    		LXpos = new MSpinBox( Props, 2 );
    		LXpos->setMinimumSize(QSize(90, 22));
    		LXpos->setSuffix( tr( " pt" ) );
    		LXpos->setMaxValue( 300000 );
    		LXpos->setMinValue( -300000 );
    		LXpos->setLineStep(100);
    		LXpos->setValue(qRound(b->LocalX*Umrech*100));
    		Layout4->addMultiCellWidget(LXpos, 0, 0, 1, 1);
    		LYpos = new MSpinBox( Props, 2 );
    		LYpos->setMinimumSize(QSize(90, 22));
    		LYpos->setSuffix( tr( " pt" ) );
    		LYpos->setMaxValue( 300000 );
    		LYpos->setMinValue( -300000 );
    		LYpos->setLineStep(100);
    		LYpos->setValue(qRound(b->LocalY*Umrech*100));
    		Layout4->addMultiCellWidget(LYpos, 1, 1, 1, 1);
    		HScale = new MSpinBox( Props, 1 );
    		HScale->setMinimumSize(QSize(70, 22));
    		HScale->setSuffix( tr( " %" ) );
    		HScale->setMaxValue( 10000 );
    		HScale->setMinValue( 1 );
    		HScale->setLineStep(10);
    		HScale->setValue( int(b->LocalScX*1000) );
    		Layout4->addWidget(HScale, 2, 1);
    		VScale = new MSpinBox( Props, 1 );
    		VScale->setMinimumSize(QSize(70, 22));
    		VScale->setSuffix( tr( " %" ) );
    		VScale->setMaxValue( 10000 );
    		VScale->setMinValue( 1 );
    		VScale->setLineStep(10);
   			VScale->setValue( int(b->LocalScY*1000) );
    		Layout4->addWidget(VScale, 3, 1);
    		Kette = new LinkButton( Props );
    		Kette->setMinimumSize(QSize(16, 50));
    		Kette->setToggleButton( TRUE );
    		Kette->setAutoRaise(true);
   			Layout4->addMultiCellWidget(Kette, 2, 3, 2, 2, Qt::AlignLeft);
    		Visible = new QCheckBox( Props, "Visible" );
    		Visible->setText( tr( "Image visible" ) );
    		Visible->setChecked(b->PicArt);
   			Layout4->addMultiCellWidget(Visible, 4, 4, 0, 2);
    		Background = new QComboBox( true, Props, "Background" );
    		Background->setMinimumSize(QSize(95,21));
    		Background->setEditable(false);
    		pm = QPixmap(15, 15);
    		Background->insertItem(tr("None"));
    		if (b->Pcolor == "None")
    			Background->setCurrentItem(Background->count()-1);
				for (it = Farben.begin(); it != Farben.end(); ++it)
					{
					pm.fill(Farben[it.key()].getRGBColor());
					Background->insertItem(pm, it.key());
    			if (it.key() == b->Pcolor)
    				{
    				Background->setCurrentItem(Background->count()-1);
    				}
					}
   			Layout4->addMultiCellWidget(Background, 5, 5, 1, 2);
    		Shade = new QSpinBox( Props, "Shade" );
    		Shade->setMinimumSize(QSize(65, 22));
    		Shade->setSuffix( tr( " %" ) );
    		Shade->setMaxValue( 100 );
    		Shade->setMinValue( 0 );
    		Shade->setValue( b->Shade );
   			Layout4->addMultiCellWidget(Shade, 6, 6, 1, 2, Qt::AlignLeft);
		    TextLabel2_3b = new QLabel( Props, "TextLabel2_3b" );
    		TextLabel2_3b->setText( tr( "Corner Radius:" ) );
    		Layout4->addWidget( TextLabel2_3b, 7, 0 );
    		Radius = new QSpinBox(Props, "RR");
    		Radius->setMinimumSize( QSize( 65, 22 ) );
    		Radius->setSuffix( tr( " pt" ) );
   			Radius->setMaxValue(QMIN(b->Width,b->Height)/2 );
    		Radius->setMinValue(0);
    		Radius->setValue(qRound(b->RadRect));
    		if (b->ClipEdited)
    			Radius->setEnabled(false);
    		Layout4->addWidget( Radius, 7, 1, Qt::AlignLeft );
#ifdef HAVE_CMS
				if ((CMSuse) && (CMSavail))
					{
    			Text1 = new QLabel( Props, "Text1" );
    			Text1->setText( tr( "Inputprofil:" ) );
					Layout4->addWidget( Text1, 8, 0 );
    			InputP = new QComboBox( true, Props, "InputP" );
    			InputP->setMinimumSize( QSize( 190, 22 ) );
    			InputP->setEditable(false);
					for (itP = InputProfiles->begin(); itP != InputProfiles->end(); ++itP)
						{
						InputP->insertItem(itP.key());
    				if (itP.key() == b->IProfile)
    					{
    					InputP->setCurrentItem(InputP->count()-1);
    					}
						}
					if (!InputProfiles->contains(b->IProfile))
						{
						InputP->insertItem(b->IProfile);
    				InputP->setCurrentItem(InputP->count()-1);
    				embed = true;
						}
					else
						{
						if (b->EmProfile != "")
							InputP->insertItem(b->EmProfile);
						embed = false;
						}
					EmbedP = embed;
   				Layout4->addMultiCellWidget(InputP, 8, 8, 1, 3, Qt::AlignLeft);
    			Text2 = new QLabel( Props, "Text2" );
    			Text2->setText( tr( "Rendering Intent:" ) );
					Layout4->addWidget( Text2, 9, 0 );
    			MonitorI = new QComboBox( true, Props, "MonitorI" );
    			MonitorI->insertItem( tr( "Perceptual" ) );
    			MonitorI->insertItem( tr( "Relative Colorimetric" ) );
    			MonitorI->insertItem( tr( "Saturation" ) );
    			MonitorI->insertItem( tr( "Absolute Colorimetric" ) );
    			MonitorI->setMinimumSize( QSize( 190, 22 ) );
    			MonitorI->setEditable(false);
    			MonitorI->setCurrentItem(b->IRender);
   				Layout4->addMultiCellWidget(MonitorI, 9, 9, 1, 3, Qt::AlignLeft);
    			connect(InputP, SIGNAL(activated(const QString&)), this, SLOT(EmProf(const QString&)));
   				}
#endif				
    		connect(Kette, SIGNAL(clicked()), this, SLOT(ToggleKette()));
    		connect(HScale, SIGNAL(valueChanged(int)), this, SLOT(HChange()));
    		connect(VScale, SIGNAL(valueChanged(int)), this, SLOT(VChange()));
    		break;
    	default:
    		setCaption( tr( "Modify Frame" ) );
    		TextLabel1_3_2 = new QLabel( Props, "TextLabel1_3_2" );
    		TextLabel1_3_2->setText( tr( "Line Color:" ) );
    		Layout4->addWidget( TextLabel1_3_2, 2, 0 );
    		TextLabel2_2 = new QLabel( Props, "TextLabel2_2" );
    		TextLabel2_2->setText( tr( "Shading:" ) );
    		Layout4->addWidget( TextLabel2_2, 3, 0 );
		    TextLabel1_3 = new QLabel( Props, "TextLabel1_3" );
    		TextLabel1_3->setText( tr( "Fill Color:" ) );
    		Layout4->addWidget( TextLabel1_3, 0, 0 );
		    TextLabel1_3_3 = new QLabel( Props, "TextLabel1_3_3" );
    		TextLabel1_3_3->setText( tr( "Linestyle:" ) );
    		Layout4->addWidget( TextLabel1_3_3, 4, 0 );
		    TextLabel2 = new QLabel( Props, "TextLabel2" );
    		TextLabel2->setText( tr( "Shading:" ) );
    		Layout4->addWidget( TextLabel2, 1, 0 );
		    TextLabel2_3 = new QLabel( Props, "TextLabel2_3" );
    		TextLabel2_3->setText( tr( "Linewidth:" ) );
    		Layout4->addWidget( TextLabel2_3, 5, 0 );
    		Foreground = new QComboBox( true, Props, "ComboBox1" );
    		Foreground->setMinimumSize( QSize( 95, 21 ) );
    		Foreground->setEditable(false);
    		pm = QPixmap(15, 15);
		    if (b->PType != 5)
		    	{
    			Foreground->insertItem(tr("None"));
    			if (b->Pcolor2 == "None")
    				Foreground->setCurrentItem(Foreground->count()-1);
    			}
				for (it = Farben.begin(); it != Farben.end(); ++it)
					{
					pm.fill(Farben[it.key()].getRGBColor());
					Foreground->insertItem(pm, it.key());
    			if (it.key() == b->Pcolor2)
    				Foreground->setCurrentItem(Foreground->count()-1);
					}
    		Layout4->addWidget( Foreground, 2, 1 );
    		Shade2 = new QSpinBox( Props, "Shade2" );
    		Shade2->setMinimumSize( QSize( 65, 22 ) );
    		Shade2->setSuffix( tr( " %" ) );
    		Shade2->setMaxValue( 100 );
    		Shade2->setMinValue( 0 );
    		Shade2->setValue( b->Shade2 );
    		Layout4->addWidget( Shade2, 3, 1, Qt::AlignLeft );
    		Background = new QComboBox( true, Props, "Background" );
    		Background->setMinimumSize( QSize( 95, 21 ) );
    		Background->setEditable(false);
    		pm = QPixmap(15, 15);
    		Background->insertItem(tr("None"));
    		if (b->Pcolor == "None")
    			Background->setCurrentItem(Background->count()-1);
				for (it = Farben.begin(); it != Farben.end(); ++it)
					{
					pm.fill(Farben[it.key()].getRGBColor());
					Background->insertItem(pm, it.key());
    			if (it.key() == b->Pcolor)
    				{
    				Background->setCurrentItem(Background->count()-1);
    				}
					}
    		Layout4->addWidget( Background, 0, 1 );
    		Shade = new QSpinBox( Props, "Shade" );
    		Shade->setMinimumSize( QSize( 65, 22 ) );
    		Shade->setSuffix( tr( " %" ) );
    		Shade->setMaxValue( 100 );
    		Shade->setMinValue( 0 );
    		Shade->setValue( b->Shade );
    		Layout4->addWidget( Shade, 1, 1, Qt::AlignLeft );
    		Linestyle = new LineCombo(Props);
    		Linestyle->setMinimumSize( QSize( 95, 21 ) );
				switch (b->PLineArt)
					{
					case SolidLine:
						Linestyle->setCurrentItem(0);
						break;
					case DashLine:
						Linestyle->setCurrentItem(1);
						break;
					case DotLine:
						Linestyle->setCurrentItem(2);
						break;
					case DashDotLine:
						Linestyle->setCurrentItem(3);
						break;
					case DashDotDotLine:
						Linestyle->setCurrentItem(4);
						break;
					default:
						Linestyle->setCurrentItem(0);
						break;
					}
    		Layout4->addWidget( Linestyle, 4, 1 );
    		LineW = new QSpinBox( Props, "LineW" );
    		LineW->setMinimumSize( QSize( 65, 22 ) );
    		LineW->setSuffix( tr( " pts" ) );
    		LineW->setMaxValue( 12 );
    		LineW->setMinValue( 0 );
    		LineW->setValue( b->Pwidth );
    		Layout4->addWidget( LineW, 5, 1, Qt::AlignLeft );
		    if (b->PType == 5)
		    	{
    			LineW->setMinValue( 1 );
    			Background->setEnabled(false);
    			Shade->setEnabled(false);
    			TextLabel1_3->setEnabled(false);
    			TextLabel2->setEnabled(false);
		    	}
		    FlippedH->setEnabled(false);
		    FlippedV->setEnabled(false);
		    if (b->PType == 3)
		    	{
		    	TextLabel2_3b = new QLabel( Props, "TextLabel2_3b" );
    			TextLabel2_3b->setText( tr( "Corner Radius:" ) );
    			Layout4->addWidget( TextLabel2_3b, 6, 0 );
    			Radius = new QSpinBox(Props, "RR");
    			Radius->setMinimumSize( QSize( 65, 22 ) );
    			Radius->setSuffix( tr( " pt" ) );
   				Radius->setMaxValue(QMIN(b->Width,b->Height)/2 );
    			Radius->setMinValue(0);
    			Radius->setValue(qRound(b->RadRect));
    			Layout4->addWidget( Radius, 6, 1, Qt::AlignLeft );
    			}
    		break;
    	}
    PropsLayout->addLayout( Layout4 );
    Layout5->addMultiCellWidget( Props, 0, 1, 1, 1 );
		Layout5->addColSpacing(0, GroupSpecial->layout()->minimumSize().width()+20);
    ModObjLayout->addLayout( Layout5 );

    Layout3 = new QHBoxLayout;
    Layout3->setSpacing( 6 );
    Layout3->setMargin( 10 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout3->addItem( spacer );
    Cancel = new QPushButton( this, "Cancel" );
    Cancel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, Cancel->sizePolicy().hasHeightForWidth() ) );
    Cancel->setMinimumSize( QSize( 100, 31 ) );
    Cancel->setText( tr( "Cancel" ) );
    Layout3->addWidget( Cancel );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout3->addItem( spacer_2 );
    Apply = new QPushButton( this, "Apply" );
    Apply->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, Apply->sizePolicy().hasHeightForWidth() ) );
    Apply->setMinimumSize( QSize( 100, 31 ) );
    Apply->setText( tr( "Apply" ) );
    Layout3->addWidget( Apply );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout3->addItem( spacer_3 );
    OK = new QPushButton( this, "OK" );
    OK->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, OK->sizePolicy().hasHeightForWidth() ) );
    OK->setMinimumSize( QSize( 100, 31 ) );
    OK->setText( tr( "OK" ) );
    OK->setDefault( TRUE );
    Layout3->addWidget( OK );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout3->addItem( spacer_4 );
    ModObjLayout->addLayout( Layout3 );
    UnitChange();
    setMinimumSize(ModObjLayout->minimumSize());
    // signals and slots connections
    connect(Cancel, SIGNAL(clicked()), this, SLOT(reject()));
    connect(OK, SIGNAL(clicked()), this, SLOT(DoModifyExit()));
    connect(Apply, SIGNAL(clicked()), this, SLOT(DoModify()));
}

/*  
 *  Destroys the object and frees any allocated resources
 */
ModObj::~ModObj()
{
    // no need to delete child widgets, Qt does it all for us
}

void ModObj::keyPressEvent(QKeyEvent *k)
{
	if (k->key() == Key_Shift)
		{
    Xpos->setLineStep(10);
    Ypos->setLineStep(10);
    Width->setLineStep(10);
    Height->setLineStep(10);
    Angle->setLineStep(10);
		switch (CurMod->PType)
			{
			case 4:
    		Distance->setLineStep(1);
    		break;
    	case 2:
    		LXpos->setLineStep(10);
    		LYpos->setLineStep(10);
    		HScale->setLineStep(1);
    		VScale->setLineStep(1);
    		break;
    	}
		}
}

void ModObj::keyReleaseEvent(QKeyEvent *k)
{
	if (k->key() == Key_Shift)
		{
    Xpos->setLineStep(100);
    Ypos->setLineStep(100);
    Width->setLineStep(100);
    Height->setLineStep(100);
    Angle->setLineStep(100);
		switch (CurMod->PType)
			{
			case 4:
    		Distance->setLineStep(10);
    		break;
    	case 2:
    		LXpos->setLineStep(100);
    		LYpos->setLineStep(100);
    		HScale->setLineStep(10);
    		VScale->setLineStep(10);
    		break;
    	}
		}
}

void ModObj::DoModifyExit()
{
	DoModify();
	accept();
}

void ModObj::DoModify()
{
	int itNr = CurMod->ItemNr;
	doc->ActPage->MoveItem(float(Xpos->value())/Umrech/100-CurMod->Xpos, 0, itNr);
	doc->ActPage->MoveItem(0, float(Ypos->value())/Umrech/100-CurMod->Ypos, itNr);
	if (origWidth != Width->value())
		doc->ActPage->SizeItem(float(Width->value())/Umrech/100, CurMod->Height, itNr);
	origWidth = Width->value();
	if (origHeight != Height->value())
		doc->ActPage->SizeItem(CurMod->Width, float(Height->value())/Umrech/100, itNr);
	origHeight = Height->value();
	doc->ActPage->RotateItem(float(Angle->value())/-100, itNr);
	CurMod->isPrintable = !Printable->isChecked();
	CurMod->Textflow = Textflow->isChecked();
	CurMod->flippedH = int(FlippedH->isChecked());
	CurMod->flippedV = int(FlippedV->isChecked());
	switch (CurMod->PType)
		{
		case 4:
			CurMod->isBookmark = false;
			CurMod->isAnnotation = false;
			if (Bookmark->isChecked())
				CurMod->isBookmark = true;
			if (Annotation->isChecked())
				CurMod->isAnnotation = true;
			CurMod->Extra = float(Distance->value()) / 10;
			CurMod->Pcolor = Background->currentText();
			if (CurMod->Pcolor == tr("None"))
				CurMod->Pcolor = "None";
			CurMod->Shade = Shade->value();
			CurMod->Dirty = true;
			if (!CurMod->ClipEdited)
				{
				CurMod->RadRect = float(Radius->value());
				if (Radius->value() != 0)
					{
					CurMod->FrameType = 2;
					CurMod->PLineJoin = RoundJoin;
					}
				else
					{
					CurMod->FrameType = 0;
					CurMod->PLineJoin = MiterJoin;
					}
				doc->ActPage->UpdateClip(CurMod);
				}
			break;
		case 2:
			CurMod->Pcolor = Background->currentText();
			if (CurMod->Pcolor == tr("None"))
				CurMod->Pcolor = "None";
			CurMod->Shade = Shade->value();
			CurMod->PicArt = Visible->isChecked();
			CurMod->LocalX = float(LXpos->value())/ Umrech / 100;
			CurMod->LocalY = float(LYpos->value())/ Umrech / 100;
			CurMod->LocalScX = float(HScale->value()) / 1000;
			CurMod->LocalScY = float(VScale->value()) / 1000;
			if (!CurMod->ClipEdited)
				{
				CurMod->RadRect = float(Radius->value());
				if (Radius->value() != 0)
					{
					CurMod->FrameType = 2;
					CurMod->PLineJoin = RoundJoin;
					}
				else
					{
					CurMod->FrameType = 0;
					CurMod->PLineJoin = MiterJoin;
					}
				doc->ActPage->UpdateClip(CurMod);
				}
#ifdef HAVE_CMS
			if ((CMSuse) && (CMSavail))
				{
				bool CMchange = false;
				if (CurMod->IProfile != InputP->currentText())
					{
					CurMod->IProfile = InputP->currentText();
					CMchange = true;
					}
				if (CurMod->IRender != MonitorI->currentItem())
					{
					CurMod->IRender = MonitorI->currentItem();
					CMchange = true;
					}
				if (CurMod->UseEmbedded != EmbedP)
					{
					CurMod->UseEmbedded = EmbedP;
					CMchange = true;
					}
				if (CMchange)
					doc->ActPage->LoadPict(CurMod->Pfile, CurMod->ItemNr);
				}
#endif
			break;
		default:
			if (CurMod->PType != 5)
				{
				CurMod->Pcolor = Background->currentText();
				if (CurMod->Pcolor == tr("None"))
					CurMod->Pcolor = "None";
				CurMod->Shade = Shade->value();
				}
			if (CurMod->PType == 3)
				{
				if (!CurMod->ClipEdited)
					{
					CurMod->RadRect = float(Radius->value());
					if (Radius->value() != 0)
						CurMod->PLineJoin = RoundJoin;
					else
						CurMod->PLineJoin = MiterJoin;
					}
				}
			CurMod->Pcolor2 = Foreground->currentText();
			if (CurMod->Pcolor2 == tr("None"))
				CurMod->Pcolor2 = "None";
			CurMod->Shade2 = Shade2->value();
			CurMod->Pwidth = LineW->value();
			switch (Linestyle->currentItem())
				{
				case 0:
					CurMod->PLineArt = SolidLine;
					break;
				case 1:
					CurMod->PLineArt = DashLine;
					break;
				case 2:
					CurMod->PLineArt = DotLine;
					break;
				case 3:
					CurMod->PLineArt = DashDotLine;
					break;
				case 4:
					CurMod->PLineArt = DashDotDotLine;
					break;
				}
			break;
		}
	doc->ActPage->repaint();
	emit DocChanged();
}

void ModObj::ToggleKette()
{
	if (Kette->isOn())
		{
		VScale->setValue(HScale->value());
		}		
}

void ModObj::HChange()
{
	if (Kette->isOn())
		{
		VScale->setValue(HScale->value());
		}
}

void ModObj::VChange()
{
	if (Kette->isOn())
		{
		HScale->setValue(VScale->value());
		}
}

void ModObj::UnitChange()
{
	if (doc->Einheit == 0)
		{
		Umrech = 1.0;
    Xpos->setSuffix( tr( " pt" ) );
    Ypos->setSuffix( tr( " pt" ) );
    Width->setSuffix( tr( " pt" ) );
    Height->setSuffix( tr( " pt" ) );
    if (CurMod->PType == 2)
    	{
    	LXpos->setSuffix( tr( " pt" ) );
    	LYpos->setSuffix( tr( " pt" ) );
    	}
    if (CurMod->PType == 3)
    	Radius->setSuffix( tr( " pt" ) );
		}
	else
		{
		Umrech = 0.3527777;
    Xpos->setSuffix( tr( " mm" ) );
    Ypos->setSuffix( tr( " mm" ) );
    Width->setSuffix( tr( " mm" ) );
    Height->setSuffix( tr( " mm" ) );
    if (CurMod->PType == 2)
    	{
    	LXpos->setSuffix( tr( " mm" ) );
    	LYpos->setSuffix( tr( " mm" ) );
    	}
    if (CurMod->PType == 3)
    	Radius->setSuffix( tr( " mm" ) );
		}
}

void ModObj::EmProf(const QString& prn)
{
	if (prn.startsWith("Embedded"))
    EmbedP = true;
	else
    EmbedP = false;
}
