#include "mpal.h"
#include "mpal.moc"
extern QPixmap loadIcon(QString nam);

Mpalette2::Mpalette2( QWidget* parent, QPopupMenu* FontMenu )
    : QDialog( parent, "Edit", 0, WStyle_Customize | WStyle_NoBorderEx | WStyle_Tool)
{
    resize( 424, 72 );
    setMinimumSize( QSize( 424, 72 ) );
    setMaximumSize( QSize( 424, 72 ) );
    setFocusPolicy(ClickFocus);
    QFont f( font() );
    f.setPointSize( 10 );
    setFont( f );
    setCaption( tr( "Measurements" ) );
    HaveDoc = false;
    HaveItem = false;
    Umrech = 1.0;
    TA = new FPaletteV( this, 1, 1, 0 );
    TabWidget2 = new QTabWidget( this, "TabWidget2" );
    TabWidget2->setGeometry( QRect( 12, 1, 411, 70 ) );
    TabWidget2->setTabShape( QTabWidget::Triangular );

    tab = new QWidget( TabWidget2, "tab" );

    Text1 = new QLabel( tab, "Text1" );
    Text1->setGeometry( QRect( 10, 5, 21, 20 ) );
    Text1->setText( tr( "X:" ) );
    Text2 = new QLabel( tab, "Text2" );
    Text2->setGeometry( QRect( 10, 30, 21, 20 ) );
    Text2->setText( tr( "Y:" ) );
    Text3 = new QLabel( tab, "Text3" );
    Text3->setGeometry( QRect( 115, 5, 21, 20 ) );
    Text3->setText( tr( "W:" ) );
    Text4 = new QLabel( tab, "Text4" );
    Text4->setGeometry( QRect( 115, 30, 21, 20 ) );
    Text4->setText( tr( "H:" ) );
    Text5 = new QLabel( tab, "Text5" );
    Text5->setGeometry( QRect( 220, 5, 21, 20 ) );
    Text5->setText( tr( "" ) );
    Text5->setPixmap(loadIcon("Winkel.xpm"));
    Text5a = new QLabel( tab, "Text5a" );
    Text5a->setGeometry( QRect( 220, 30, 21, 20 ) );
    Text5a->setText( tr( "" ) );
    Text5a->setPixmap(loadIcon("Corner.xpm"));

    Xpos = new MSpinBox( tab, 2 );
    Xpos->setGeometry( QRect( 32, 5, 75, 20 ) );
    Xpos->setSuffix( tr( " pt" ) );
    Xpos->setMaxValue( 300000 );
    Xpos->setMinValue( -300000 );
    Xpos->setLineStep(100);
    Ypos = new MSpinBox( tab, 2 );
    Ypos->setGeometry( QRect( 32, 30, 75, 20 ) );
    Ypos->setSuffix( tr( " pt" ) );
    Ypos->setMaxValue( 300000 );
    Ypos->setMinValue( -300000 );
    Ypos->setLineStep(100);
    Width = new MSpinBox( tab, 2 );
    Width->setGeometry( QRect( 137, 5, 75, 20 ) );
    Width->setSuffix( tr( " pt" ) );
    Width->setMaxValue( 300000 );
//    Width->setMinValue( -300000 );
    Width->setMinValue( 100 );
    Width->setLineStep(100);
    Height = new MSpinBox( tab, 2 );
    Height->setGeometry( QRect( 137, 30, 75, 20 ) );
    Height->setSuffix( tr( " pt" ) );
    Height->setMaxValue( 300000 );
//    Height->setMinValue( -300000 );
    Height->setMinValue( 100 );
    Height->setLineStep(100);
    Rot = new MSpinBox( tab, 2 );
    Rot->setGeometry( QRect( 244, 5, 65, 20 ) );
    Rot->setSuffix( tr( " " ) );
    Rot->setMaxValue( 36000 );
    Rot->setMinValue( -36000 );
    Rot->setLineStep(100);
    RoundRect = new QSpinBox( tab, "size" );
    RoundRect->setGeometry( QRect( 244, 30, 65, 20 ) );
    RoundRect->setSuffix( tr( " pt" ) );
    RoundRect->setMaxValue( 36000 );
    RoundRect->setMinValue( 0 );
    RoundRect->setEnabled(false);

    TabWidget2->insertTab( tab, tr( "Frame" ) );

    tab_3 = new QWidget( TabWidget2, "tab_3" );

    tab_2 = new QWidget( tab_3, "tab_2" );
    tab_2->resize(411, 70);
    Text6 = new QLabel( tab_2, "Text6" );
    Text6->setGeometry( QRect( 10, 5, 21, 20 ) );
    Text6->setText( tr( "" ) );
    Text6->setPixmap(loadIcon("Spacing.xpm"));
    Text7 = new QLabel( tab_2, "Text7" );
    Text7->setGeometry( QRect( 10, 30, 21, 20 ) );
    Text7->setText( tr( "" ) );
    Text7->setPixmap(loadIcon("Kern.xpm"));
    Text9 = new QLabel(tab_2, "Text9");
    Text9->setGeometry(QRect(130,5,128,20));
    Text9->setText("");
    Text9->setFrameStyle(QFrame::Panel | QFrame::Raised);
    Text9->setLineWidth(1);
    Fonts = new QToolButton(DownArrow, tab_2, "Fonts");
    Fonts->setGeometry( QRect( 255, 5, 20, 20 ) );
    Fonts->setPopup(FontMenu);
    Fonts->setPopupDelay(1);
    Plain = new QToolButton( tab_2, "Plain" );
    Plain->setGeometry( QRect( 105, 30, 20, 20 ) );
    Plain->setText( tr( "P" ) );
    Plain->setToggleButton(true);
    Bold = new QToolButton( tab_2, "Bold" );
    Bold->setGeometry( QRect( 127, 30, 20, 20 ) );
    Bold->setText( tr( "" ) );
    Bold->setPixmap(loadIcon("Fett.xpm"));
    Bold->setToggleButton(true);
    Italic = new QToolButton( tab_2, "Italic" );
    Italic->setGeometry( QRect( 149, 30, 20, 20 ) );
    Italic->setText( tr( "" ) );
    Italic->setPixmap(loadIcon("Italic.xpm"));
    Italic->setToggleButton(true);
    Underline = new QToolButton( tab_2, "Underline" );
    Underline->setGeometry( QRect( 171, 30, 20, 20 ) );
    Underline->setText( tr( "" ) );
    Underline->setPixmap(loadIcon("Unter.xpm"));
    Underline->setToggleButton(true);
    Subs = new QToolButton( tab_2, "Subs" );
    Subs->setGeometry( QRect( 193, 30, 20, 20 ) );
    Subs->setText( tr( "" ) );
    Subs->setPixmap(loadIcon("Tief.xpm"));
    Subs->setToggleButton(true);
    Supers = new QToolButton( tab_2, "Supers" );
    Supers->setGeometry( QRect( 215, 30, 20, 20 ) );
    Supers->setText( tr( "" ) );
    Supers->setPixmap(loadIcon("Hoch.xpm"));
    Supers->setToggleButton(true);
    Kapital = new QToolButton( tab_2, "Kapital" );
    Kapital->setGeometry( QRect( 237, 30, 20, 20 ) );
    Kapital->setText( tr( "" ) );
    Kapital->setPixmap(loadIcon("Kapital.xpm"));
    Kapital->setToggleButton(true);
    Strike = new QToolButton( tab_2, "Strike" );
    Strike->setGeometry( QRect( 259, 30, 20, 20 ) );
    Strike->setToggleButton(true);
    Strike->setText( tr( "" ) );
    Strike->setPixmap(loadIcon("Strike.xpm"));
    FlipV = new QToolButton( tab_2, "Strike_2" );
    FlipV->setGeometry( QRect( 289, 30, 20, 20 ) );
    FlipV->setText( tr( "" ) );
    FlipV->setPixmap(loadIcon("FlipV.xpm"));
    FlipH = new QToolButton( tab_2, "Strike_2_2" );
    FlipH->setGeometry( QRect( 312, 30, 20, 20 ) );
    FlipH->setText( tr( "" ) );
    FlipH->setPixmap(loadIcon("FlipH.xpm"));
    Text8 = new QLabel( tab_2, "Text8" );
    Text8->setGeometry( QRect( 105, 5, 21, 20 ) );
    Text8->setText( tr( "" ) );
    Text8->setPixmap(loadIcon("Zeichen.xpm"));
    Size = new QSpinBox( tab_2, "size" );
    Size->setGeometry( QRect( 289, 5, 60, 20 ) );
    Size->setSuffix( tr( " pt" ) );
    Size->setMaxValue( 512 );
    Size->setMinValue( 1 );
    LineSp = new MSpinBox( tab_2, 1 );
    LineSp->setGeometry( QRect( 32, 5, 65, 20 ) );
    LineSp->setSuffix( tr( " pt" ) );
    LineSp->setMaxValue( 3000 );
    LineSp->setMinValue( 1 );
    LineSp->setLineStep(10);
    Extra = new MSpinBox( tab_2, 1 );
    Extra->setGeometry( QRect( 32, 30, 65, 20 ) );
    Extra->setSuffix( tr( " pt" ) );
    Extra->setMaxValue( 3000 );
    Extra->setMinValue( -3000 );
    Extra->setLineStep(10);
    KeyGroup = new QButtonGroup( tab_2, "TGroup" );
    KeyGroup->setGeometry( QRect( 355, 5, 55, 55 ) );
    KeyGroup->setFrameStyle(QFrame::NoFrame);
    KeyGroup->setExclusive(true);
    TextL = new QToolButton( KeyGroup, "TL" );
    TextL->setGeometry( QRect( 0, 0, 20, 20 ) );
    TextL->setToggleButton(true);
    TextL->setText( tr( "" ) );
    TextL->setPixmap(loadIcon("text_left.png"));
    TextR = new QToolButton( KeyGroup, "TR" );
    TextR->setGeometry( QRect( 25, 0, 20, 20 ) );
    TextR->setToggleButton(true);
    TextR->setText( tr( "" ) );
    TextR->setPixmap(loadIcon("text_right.png"));
    TextC = new QToolButton( KeyGroup, "TC" );
    TextC->setGeometry( QRect( 0, 25, 20, 20 ) );
    TextC->setToggleButton(true);
    TextC->setText( tr( "" ) );
    TextC->setPixmap(loadIcon("text_center.png"));
    TextB = new QToolButton( KeyGroup, "TB" );
    TextB->setGeometry( QRect( 25, 25, 20, 20 ) );
    TextB->setToggleButton(true);
    TextB->setText( tr( "" ) );
    TextB->setPixmap(loadIcon("text_block.png"));
    tab_2->hide();

    tab_4 = new QWidget( tab_3, "tab_4" );
    tab_4->resize(411, 70);
    Text10 = new QLabel( tab_4, "Text10" );
    Text10->setGeometry( QRect( 10, 5, 70, 20 ) );
    Text10->setText( tr( "Local X-Pos:" ) );
    Text11 = new QLabel( tab_4, "Text11" );
    Text11->setGeometry( QRect( 10, 30, 70, 20 ) );
    Text11->setText( tr( "Local Y-Pos:" ) );
    Text12 = new QLabel( tab_4, "Text12" );
    Text12->setGeometry( QRect( 165, 5, 65, 20 ) );
    Text12->setText( tr( "Scaling X:" ) );
    Text13 = new QLabel( tab_4, "Text13" );
    Text13->setGeometry( QRect( 165, 30, 65, 20 ) );
    Text13->setText( tr( "Scaling Y:" ) );
    LXpos = new MSpinBox( tab_4, 2 );
    LXpos->setGeometry( QRect( 85, 5, 75, 20 ) );
    LXpos->setSuffix( tr( " pt" ) );
    LXpos->setMaxValue( 300000 );
    LXpos->setMinValue( -300000 );
    LXpos->setLineStep(100);
    LYpos = new MSpinBox( tab_4, 2 );
    LYpos->setGeometry( QRect( 85, 30, 75, 20 ) );
    LYpos->setSuffix( tr( " pt" ) );
    LYpos->setMaxValue( 300000 );
    LYpos->setMinValue( -300000 );
    LYpos->setLineStep(100);
    ScaleX = new MSpinBox( tab_4, 1 );
    ScaleX->setGeometry( QRect( 230, 5, 65, 20 ) );
    ScaleX->setSuffix( tr( " %" ) );
    ScaleX->setMaxValue( 10000 );
    ScaleX->setMinValue( 10);
    ScaleX->setLineStep(10);
    ScaleY = new MSpinBox( tab_4, 1 );
    ScaleY->setGeometry( QRect( 230, 30, 65, 20 ) );
    ScaleY->setSuffix( tr( " %" ) );
    ScaleY->setMaxValue( 10000 );
    ScaleY->setMinValue( 10 );
    ScaleY->setLineStep(10);
    Kette = new LinkButton( tab_4 );
    Kette->setGeometry( QRect( 295, 5, 16, 45 ) );
    Kette->setToggleButton( TRUE );
    Kette->setAutoRaise( TRUE );
    FlipH2 = new QToolButton( tab_4, "FlipH2" );
    FlipH2->setGeometry( QRect( 325, 30, 20, 20 ) );
    FlipH2->setText( tr( "" ) );
    FlipH2->setPixmap(loadIcon("FlipH.xpm"));
    FlipV2 = new QToolButton( tab_4, "FlipV2" );
    FlipV2->setGeometry( QRect( 325, 5, 20, 20 ) );
    FlipV2->setText( tr( "" ) );
    FlipV2->setPixmap(loadIcon("FlipV.xpm"));
    tab_4->hide();

    tab_5 = new QWidget( tab_3, "tab_4" );
    tab_5->resize(411, 70);
    Text15 = new QLabel( tab_5, "Text15" );
    Text15->setGeometry( QRect( 10, 5, 60, 20 ) );
    Text15->setText( tr( "Linestyle:" ) );
    Text16 = new QLabel( tab_5, "Text16" );
    Text16->setGeometry( QRect( 10, 30, 60, 20 ) );
    Text16->setText( tr( "Linewidth:" ) );
    LSize = new QSpinBox( tab_5, "LSize" );
    LSize->setGeometry( QRect( 75, 30, 60, 20 ) );
    LSize->setSuffix( tr( " pt" ) );
    LSize->setMaxValue( 12 );
    LSize->setMinValue( 0 );
    LStyle = new LineCombo(tab_5);
    LStyle->setGeometry( QRect( 75, 5, 100, 20 ) );
    Text20 = new QLabel( tab_5, "Text15" );
    Text20->setGeometry( QRect( 200, 5, 60, 20 ) );
    Text20->setText( tr( "Edges:" ) );
    Text21 = new QLabel( tab_5, "Text16" );
    Text21->setGeometry( QRect( 200, 30, 60, 20 ) );
    Text21->setText( tr( "Endings:" ) );
    LJoinStyle = new QComboBox( true, tab_5, "LJ" );
    LJoinStyle->setGeometry( QRect( 270, 5, 100, 20 ) );
    LJoinStyle->setEditable(false);
    LJoinStyle->insertItem( tr( "MiterJoin" ) );
    LJoinStyle->insertItem( tr( "BevelJoin" ) );
    LJoinStyle->insertItem( tr( "RoundJoin" ) );
    LEndStyle = new QComboBox( true, tab_5, "Le" );
    LEndStyle->setGeometry( QRect( 270, 30, 100, 20 ) );
    LEndStyle->setEditable(false);
    LEndStyle->insertItem( tr( "FlatCap" ) );
    LEndStyle->insertItem( tr( "SquareCap" ) );
    LEndStyle->insertItem( tr( "RoundCap" ) );
    tab_5->hide();

    TabWidget2->insertTab( tab_3, tr( "Contents" ) );

    QToolTip::add(  Extra, tr( "Manual Kerning" ) );
    QToolTip::add(  LineSp, tr( "Linespacing" ) );
    QToolTip::add(  Size, tr( "Font Size" ) );
    QToolTip::add(  FlipH2, tr( "Flip horizontal" ) );
    QToolTip::add(  FlipV2, tr( "Flip vertical" ) );
    QToolTip::add(  FlipH, tr( "Flip horizontal" ) );
    QToolTip::add(  FlipV, tr( "Flip vertical" ) );
    QToolTip::add(  Strike, tr( "Strikeout" ) );
    QToolTip::add(  Kapital, tr( "Small Caps" ) );
    QToolTip::add(  Plain, tr( "Normal" ) );
    QToolTip::add(  Bold, tr( "Bold" ) );
    QToolTip::add(  Italic, tr( "Italic" ) );
    QToolTip::add(  Underline, tr( "Underline" ) );
    QToolTip::add(  Subs, tr( "Subscript" ) );
    QToolTip::add(  Supers, tr( "Superscript" ) );
    QToolTip::add(  TextL, tr( "Align Text Left" ) );
    QToolTip::add(  TextR, tr( "Align Text Right" ) );
    QToolTip::add(  TextC, tr( "Align Text Center" ) );
    QToolTip::add(  TextB, tr( "Align Text Block" ) );

    connect(Xpos, SIGNAL(valueChanged(int)), this, SLOT(NewX()));
    connect(Ypos, SIGNAL(valueChanged(int)), this, SLOT(NewY()));
    connect(Width, SIGNAL(valueChanged(int)), this, SLOT(NewW()));
    connect(Height, SIGNAL(valueChanged(int)), this, SLOT(NewH()));
    connect(Rot, SIGNAL(valueChanged(int)), this, SLOT(NewR()));
    connect(RoundRect, SIGNAL(valueChanged(int)), this, SLOT(NewRR()));
    connect(LineSp, SIGNAL(valueChanged(int)), this, SLOT(NewLsp()));
    connect(Size, SIGNAL(valueChanged(int)), this, SLOT(NewSize()));
    connect(Extra, SIGNAL(valueChanged(int)), this, SLOT(NewExtra()));
    connect(FlipH, SIGNAL(clicked()), this, SLOT(DoFlipH()));
    connect(FlipV2, SIGNAL(clicked()), this, SLOT(DoFlipV()));
    connect(FlipH2, SIGNAL(clicked()), this, SLOT(DoFlipH()));
    connect(FlipV, SIGNAL(clicked()), this, SLOT(DoFlipV()));
    connect(Kapital, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Bold, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Underline, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Strike, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Italic, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Plain, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Supers, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Subs, SIGNAL(clicked()), this, SLOT(setTypeStyle()));
    connect(Kette, SIGNAL(clicked()), this, SLOT(ToggleKette()));
    connect(ScaleX, SIGNAL(valueChanged(int)), this, SLOT(HChange()));
    connect(ScaleY, SIGNAL(valueChanged(int)), this, SLOT(VChange()));
    connect(LXpos, SIGNAL(valueChanged(int)), this, SLOT(NewLocalXY()));
    connect(LYpos, SIGNAL(valueChanged(int)), this, SLOT(NewLocalXY()));
    connect(LSize, SIGNAL(valueChanged(int)), this, SLOT(NewLS()));
    connect(LStyle, SIGNAL(activated(int)), this, SLOT(NewLSty()));
    connect(LJoinStyle, SIGNAL(activated(int)), this, SLOT(NewLJoin()));
    connect(LEndStyle, SIGNAL(activated(int)), this, SLOT(NewLEnd()));
    connect(KeyGroup, SIGNAL(clicked(int)), this, SLOT(NewAli()));
}

/*  
 *  Destroys the object and frees any allocated resources
 */
Mpalette2::~Mpalette2()
{
    // no need to delete child widgets, Qt does it all for us
}


bool Mpalette2::event( QEvent* ev )
{
    bool ret = QDialog::event( ev );
    if ( ev->type() == QEvent::ApplicationFontChange )
    	{
			QFont Strike_font(  Strike->font() );
			Strike_font.setStrikeOut( TRUE );
			Strike->setFont( Strike_font );
    	}
    return ret;
}

void Mpalette2::paintEvent(QPaintEvent *)
{	
	QPainter p;
	p.begin(this);
	p.setBrush(NoBrush);
  p.setPen(QPen(black, 2));
  p.drawRect(0, 0, width(), height());
	p.end();
}

void Mpalette2::keyPressEvent(QKeyEvent *k)
{
	if (k->key() == Key_Shift)
		{
    Xpos->setLineStep(10);
    Ypos->setLineStep(10);
    Width->setLineStep(10);
    Height->setLineStep(10);
    Rot->setLineStep(10);
    Extra->setLineStep(1);
    LineSp->setLineStep(1);
    LXpos->setLineStep(10);
    LYpos->setLineStep(10);
    ScaleX->setLineStep(1);
    ScaleY->setLineStep(1);
		}
}

void Mpalette2::keyReleaseEvent(QKeyEvent *k)
{
	if (k->key() == Key_Shift)
		{
    Xpos->setLineStep(100);
    Ypos->setLineStep(100);
    Width->setLineStep(100);
    Height->setLineStep(100);
    Rot->setLineStep(100);
    Extra->setLineStep(10);
    LineSp->setLineStep(10);
    LXpos->setLineStep(100);
    LYpos->setLineStep(100);
    ScaleX->setLineStep(10);
    ScaleY->setLineStep(10);
		}
}

void Mpalette2::SetDoc(ScribusDoc *d)
{
	doc = d;
	HaveDoc = true;
}

void Mpalette2::UnsetDoc()
{
	HaveDoc = false;
}

void Mpalette2::SetCurItem(PageItem *i)
{
	HaveItem = false;
	CurItem = i;
	Text9->setText(i->IFont);
	RoundRect->setValue(qRound(i->RadRect));
	if (((i->PType == 4) || (i->PType == 2) || (i->PType == 3)) &&  (!i->ClipEdited))
		RoundRect->setEnabled(true);
	else
		RoundRect->setEnabled(false);
	if (i->PType == 5)
		{
    Width->setMinValue( -300000 );
    Height->setMinValue( -300000 );
		}
	else
		{
    Width->setMinValue( 100 );
    Height->setMinValue( 100 );
		}
	HaveItem = true;
}

void Mpalette2::setXY(float x, float y)
{
	bool tmp = HaveItem;
	HaveItem = false;
	Xpos->setValue(qRound(x*Umrech*100));
	Ypos->setValue(qRound(y*Umrech*100));
	HaveItem = tmp;
}

void Mpalette2::setBH(float x, float y)
{
	bool tmp = HaveItem;
	HaveItem = false;
	RoundRect->setMaxValue(QMIN(x, y)/2);
	Width->setValue(qRound(x*Umrech*100));
	Height->setValue(qRound(y*Umrech*100));
	HaveItem = tmp;
}

void Mpalette2::setR(float r)
{
	bool tmp = HaveItem;
	HaveItem = false;
	Rot->setValue(qRound(-r*100));
	HaveItem = tmp;
}

void Mpalette2::setRR(float r)
{
	bool tmp = HaveItem;
	HaveItem = false;
	RoundRect->setValue(qRound(r));
	HaveItem = tmp;
}

void Mpalette2::setLsp(float r)
{
	bool tmp = HaveItem;
	HaveItem = false;
	LineSp->setValue(qRound(r*10));
	HaveItem = tmp;
}

void Mpalette2::setSize(int s)
{
	bool tmp = HaveItem;
	HaveItem = false;
	Size->setValue(s);
	HaveItem = tmp;
}

void Mpalette2::setExtra(float e)
{
	bool tmp = HaveItem;
	HaveItem = false;
	Extra->setValue(qRound(e*10));
	HaveItem = tmp;
}

void Mpalette2::setStil(int s)
{
	Supers->setOn(false);
	Subs->setOn(false);
	Italic->setOn(false);
	Plain->setOn(false);
	Strike->setOn(false);
	Underline->setOn(false);
	Bold->setOn(false);
	Kapital->setOn(false);
	if (s == 0)
		Plain->setOn(true);
	if (s & 1)
		Supers->setOn(true);
	if (s & 2)
		Subs->setOn(true);
	if (s & 4)
		Italic->setOn(true);
	if (s & 8)
		Underline->setOn(true);
	if (s & 16)
		Strike->setOn(true);
	if (s & 32)
		Bold->setOn(true);
	if (s & 64)
		Kapital->setOn(true);
}

void Mpalette2::setLvalue(float scx, float scy, float x, float y)
{
	bool tmp = HaveItem;
	HaveItem = false;
	LXpos->setValue(qRound(x * Umrech * 100));
	LYpos->setValue(qRound(y * Umrech * 100));
	ScaleX->setValue(qRound(scx * 1000));
	ScaleY->setValue(qRound(scy * 1000));
	HaveItem = tmp;
}

void Mpalette2::setSvalue(int s)
{
	bool tmp = HaveItem;
	HaveItem = false;
	LSize->setValue(s);
	HaveItem = tmp;
}

void Mpalette2::setLIvalue(PenStyle p, PenCapStyle pc, PenJoinStyle pj)
{
	bool tmp = HaveItem;
	HaveItem = false;
	switch (p)
		{
		case SolidLine:
			LStyle->setCurrentItem(0);
			break;
		case DashLine:
			LStyle->setCurrentItem(1);
			break;
		case DotLine:
			LStyle->setCurrentItem(2);
			break;
		case DashDotLine:
			LStyle->setCurrentItem(3);
			break;
		case DashDotDotLine:
			LStyle->setCurrentItem(4);
			break;
		default:
			LStyle->setCurrentItem(0);
			break;
		}
	switch (pc)
		{
		case FlatCap:
			LEndStyle->setCurrentItem(0);
			break;
		case SquareCap:
			LEndStyle->setCurrentItem(1);
			break;
		case RoundCap:
			LEndStyle->setCurrentItem(2);
			break;
		default:
			LEndStyle->setCurrentItem(0);
			break;
		}
	switch (pj)
		{
		case MiterJoin:
			LJoinStyle->setCurrentItem(0);
			break;
		case BevelJoin:
			LJoinStyle->setCurrentItem(1);
			break;
		case RoundJoin:
			LJoinStyle->setCurrentItem(2);
			break;
		default:
			LJoinStyle->setCurrentItem(0);
			break;
		}
	HaveItem = tmp;
}

void Mpalette2::NewX()
{
	float x;
	if ((HaveDoc) && (HaveItem))
		{
		x = float(Xpos->value()) / Umrech / 100;
		doc->ActPage->MoveItem(x - CurItem->Xpos, 0, *doc->ActPage->SelItem.at(0));
		emit DocChanged();
		}
}

void Mpalette2::NewY()
{
	float x;
	if ((HaveDoc) && (HaveItem))
		{
		x = float(Ypos->value()) / Umrech / 100;
		doc->ActPage->MoveItem(0, x - CurItem->Ypos, *doc->ActPage->SelItem.at(0));
		emit DocChanged();
		}
}

void Mpalette2::NewW()
{
	float x;
	if ((HaveDoc) && (HaveItem))
		{
		x = float(Width->value()) / Umrech / 100;
		doc->ActPage->SizeItem(x, CurItem->Height, *doc->ActPage->SelItem.at(0));
		emit DocChanged();
		}
}

void Mpalette2::NewH()
{
	float x;
	if ((HaveDoc) && (HaveItem))
		{
		x = float(Height->value()) / Umrech / 100;
		doc->ActPage->SizeItem(CurItem->Width, x, *doc->ActPage->SelItem.at(0));
		emit DocChanged();
		}
}

void Mpalette2::NewR()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->RotateItem(float(Rot->value())/100*(-1), *doc->ActPage->SelItem.at(0));
		emit DocChanged();
		}
}

void Mpalette2::NewRR()
{
	if ((HaveDoc) && (HaveItem))
		{
		CurItem->RadRect = RoundRect->value();
		if (CurItem->PType != 3)
			doc->ActPage->SetFrameRounded();
		else
			doc->ActPage->RefreshItem(CurItem);
		emit DocChanged();
		}
}

void Mpalette2::NewLsp()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLineSpa(float(LineSp->value())/10);
		emit DocChanged();
		}
}

void Mpalette2::NewSize()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->chFSize(Size->value());
		emit DocChanged();
		}
}

void Mpalette2::NewExtra()
{
	if ((HaveDoc) && (HaveItem))
		{
		if ((CurItem->HasSel) || (doc->AppMode == 1))
			{
			doc->ActPage->chKerning(float(Extra->value())/10);
			emit DocChanged();
			}
		else
			{
			if (uint(CurItem->CPos) != CurItem->Ptext.count())
				{
				CurItem->Ptext.at(CurItem->CPos)->cextra = float(Extra->value())/10;
				CurItem->Dirty = true;
				CurItem->paintObj();
				emit DocChanged();
				}
			}
		}
}

void Mpalette2::NewAli()
{
	if ((HaveDoc) && (HaveItem))
		{
		if (TextL->isOn())
			emit NewAbStyle(0);
		if (TextR->isOn())
			emit NewAbStyle(2);
		if (TextC->isOn())
			emit NewAbStyle(1);
		if (TextB->isOn())
			emit NewAbStyle(3);
		}
}

void Mpalette2::setAli(int e)
{
	bool tmp = HaveItem;
	HaveItem = false;
	switch (e)
		{
		case 0:
			TextL->setOn(true);
			break;
		case 2:
			TextR->setOn(true);
			break;
		case 1:
			TextC->setOn(true);
			break;
		case 3:
			TextB->setOn(true);
			break;
		default:
			TextL->setOn(false);
			TextR->setOn(false);
			TextC->setOn(false);
			TextB->setOn(false);
			break;
		}
	HaveItem = tmp;
}

void Mpalette2::DoFlipH()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->FlipImageH();
		emit DocChanged();
		}
}

void Mpalette2::DoFlipV()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->FlipImageV();
		emit DocChanged();
		}
}

void Mpalette2::setTypeStyle()
{
	emit BackHome();
	if (Supers == sender())
		{
		emit Stellung(1);
		Subs->setOn(false);
		Plain->setOn(false);
		return;
		}
	if (Subs == sender())
		{
		emit Stellung(2);
		Plain->setOn(false);
		Supers->setOn(false);
		return;
		}
	if (Italic == sender())
		{
		emit Stellung(4);
		Plain->setOn(false);
		return;
		}
	if (Underline == sender())
		{
		emit Stellung(8);
		Plain->setOn(false);
		return;
		}
	if (Strike == sender())
		{
		emit Stellung(16);
		Plain->setOn(false);
		return;
		}
	if (Bold == sender())
		{
		emit Stellung(32);
		Plain->setOn(false);
		return;
		}
	if (Kapital == sender())
		{
		emit Stellung(64);
		Plain->setOn(false);
		return;
		}
	if (Plain == sender())
		{
		Plain->setOn(true);
		Subs->setOn(false);
		Supers->setOn(false);
		Italic->setOn(false);
		Strike->setOn(false);
		Underline->setOn(false);
		Bold->setOn(false);
		Kapital->setOn(false);
		emit Stellung(0);
		return;
		}
	emit Stellung(0);
}

void Mpalette2::NewLocalXY()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLocalXY(float(LXpos->value()) / Umrech / 100, float(LYpos->value()) / Umrech / 100);
		emit DocChanged();
		}
}

void Mpalette2::NewLocalSC()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLocalSc(float(ScaleX->value()) / 1000, float(ScaleY->value()) / 1000);
		emit DocChanged();
		}
}

void Mpalette2::NewLS()
{
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLineWidth(LSize->value());
		emit DocChanged();
		}
}

void Mpalette2::NewLSty()
{
	PenStyle c = SolidLine;
	switch (LStyle->currentItem())
		{
		case 0:
			c = SolidLine;
			break;
		case 1:
			c = DashLine;
			break;
		case 2:
			c = DotLine;
			break;
		case 3:
			c = DashDotLine;
			break;
		case 4:
			c = DashDotDotLine;
			break;
		}
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLineArt(c);
		emit DocChanged();
		}
}

void Mpalette2::NewLJoin()
{
	PenJoinStyle c = MiterJoin;
	switch (LJoinStyle->currentItem())
		{
		case 0:
			c = MiterJoin;
			break;
		case 1:
			c = BevelJoin;
			break;
		case 2:
			c = RoundJoin;
			break;
		}
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLineJoin(c);
		emit DocChanged();
		}
}

void Mpalette2::NewLEnd()
{
	PenCapStyle c = FlatCap;
	switch (LEndStyle->currentItem())
		{
		case 0:
			c = FlatCap;
			break;
		case 1:
			c = SquareCap;
			break;
		case 2:
			c = RoundCap;
			break;
		}
	if ((HaveDoc) && (HaveItem))
		{
		doc->ActPage->ChLineEnd(c);
		emit DocChanged();
		}
}

void Mpalette2::NewSel(int nr)
{
	switch (nr)
		{
		case -1:
			HaveItem = false;
			Xpos->setValue(0);
			Ypos->setValue(0);
			Width->setValue(0);
			Height->setValue(0);
			Rot->setValue(0);
			RoundRect->setValue(0);
			RoundRect->setEnabled(false);
			tab_2->hide();
			tab_4->hide();
			tab_5->hide();
			break;
		case 2:
			tab_4->show();
			tab_5->hide();
			tab_2->hide();
			HaveItem = true;
			break;
		case 4:
			tab_2->show();
			tab_4->hide();
			tab_5->hide();
			HaveItem = true;
			break;
		default:
			tab_5->show();
			tab_4->hide();
			tab_2->hide();
			if (nr == 5)
				LSize->setMinValue(1);
			else
				LSize->setMinValue(0);
			HaveItem = true;
			break;
		}
}

void Mpalette2::ToggleKette()
{
	if (Kette->isOn())
		{
		ScaleY->setValue(ScaleX->value());
		NewLocalSC();
		}	
}

void Mpalette2::HChange()
{
	if (Kette->isOn())
		{
		ScaleY->setValue(ScaleX->value());
		}
	NewLocalSC();
}

void Mpalette2::VChange()
{
	if (Kette->isOn())
		{
		ScaleX->setValue(ScaleY->value());
		}
	NewLocalSC();
}

void Mpalette2::UnitChange()
{
	float old = Umrech;
	bool tmp = HaveItem;
	HaveItem = false;
	if (doc->Einheit == 0)
		{
		Umrech = 1.0;
    Xpos->setSuffix( tr( " pt" ) );
    Ypos->setSuffix( tr( " pt" ) );
    Width->setSuffix( tr( " pt" ) );
    Height->setSuffix( tr( " pt" ) );
    LXpos->setSuffix( tr( " pt" ) );
    LYpos->setSuffix( tr( " pt" ) );
    if (old != 1.0)
    	{
			Xpos->setValue(qRound(float(Xpos->value()) / old));
			Ypos->setValue(qRound(float(Ypos->value()) / old));
			Width->setValue(qRound(float(Width->value()) / old));
			Height->setValue(qRound(float(Height->value()) / old));
			LXpos->setValue(qRound(float(LXpos->value()) / old));
			LYpos->setValue(qRound(float(LYpos->value()) / old));
    	}
		}
	else
		{
		Umrech = 0.3527777;
    Xpos->setSuffix( tr( " mm" ) );
    Ypos->setSuffix( tr( " mm" ) );
    Width->setSuffix( tr( " mm" ) );
    Height->setSuffix( tr( " mm" ) );
    LXpos->setSuffix( tr( " mm" ) );
    LYpos->setSuffix( tr( " mm" ) );
    if (old == 1.0)
    	{
			Xpos->setValue(qRound(float(Xpos->value()) * Umrech));
			Ypos->setValue(qRound(float(Ypos->value()) * Umrech));
			Width->setValue(qRound(float(Width->value()) * Umrech));
			Height->setValue(qRound(float(Height->value()) * Umrech));
			LXpos->setValue(qRound(float(LXpos->value()) * Umrech));
			LYpos->setValue(qRound(float(LYpos->value()) * Umrech));
    	}
		}
	HaveItem = tmp;
}
