/***************************************************************************
 *  Module:      $Id: client.c,v 2.17 1997/12/31 05:18:32 nemesis Exp nemesis $
 *  Description: Client mode functions of sendpage
 *  Author:      maf, cjc
 *
 * Copyright (c) 1995 Mark Fullmer and The Ohio State University
 * Copyright (c) 1997 Cornelius Cook and Counterpoint Networking, Inc.
 * http://www.cpoint.net/projects/sendpage
 ***************************************************************************/
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
$Log: client.c,v $
Revision 2.17  1997/12/31 05:18:32  nemesis
CLOCAL for all, GCC fixes, WAIT_WORD finished

Revision 2.16  1997/12/28 23:20:45  nemesis
include cleanups, configure additions/corrections

Revision 2.15  1997/12/25 08:30:52  nemesis
code cleanups

Revision 2.14  1997/12/25 06:44:34  nemesis
time_t declarations and "make install" fix

Revision 2.13  1997/12/24 21:50:04  nemesis
mailing list updates

Revision 2.12  1997/12/24 21:42:54  nemesis
0.8a released.

Revision 2.11  1997/12/24 21:02:02  nemesis
more changes

Revision 2.10  1997/12/24 20:56:03  nemesis
gearing up for 0.8a more

Revision 2.9  1997/12/24 20:45:35  nemesis
trying to make 0.8a release

Revision 2.8  1997/12/24 20:29:08  nemesis
fixed up autoconf modifications, cleaned up signal stuff

Revision 2.7  1997/12/24 20:15:13  nemesis
sendpage.h now mostly contained within 'configure'

Revision 2.6  1997/12/24 19:52:04  nemesis
fixing posix checking

Revision 2.5  1997/12/24 19:41:49  nemesis
posix additions, syslog autoconf'd

Revision 2.4  1997/12/24 19:33:03  nemesis
check for POSIX

Revision 2.3  1997/12/17 09:37:27  nemesis
more autoconf changes... mostly strerror.o

Revision 2.2  1997/12/17 08:24:05  nemesis
autoconf-ing

Revision 2.1  1997/12/17 08:03:38  nemesis
adjustments

Revision 2.0  1997/12/17 08:01:05  nemesis
setting up autoconf

Revision 1.9  1997/12/17 07:56:23  nemesis
starting on the autoconfing

Revision 1.8  1997/12/17 04:47:05  nemesis
still adjusting

Revision 1.7  1997/12/17 04:46:25  nemesis
adjusting version numbers

Revision 1.6  1997/12/17 04:44:36  nemesis
*** empty log message ***

Revision 1.1  1997/12/15 15:56:04  nemesis
Initial revision

 * Revision 1.10  1996/02/14  07:23:13  maf
 * X-Loop: sendpage detector
 *
 * Revision 1.9  1996/02/13  11:18:10  maf
 * RFC822 header parsing
 *
 * Revision 1.8  1996/02/13  04:37:51  maf
 * nomail fix
 *
 * Revision 1.7  1996/02/12  03:49:47  maf
 * entry.status -> entry.flags, emailCC support
 *
 * Revision 1.6  1995/12/18  00:00:01  maf
 *  AddMessageQueue() mode flag
 *
 * Revision 1.5  1995/11/13  04:41:45  maf
 * *** empty log message ***
 *
 * Revision 1.4  1995/10/09  01:38:01  maf
 * concat input to single message now.
 *
 * Revision 1.3  1995/03/17  04:12:38  maf
 * STATUS_EXPANDED should not have been set for the max messages limit
 *
 * Revision 1.2  1995/03/15  04:40:30  maf
 * *** empty log message ***
 *
 * Revision 1.1  1995/01/10  01:34:02  maf
 * Initial revision
 *
*/


#include "sendpage.h"
#include "report.h"
#include "queue.h"
#include "misc.h"

/*********************************************************************
 * Function: BeAClient
 *	high level sendpage client function.
 *
 *	args:
 *	        argc		command line
 *		argv		""
 *		optind		from getopt
 *		useBody		if true, skips all messages until blank line
 *					-- for interfacing with sendmail
 *		sender		the sender's e-mail address
 *		sendnow		try to signal the daemon to send the message now?
 *		nomail		if true don't setup for mail response.
 *		dropSig		if true try to drop a e-mail signature line
 *		header		e-mail header to use for message
 *
 * Returns:     EX_OK		good --	messages accepted, daemon notified.
 * 		EX_OK		good -- messages accepted, daemon not notified
 *		EX_SOFTWARE	bad  -- some unrecoverable error, message is 
 *                                      printed
 *		EX_NOINPUT	bad -- no messages or too many messages
 *
 *********************************************************************/
int BeAClient(int argc, char * argv[], int optind, int useBody, 
	      char * sender, int sendnow, int dropSig, int nomail,
	      char * header) {
  struct dynstring msg;
  struct linebuf linebuf;
  struct messagequeue entry;
  char *p, *qfname, *c;
  extern int debug;
  int i, err, nrecipients, ret;
  char * j;
  unsigned int pid;
  FILE *FP;
  char nullbyte;
  int skipToEnd;
  int readHeaderLine, inHeader;
  int headerLen, lastWasBlank, headBufUsed;
  
  bzero(&msg, sizeof(msg));
  bzero(&linebuf, sizeof(linebuf));
  bzero(&entry, sizeof(entry));
  err = EX_NOINPUT;	/* fatal */
  nullbyte = 0;
  pid = 0;
  skipToEnd = 0;	/* don't skip to EOF */
  inHeader = 1;		/* yes */
  readHeaderLine = 0;	/* no */
  lastWasBlank = 0;	/* no */
  headBufUsed = 0;	/* no */
  
  headerLen = strlen(header);	
  
  /* calculate # of recipients  */
  nrecipients = argc - optind;
  
  /* can't send pages without recipients... */
  if (!nrecipients) {
    fprintf(stderr, "No valid recipients.\n");
    goto BeAClientout;
  }
  
  while (1) {
    if ((ret = GetLine(STDIN_FILENO, &linebuf)) < 0) {
      fprintf(stderr, "GetLine() failed\n");
      goto BeAClientout;
    }
    
    if (skipToEnd)
      goto skip1;
    
    /*
     * if in the header portion, and in 'sendmail mode'
     * and the header is 'X-Loop: sendpage' then silently
     * exit
     */
    
    if (inHeader && (header[0] || useBody) && (linebuf.len2 == 16)
	&& (!strncasecmp("X-Loop: sendpage", linebuf.buf, 16))) {
      err = 0;
      goto BeAClientout;
    }
    
    /*
     * if in the header portion, and haven't read the header
     * to strip out, and there is a header to strip out defined
     * and this is that header, store the contents in the message
     * buffer
     */
    if (inHeader && (readHeaderLine == 0) && header[0] && 
	(linebuf.len2 > headerLen) && (!strncasecmp(header, linebuf.buf,
						    headerLen))) {
      j=linebuf.buf+linebuf.len2;
      for (p = linebuf.buf + headerLen + 1;
	   p<j && (*p == ' ' || *p == '\t');
	   p++) ;
      
      if (p<j) {
	if (AddMessage(&msg, p, j-p )) {
	  fprintf(stderr, "AddMessage() failed\n");
	  goto BeAClientout;
	}
	
	++headBufUsed; /* got data from header */
      }

      ++readHeaderLine;
      goto skip1;
    }
    
    /* handle RFC822 style folding */
    if (inHeader && (readHeaderLine == 1) && (linebuf.len2) &&
	((linebuf.buf[0] == ' ') || (linebuf.buf[0] == '\t'))) {
      
      p = linebuf.buf;
      j = p+linebuf.len2;
      for (;
	   p<j && (*p == ' ' || *p == '\t');
	   p++) ;
      
      if (p<j) {
	if (AddMessage(&msg, p, j-p )) {
	  fprintf(stderr, "AddMessage() failed\n");
	  goto BeAClientout;
	}
	
      }
      goto skip1;
    }
    
    /* can't possibly be a folded header anymore */
    if (readHeaderLine == 1)
      ++readHeaderLine;
    
    
    /* if the last line was a blank line, and this line begins
     * with - or *, then assume we're in signature and drop to end */
    if ((!inHeader) && dropSig && linebuf.len2 && lastWasBlank &&
	((linebuf.buf[0] == '-') || (linebuf.buf[0] == '*'))) {
      skipToEnd = 1;
      goto skip1;
    }
    
    
    /*
     * add non blank lines if:
     * useBody and header are not defined   or
     * useBody is defined, header is not defined and not in header   or
     * useBody is defined, header is defined, not in header, and didn't
     *  pull any data out of header
     */
    /*
    if (linebuf.len2 && (
			 (!useBody && !header[0]) ||
			 (useBody && !header[0] && !inHeader) ||
			 (useBody && header[0] && !inHeader && !headBufUsed)))
			 */
    /* logic:
       add lines if either, useBody in not in header
       or                   not useBody and not use header (ie, stdin)
       */
    if (linebuf.len2 && (
			 (useBody && !inHeader) ||
			 (!useBody && !header[0])
			 )
	) {
      if (AddMessage(&msg, linebuf.buf, linebuf.len2)) {
	fprintf(stderr, "AddMessage() failed\n");
	goto BeAClientout;
      }
    }
    
skip1:
    /* if we were reading the header, but this line is blank
       we're reading the body now */
    if (inHeader && (!linebuf.len2))
      inHeader = 0;
    
    /* mark line blankness history */
    if (!linebuf.len2)
      lastWasBlank = 1;
    else
      lastWasBlank = 0;
    
    /* exit loop on EOF */
    if (ret == 1)
      break;
    
  } /* while 1 */
  
  
#ifdef DEBUG
  if (debug > 2) {
    fprintf(stderr, "msg: %s\n", msg.buf);
  } /* debug > 2*/
#endif /* DEBUG */
  
  if (!msg.bufused) {
    fprintf(stderr, "Request rejected: No valid messages.\n");
    err = EX_NOINPUT;
    goto BeAClientout;
  }
  
  
  /* Got reciepient(s), got message(s), queue them */
  
  /* sender and len is same for all */
  entry.senderlen = (sender) ? strlen(sender) : 0;
  
  /* for each recipient */
  for (i = 0; i < nrecipients; ++i) {
    
    /* mark for mail reply? */
    entry.flags = (nomail) ? MSGQ_FLAGS_MAIL_NONE : MSGQ_FLAGS_NONE;
    
    /* timestamp it */
    if ((entry.queuetime = time((time_t*)0L)) == ((time_t)-1))
      report (LOG_ERR, "clock is dead!"); 
    
    /* set rest of the lengths */
    entry.recipientlen = strlen(argv[optind + i]);
    entry.messagelen = msg.bufused;
    entry.recipient2len = 0;
    
    /* lower-case the recipient list */
    for (c=argv[optind + i];(*c=tolower(*c));c++)  ;
    
    /* queue it */
    if (AddMessageQueue(&entry, sender, argv[optind + i],
			&nullbyte, msg.buf, &nullbyte, &qfname, 0)) {
      fprintf(stderr, "AddMessageQueue() failed\n");
      goto BeAClientout;
    }
    
    printf("Entry queued for delivery\n");
  } /* for i */
  
  err = EX_OK; /* good */
  
  /* signal the daemon to send now? */
  if (sendnow) {
    
    if ((FP = fopen(PATH_SENDPAGE_PIDFILE, "r"))) {
      fscanf(FP, "%u", &pid);
      fclose(FP);
    }
    
    /* only signal if there were recipients and pid is !0 */
    if (nrecipients && pid) 
      if (kill ((int)pid, SIGUSR1)) 
	fprintf(stderr, "Can't alert daemon pid (%u) to message\n",
		pid);
    
  } /* sendnow */

BeAClientout:
  
  if (msg.buf)
    free (msg.buf);
  
  if (linebuf.buf)
    free (linebuf.buf);
  
  return err;
  
} /* BeAClient */

