#
# Sendmail SMTP Access Control by <gjermund@xyzzy.no> 1997-11-26
# Updated for Sendmail 8.9 <gjermund@xyzzy.no> 1998-10-06
#

LOCAL_CONFIG
Kaccess ifelse(_ARG_, `', `hash -o -a:FOUND /etc/smtp.access', `_ARG_')

LOCAL_RULESETS
SLocal_check_mail

# Run the input address through S3 to add the <> focus and to
# perform a DNS lookup and canonicalization of the domain part.
R $*			$: $>3 $1

ifelse(confAC_DNS_CHECK, `False', `', `
# --------------------- DNS CHECK ----------------------

# Reject one and two token domain names that were not in the DNS.
# (Ruleset 3 looked up the domain and added a trailing dot if it was found).
R $* <@ $~.>		$#error $: 451 Sender domain not in DNS
R $* <@ $- . $~.>	$#error $: 451 Sender domain not in DNS

# For three-or-more token domain names that were not in the DNS, strip
# the first token and look up the resulting name. We accept three-or-more
# token domain names (a.b.c.d) that are not in the DNS if all but the leftmost
# token (b.c.d) is found.
R $* <@ $- . $+ $~. >	$: < $[ $3 $4 $] > $1 <@ $2 . $3 $4>

# But if that name was not in the DNS either, reject the address.
R <$* $~.> $+		$#error $: 451 Sender domain not in DNS

# The domain name was acceptable to us. Remove the front lookup focus.
R < $* > $+ <@ $+>	$: $2 <@ $3>

')

# Make sure all domain names now end with a dot.
R $* <@ $* $~.>		$: $1 <@ $2 $3 .>

# -------------- ACCESS-DATABASE LOOKUP ---------------

# First look up user@domain in the smtp.access database.
# If not found, then look up @domain.
R $+ <@ $+ .>		$: $( access $1@$2 $: $1<@$2.> $)
R $+ <@ $+ .>		$: $( access   @$2 $: $1<@$2.> $)

R permit:FOUND		$@ $#OK
R deny:FOUND		$#error $: "553 Access denied"
R $+:FOUND		$#error $: "553 " $1
R $*			$@ $#OK


SLocal_check_relay
#
# Look up the client IP address in the smtp.access database.
# First a.b.c.d, then a.b.c, then a.b, then a (or until a match was found).
#
R $* $| $+		$: $( access $2 $)
R $+.$-			   $( access $1 $)
R permit:FOUND		$@ $#OK
R $+:FOUND		$#error $: Access denied 
R $*			$@ $#OK
