
# test for code coverage
ADD_TEST(help ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test --help)
ADD_TEST(help-models ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test --help-models)

# teshsuite/xbt
ADD_TEST(memcheck-tesh-log-large-0 ${CMAKE_BINARY_DIR}/teshsuite/xbt/log_large_test "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-log-large-1 ${CMAKE_BINARY_DIR}/teshsuite/xbt/log_large_test "--log=root.fmt:%m%n"  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-log-parallel-0 ${CMAKE_BINARY_DIR}/teshsuite/xbt/parallel_log_crashtest "--log=root.fmt:%m%n"  --cd ${CMAKE_BINARY_DIR}/teshsuite/)

# teshsuite/gras/datadesc directory
ADD_TEST(memcheck-tesh-gras-dd-mem-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc_usage --copy "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-gras-dd-rw-0 rm -f datadesc_usage.out --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-gras-dd-rw-1 ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc_usage --write "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-gras-dd-rw-2 ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc_usage --read "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-gras-dd-r-little32-4-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc_usage --read ${CMAKE_HOME_DIRECTORY}/teshsuite/gras/datadesc/datadesc.little32_4  --log=test.thres:verbose --log=structs.thres:info "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-gras-dd-r-little64-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc_usage --read ${CMAKE_HOME_DIRECTORY}/teshsuite/gras/datadesc/datadesc.little64  --log=test.thres:verbose --log=structs.thres:info "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-gras-dd-r-big32-8-4-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc_usage --read ${CMAKE_HOME_DIRECTORY}/teshsuite/gras/datadesc/datadesc.big32_8_4 --log=test.thres:verbose --log=structs.thres:info "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)

IF(${ARCH_32_BITS})
ADD_TEST(memcheck-tesh-gras-msg-handle-sg-32-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/msg_handle/msg_handle_simulator ${CMAKE_HOME_DIRECTORY}/teshsuite/../examples/msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/teshsuite/gras/msg_handle/msg_handle.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ELSE(${ARCH_32_BITS})
ADD_TEST(memcheck-tesh-gras-msg-handle-sg-64-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/msg_handle/msg_handle_simulator ${CMAKE_HOME_DIRECTORY}/teshsuite/../examples/msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/teshsuite/gras/msg_handle/msg_handle.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ENDIF(${ARCH_32_BITS})

ADD_TEST(memcheck-tesh-gras-empty-main-sg-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/empty_main/empty_main_simulator ./../examples/msg/small_platform.xml ./gras/empty_main/empty_main.xml --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/)

IF(${ARCH_32_BITS})
ADD_TEST(memcheck-tesh-gras-small-sleep-sg-32-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/small_sleep/small_sleep_simulator ./../examples/msg/small_platform.xml ./gras/small_sleep/small_sleep.xml --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/)
ELSE(${ARCH_32_BITS})
ADD_TEST(memcheck-tesh-gras-small-sleep-sg-64-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/small_sleep/small_sleep_simulator ./../examples/msg/small_platform.xml ./gras/small_sleep/small_sleep.xml --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/)
ENDIF(${ARCH_32_BITS})

# GRAS examples
ADD_TEST(memcheck-gras-spawn-rl-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_server --log=root.fmt=%m%n --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-timer-rl-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_client --log=root.fmt:%m%n --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-chrono-rl-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_multiplier --log=root.fmt:%m%n   --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-synchro-rl-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_philosopher 4 --log=root.fmt=%m%n --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
ADD_TEST(memcheck-gras-properties-rl-0 ${CMAKE_BINARY_DIR}/examples/gras/properties/properties_alice --log=root.fmt=%P:%t%e%m%n --cd ${CMAKE_BINARY_DIR}/examples/gras/properties/)
ADD_TEST(memcheck-gras-properties-rl-1 ${CMAKE_BINARY_DIR}/examples/gras/properties/properties_bob --log=root.fmt=%P:%t%e%m%n --cd ${CMAKE_BINARY_DIR}/examples/gras/properties/)

# BEGIN CONTEXTS FACTORY
ADD_TEST(memcheck-tesh-msg-get-sender-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/msg/get_sender ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/get_sender.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
if(HAVE_RAWCTX)
ADD_TEST(memcheck-tesh-msg-get-sender-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/msg/get_sender ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/get_sender.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
endif(HAVE_RAWCTX)
if(CONTEXT_UCONTEXT)
ADD_TEST(memcheck-tesh-msg-get-sender-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/msg/get_sender ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/get_sender.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
endif(CONTEXT_UCONTEXT)

IF(enable_debug) # these tests need the assertion mechanism
ADD_TEST(memcheck-tesh-simdag-parser-bogus-symmetric-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_asymetric_BOGUS.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-bogus-symmetric-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_asymetric_BOGUS2.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ENDIF(enable_debug)

ADD_TEST(memcheck-tesh-simdag-bypass-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ${CMAKE_HOME_DIRECTORY}/examples/platforms/bypassASroute.xml FULL_LINK --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-bypass-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ${CMAKE_HOME_DIRECTORY}/examples/platforms/bypassRoute.xml FULL_LINK --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_cluster.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_availability.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_properties.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_state_file.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_state_off.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-5 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_state_on.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-6 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_trace_file.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-7 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_trace_inside.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-8 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-9 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_availability.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-10 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_fatpipe.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-11 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_shared.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-12 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_state_file.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-13 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier three_hosts_non_symmetric_route.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-14 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_clusters.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-15 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_multi_hop.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-16 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_one_link.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-17 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier ${CMAKE_HOME_DIRECTORY}/examples/platforms/bypassASroute.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)

ADD_TEST(memcheck-tesh-simdag-reinit-costs-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/test_reinit_costs ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-parser-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_cluster.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_availability.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_properties.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_state_file.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_state_off.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-5 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_state_on.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-6 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_trace_file.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-7 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_trace_inside.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-8 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-9 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_availability.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-10 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_fatpipe.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-11 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_shared.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-12 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_state_file.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-13 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test three_hosts_non_symmetric_route.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-14 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_clusters.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-15 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_multi_hop.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-16 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_one_link.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-17 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd.xml --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-18 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd_bis.xml --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-19 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./properties.xml --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-20 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./properties.xml --cfg=cpu/optim:TI --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-21 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./one_cluster_file.xml --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-22 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/is_router_test ./test_of_is_router.xml --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-23 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./Two_clusters_rulebased.xml ONE_LINK --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_cluster_fullduplex.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_clusters_symmetric.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_one_link_symmetrical.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_one_link_fullduplex.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test Dijkstra.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-full-links-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd.xml FULL_LINK --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-full-links-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd_bis.xml FULL_LINK --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-basic0-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic0 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic1-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic1 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic2-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic2 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic3-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic3 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic4-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic4 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic5-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic5 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic6-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic6 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-1-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency1 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-1-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency1 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/p2p/platform_2p_1fl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-1-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency1 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/p2p/platform_2p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-2-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency2 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-2-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency2 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/p2p/platform_2p_1fl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-2-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency2 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/p2p/platform_2p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-3-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency3 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-3-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency3 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/p2p/platform_2p_1fl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-3-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency3 ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/p2p/platform_2p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-4-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency_bound ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/p2p/platform_2p_1bb.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-mxn-1-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/test_intra_all2all ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/mxn/platform_4p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-mxn-2-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/test_intra_independent_comm ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/mxn/platform_4p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-mxn-3-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/test_intra_scatter ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/network/mxn/platform_4p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-par-1-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/test_comp_only_seq ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/partask/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-par-2-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/test_comp_only_par ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/partask/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-par-2-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/test_comp_only_par ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/partask/platform_2p_1sl_hetero.xml --surf-path=${CMAKE_HOME_DIRECTORY}/teshsuite --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)

# MSG examples
ADD_TEST(memcheck-msg-file-0 ${CMAKE_BINARY_DIR}/examples/msg//io/file ${CMAKE_HOME_DIRECTORY}//examples/platforms/storage.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/examples//)
ADD_TEST(memcheck-msg-start-kill-time-0 ${CMAKE_BINARY_DIR}/examples/msg//start_kill_time/sk_time ${CMAKE_HOME_DIRECTORY}//examples/platforms/cluster.xml ${CMAKE_HOME_DIRECTORY}//examples/msg/start_kill_time/deployment.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/examples//)
ADD_TEST(memcheck-msg-start-kill-time-1 ${CMAKE_BINARY_DIR}/examples/msg//start_kill_time/sk_time ${CMAKE_HOME_DIRECTORY}//examples/platforms/cluster.xml ${CMAKE_HOME_DIRECTORY}//examples/msg/start_kill_time/deployment_start.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/examples//)
ADD_TEST(memcheck-msg-start-kill-time-2 ${CMAKE_BINARY_DIR}/examples/msg//start_kill_time/sk_time ${CMAKE_HOME_DIRECTORY}//examples/platforms/cluster.xml ${CMAKE_HOME_DIRECTORY}//examples/msg/start_kill_time/deployment_kill.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/examples//)
ADD_TEST(memcheck-msg-start-kill-time-3 ${CMAKE_BINARY_DIR}/examples/msg//start_kill_time/sk_time ${CMAKE_HOME_DIRECTORY}//examples/platforms/cluster.xml ${CMAKE_HOME_DIRECTORY}//examples/msg/start_kill_time/deployment_start_kill.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/examples//)

ADD_TEST(memcheck-msg-sendrecv-CLM03-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/deployment_sendrecv.xml --cfg=cpu/model:Cas01 --cfg=network/model:CM02 "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-Vegas-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/deployment_sendrecv.xml "--cfg=workstation/model:compound cpu/model:Cas01 network/model:Vegas" "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-Reno-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/deployment_sendrecv.xml "--cfg=workstation/model:compound cpu/model:Cas01 network/model:Reno" --log=surf_lagrange.thres=critical "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-suspend-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/suspend/suspend ${CMAKE_HOME_DIRECTORY}/examples/msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/suspend/deployment_suspend.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-bypass-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_bypass --log=no_loc  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-kill-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_kill ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/platform_kill.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_kill.xml --log=surf_maxmin.thres:error --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-multicore-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_HOME_DIRECTORY}/examples/msg/../platforms/multicore_machine.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_mailbox_multicore.xml --cfg=cpu/model:Cas01 --cfg=cpu/optim:Full --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)

ADD_TEST(memcheck-msg-masterslave-no-crosstraffic-mailbox-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_routers.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_mailbox.xml --cfg=network/crosstraffic:0 --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-no-crosstraffic-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_routers.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave.xml --cfg=network/crosstraffic:0 --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-no-crosstraffic-forwarder-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_HOME_DIRECTORY}/examples/msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_forwarder.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-no-crosstraffic-failure-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_failures.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave.xml --cfg=path:${CMAKE_HOME_DIRECTORY}/examples/msg --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)

ADD_TEST(memcheck-msg-masterslave-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_routers.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave.xml --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-forwarder-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_HOME_DIRECTORY}/examples/msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_forwarder.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-failure-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_failures.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave.xml --cfg=path:${CMAKE_HOME_DIRECTORY}/examples/msg "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-mailbox-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_routers.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_mailbox.xml --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder small_platform.xml masterslave/deployment_masterslave.xml --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder msg_platform.xml masterslave/deployment_masterslave_forwarder.xml --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-thread-2 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc small_platform_with_failures.xml masterslave/deployment_masterslave.xml --cfg=path: --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-thread-3 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_bypass --log=no_loc --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)

if(CONTEXT_UCONTEXT)
ADD_TEST(memcheck-msg-sendrecv-CLM03-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/deployment_sendrecv.xml --cfg=cpu/model:Cas01 --cfg=network/model:CM02 "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-Vegas-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/deployment_sendrecv.xml "--cfg=workstation/model:compound cpu/model:Cas01 network/model:Vegas" "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-Reno-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/deployment_sendrecv.xml "--cfg=workstation/model:compound cpu/model:Cas01 network/model:Reno" --log=surf_lagrange.thres=critical "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-suspend-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/suspend/suspend ${CMAKE_HOME_DIRECTORY}/examples/msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/suspend/deployment_suspend.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-bypass-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_bypass --log=no_loc  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-kill-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_kill ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/platform_kill.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_kill.xml --log=surf_maxmin.thres:error --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-multicore-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_HOME_DIRECTORY}/examples/msg/../platforms/multicore_machine.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_mailbox_multicore.xml --cfg=cpu/model:Cas01 --cfg=cpu/optim:Full --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-no-crosstraffic-mailbox-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_routers.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_mailbox.xml --cfg=network/crosstraffic:0 --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-no-crosstraffic-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_routers.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave.xml --cfg=network/crosstraffic:0 --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-no-crosstraffic-forwarder-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_HOME_DIRECTORY}/examples/msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_forwarder.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-no-crosstraffic-failure-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_failures.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave.xml --cfg=path:${CMAKE_HOME_DIRECTORY}/examples/msg --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
    
ADD_TEST(memcheck-msg-masterslave-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_routers.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave.xml --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-forwarder-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_HOME_DIRECTORY}/examples/msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_forwarder.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-failure-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_failures.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave.xml --cfg=path:${CMAKE_HOME_DIRECTORY}/examples/msg "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-mailbox-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_routers.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_mailbox.xml --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder small_platform.xml masterslave/deployment_masterslave.xml --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder msg_platform.xml masterslave/deployment_masterslave_forwarder.xml --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-ucontext-2 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc small_platform_with_failures.xml masterslave/deployment_masterslave.xml --cfg=path: --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-ucontext-3 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_bypass --log=no_loc --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
endif(CONTEXT_UCONTEXT)

if(HAVE_RAWCTX)
ADD_TEST(memcheck-msg-sendrecv-CLM03-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/deployment_sendrecv.xml --cfg=cpu/model:Cas01 --cfg=network/model:CM02 "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-Vegas-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/deployment_sendrecv.xml "--cfg=workstation/model:compound cpu/model:Cas01 network/model:Vegas" "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-Reno-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/sendrecv/deployment_sendrecv.xml "--cfg=workstation/model:compound cpu/model:Cas01 network/model:Reno" --log=surf_lagrange.thres=critical "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-suspend-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/suspend/suspend ${CMAKE_HOME_DIRECTORY}/examples/msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/suspend/deployment_suspend.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-bypass-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_bypass --log=no_loc  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-kill-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_kill ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/platform_kill.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_kill.xml --log=surf_maxmin.thres:error --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-multicore-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_HOME_DIRECTORY}/examples/msg/../platforms/multicore_machine.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_mailbox_multicore.xml --cfg=cpu/model:Cas01 --cfg=cpu/optim:Full --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-no-crosstraffic-mailbox-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_routers.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_mailbox.xml --cfg=network/crosstraffic:0 --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-no-crosstraffic-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_routers.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave.xml --cfg=network/crosstraffic:0 --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-no-crosstraffic-forwarder-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_HOME_DIRECTORY}/examples/msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_forwarder.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-no-crosstraffic-failure-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_failures.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave.xml --cfg=path:${CMAKE_HOME_DIRECTORY}/examples/msg --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
    
ADD_TEST(memcheck-msg-masterslave-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_routers.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave.xml --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-forwarder-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_HOME_DIRECTORY}/examples/msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_forwarder.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-failure-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_failures.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave.xml --cfg=path:${CMAKE_HOME_DIRECTORY}/examples/msg "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-mailbox-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform_with_routers.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_mailbox.xml --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder small_platform.xml masterslave/deployment_masterslave.xml --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder msg_platform.xml masterslave/deployment_masterslave_forwarder.xml --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-raw-2 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc small_platform_with_failures.xml masterslave/deployment_masterslave.xml --cfg=path: --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-raw-3 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_bypass --log=no_loc --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
endif(HAVE_RAWCTX)

ADD_TEST(memcheck-msg-masterslave-vivaldi-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox  ${CMAKE_HOME_DIRECTORY}/examples/msg/../platforms/vivaldi.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_vivaldi.xml --cfg=network/latency_factor:1.0 --cfg=network/bandwidth_factor:1.0 --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-token-ring-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/token_ring/token_ring ${CMAKE_HOME_DIRECTORY}/examples/msg/token_ring/two_clusters.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/token_ring/)
ADD_TEST(memcheck-msg-token-ring-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/token_ring/token_ring ${CMAKE_HOME_DIRECTORY}/examples/msg/token_ring/two_peers.xml --cfg=network/coordinates:yes "--log=root.fmt:[%12.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/token_ring/)
if(HAVE_RAWCTX)
ADD_TEST(memcheck-msg-masterslave-vivaldi-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox  ${CMAKE_HOME_DIRECTORY}/examples/msg/../platforms/vivaldi.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_vivaldi.xml --cfg=network/latency_factor:1.0 --cfg=network/bandwidth_factor:1.0 --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-token-ring-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/token_ring/token_ring ${CMAKE_HOME_DIRECTORY}/examples/msg/token_ring/two_clusters.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/token_ring/)
ADD_TEST(memcheck-msg-token-ring-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/token_ring/token_ring ${CMAKE_HOME_DIRECTORY}/examples/msg/token_ring/two_peers.xml --cfg=network/coordinates:yes "--log=root.fmt:[%12.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/token_ring/)
endif(HAVE_RAWCTX)
if(CONTEXT_UCONTEXT)
ADD_TEST(memcheck-msg-masterslave-vivaldi-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox  ${CMAKE_HOME_DIRECTORY}/examples/msg/../platforms/vivaldi.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/deployment_masterslave_vivaldi.xml --cfg=network/latency_factor:1.0 --cfg=network/bandwidth_factor:1.0 --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-token-ring-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/token_ring/token_ring ${CMAKE_HOME_DIRECTORY}/examples/msg/token_ring/two_clusters.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/token_ring/)
ADD_TEST(memcheck-msg-token-ring-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/token_ring/token_ring ${CMAKE_HOME_DIRECTORY}/examples/msg/token_ring/two_peers.xml --cfg=network/coordinates:yes "--log=root.fmt:[%12.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/token_ring/)
endif(CONTEXT_UCONTEXT)

ADD_TEST(memcheck-msg-migration-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/migration/migration ${CMAKE_HOME_DIRECTORY}/examples/msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/migration/migration.deploy  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ptask-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/parallel_task ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ptask-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/test_ptask ${CMAKE_HOME_DIRECTORY}/examples/msg/parallel_task/test_ptask_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/parallel_task/test_ptask_deployment.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-priority-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/priority/priority ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform.xml  ${CMAKE_HOME_DIRECTORY}/examples/msg/priority/deployment_priority.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-properties-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/properties/msg_prop ${CMAKE_HOME_DIRECTORY}/examples/msg/../platforms/prop.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/properties/deployment_properties.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-icomms-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer01.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer02.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-thread-2 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer03.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-thread-3 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer04.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-thread-4 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer2 ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-actions-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment_split.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_allReduce.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-thread-2 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_barrier.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-thread-3 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_bcast.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-thread-4 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_reduce.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-thread-5 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_with_isend.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-trace-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test1.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-thread-1 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test2.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-thread-2 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test3.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-thread-3 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test4.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-thread-4 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test5.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-thread-5 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test6.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-thread-6 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test7.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-thread-7 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test8.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-thread-8 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test9.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-thread-9 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test10.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-thread-10 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test11.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-chord-no-crosstraffic-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord -nb_bits=6 ./../msg_platform.xml ./chord.xml --cfg=network/crosstraffic:0 --log=msg_chord.thres:verbose "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-no-crosstraffic-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord ./../../platforms/cluster.xml ./chord10.xml --cfg=network/crosstraffic:0 --log=msg_chord.thres:verbose "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cfg=network/model:Constant --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-no-crosstraffic-thread-parallel-0 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord -nb_bits=6 ./../msg_platform.xml ./chord.xml --cfg=network/crosstraffic:0 --log=msg_chord.thres:verbose "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/nthreads:4 --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-no-crosstraffic-thread-parallel-1 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord ./../../platforms/cluster.xml ./chord10.xml --cfg=network/crosstraffic:0 --log=msg_chord.thres:verbose "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cfg=network/model:Constant --cfg=contexts/nthreads:4 --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord -nb_bits=6 ./../msg_platform.xml ./chord.xml --log=msg_chord.thres:verbose "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord ./../../platforms/cluster.xml ./chord10.xml --log=msg_chord.thres:verbose "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cfg=network/model:Constant --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-thread-parallel-0 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord -nb_bits=6 ./../msg_platform.xml ./chord.xml --log=msg_chord.thres:verbose "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/nthreads:4 --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-thread-parallel-1 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord ./../../platforms/cluster.xml ./chord10.xml --log=msg_chord.thres:verbose "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cfg=network/model:Constant --cfg=contexts/nthreads:4 --cfg=contexts/factory:thread  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
if(CONTEXT_UCONTEXT)
ADD_TEST(memcheck-msg-migration-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/migration/migration ${CMAKE_HOME_DIRECTORY}/examples/msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/migration/migration.deploy  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ptask-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/parallel_task ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ptask-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/test_ptask ${CMAKE_HOME_DIRECTORY}/examples/msg/parallel_task/test_ptask_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/parallel_task/test_ptask_deployment.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-priority-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/priority/priority ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform.xml  ${CMAKE_HOME_DIRECTORY}/examples/msg/priority/deployment_priority.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-properties-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/properties/msg_prop ${CMAKE_HOME_DIRECTORY}/examples/msg/../platforms/prop.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/properties/deployment_properties.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-icomms-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer01.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer02.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-ucontext-2 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer03.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-ucontext-3 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer04.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-ucontext-4 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer2 ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-actions-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment_split.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_allReduce.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-ucontext-2 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_barrier.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-ucontext-3 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_bcast.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-ucontext-4 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_reduce.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-ucontext-5 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_with_isend.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-trace-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test1.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-1 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test2.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-2 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test3.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-3 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test4.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-4 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test5.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-5 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test6.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-6 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test7.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-7 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test8.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-8 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test9.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-9 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test10.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-10 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test11.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-chord-no-crosstraffic-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord -nb_bits=6 ./../msg_platform.xml ./chord.xml --cfg=network/crosstraffic:0 --log=msg_chord.thres:verbose "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-no-crosstraffic-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord ./../../platforms/cluster.xml ./chord10.xml --cfg=network/crosstraffic:0 --log=msg_chord.thres:verbose "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cfg=network/model:Constant --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-no-crosstraffic-ucontext-parallel-0 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord -nb_bits=6 ./../msg_platform.xml ./chord.xml --cfg=network/crosstraffic:0 --log=msg_chord.thres:verbose "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/nthreads:4 --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-no-crosstraffic-ucontext-parallel-1 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord ./../../platforms/cluster.xml ./chord10.xml --cfg=network/crosstraffic:0 --log=msg_chord.thres:verbose "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cfg=network/model:Constant --cfg=contexts/nthreads:4 --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord -nb_bits=6 ./../msg_platform.xml ./chord.xml --log=msg_chord.thres:verbose "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord ./../../platforms/cluster.xml ./chord10.xml --log=msg_chord.thres:verbose "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cfg=network/model:Constant --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-ucontext-parallel-0 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord -nb_bits=6 ./../msg_platform.xml ./chord.xml --log=msg_chord.thres:verbose "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/nthreads:4 --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-ucontext-parallel-1 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord ./../../platforms/cluster.xml ./chord10.xml --log=msg_chord.thres:verbose "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cfg=network/model:Constant --cfg=contexts/nthreads:4 --cfg=contexts/factory:ucontext  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
endif(CONTEXT_UCONTEXT)
if(HAVE_RAWCTX)
ADD_TEST(memcheck-msg-migration-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/migration/migration ${CMAKE_HOME_DIRECTORY}/examples/msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/migration/migration.deploy  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ptask-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/parallel_task ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ptask-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/test_ptask ${CMAKE_HOME_DIRECTORY}/examples/msg/parallel_task/test_ptask_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/parallel_task/test_ptask_deployment.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-priority-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/priority/priority ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform.xml  ${CMAKE_HOME_DIRECTORY}/examples/msg/priority/deployment_priority.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-actions-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment_split.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_allReduce.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-raw-2 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_barrier.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-raw-3 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_bcast.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-raw-4 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_reduce.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-raw-5 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_with_isend.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/actions/)
ADD_TEST(memcheck-msg-icomms-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer01.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer02.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-raw-2 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer03.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-raw-3 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer04.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-raw-4 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer2 ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-properties-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/properties/msg_prop ${CMAKE_HOME_DIRECTORY}/examples/msg/../platforms/prop.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/properties/deployment_properties.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-trace-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test1.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-raw-1 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test2.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-raw-2 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test3.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-raw-3 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test4.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-raw-4 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test5.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-raw-5 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test6.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-raw-6 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test7.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-raw-7 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test8.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-raw-8 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test9.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-raw-9 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test10.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-trace-raw-10 ${CMAKE_BINARY_DIR}/teshsuite/msg/trace/test_trace_integration ./trace/test11.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/optim:TI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/teshsuite/msg/)
ADD_TEST(memcheck-msg-chord-no-crosstraffic-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord -nb_bits=6 ./../msg_platform.xml ./chord.xml --cfg=network/crosstraffic:0 --log=msg_chord.thres:verbose "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-no-crosstraffic-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord ./../../platforms/cluster.xml ./chord10.xml --cfg=network/crosstraffic:0 --log=msg_chord.thres:verbose "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cfg=network/model:Constant --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-no-crosstraffic-raw-parallel-0 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord -nb_bits=6 ./../msg_platform.xml ./chord.xml --cfg=network/crosstraffic:0 --log=msg_chord.thres:verbose "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/nthreads:4 --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-no-crosstraffic-raw-parallel-1 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord ./../../platforms/cluster.xml ./chord10.xml --cfg=network/crosstraffic:0 --log=msg_chord.thres:verbose "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cfg=network/model:Constant --cfg=contexts/nthreads:4 --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord -nb_bits=6 ./../msg_platform.xml ./chord.xml --log=msg_chord.thres:verbose "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord ./../../platforms/cluster.xml ./chord10.xml --log=msg_chord.thres:verbose "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cfg=network/model:Constant --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-raw-parallel-0 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord -nb_bits=6 ./../msg_platform.xml ./chord.xml --log=msg_chord.thres:verbose "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/nthreads:4 --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
ADD_TEST(memcheck-msg-chord-raw-parallel-1 ${CMAKE_BINARY_DIR}/examples/msg/chord/chord ./../../platforms/cluster.xml ./chord10.xml --log=msg_chord.thres:verbose "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cfg=network/model:Constant --cfg=contexts/nthreads:4 --cfg=contexts/factory:raw  --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/chord/)
endif(HAVE_RAWCTX)

IF(${ARCH_32_BITS})
ADD_TEST(memcheck-gras-ping-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/ping/ping_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/ping/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/ping/ping.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/ping/)
ADD_TEST(memcheck-gras-rpc-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc/rpc.xml "--log=root.fmt:[0]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/rpc/)
ADD_TEST(memcheck-gras-spawn-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn/spawn.xml --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-timer-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/timer/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/timer/timer.xml --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-chrono-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono/chrono.xml --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-simple-token-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token/../../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token/simple_token.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/)
ADD_TEST(memcheck-gras-mmrpc-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc/mmrpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/)
ADD_TEST(memcheck-gras-all2all-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all/all2all.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%.2i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/all2all/)
ADD_TEST(memcheck-gras-pmm-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm/../../msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm/pmm.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%2i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/pmm/)
ADD_TEST(memcheck-gras-synchro-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro/synchro.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
if(CONTEXT_UCONTEXT)
ADD_TEST(memcheck-gras-ping-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/ping/ping_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/ping/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/ping/ping.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/ping/)
ADD_TEST(memcheck-gras-rpc-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc/rpc.xml "--log=root.fmt:[0]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/rpc/)
ADD_TEST(memcheck-gras-spawn-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn/spawn.xml --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-timer-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/timer/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/timer/timer.xml --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-chrono-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono/chrono.xml --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-simple-token-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token/../../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token/simple_token.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/)
ADD_TEST(memcheck-gras-mmrpc-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc/mmrpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/)
ADD_TEST(memcheck-gras-all2all-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all/all2all.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%.2i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/all2all/)
ADD_TEST(memcheck-gras-pmm-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm/../../msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm/pmm.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%2i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/pmm/)
ADD_TEST(memcheck-gras-synchro-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro/synchro.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
endif(CONTEXT_UCONTEXT)
if(HAVE_RAWCTX)
ADD_TEST(memcheck-gras-ping-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/ping/ping_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/ping/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/ping/ping.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/ping/)
ADD_TEST(memcheck-gras-rpc-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc/rpc.xml "--log=root.fmt:[0]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/rpc/)
ADD_TEST(memcheck-gras-spawn-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn/spawn.xml --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-timer-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/timer/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/timer/timer.xml --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-chrono-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono/chrono.xml --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-simple-token-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token/../../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token/simple_token.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/)
ADD_TEST(memcheck-gras-mmrpc-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc/mmrpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/)
ADD_TEST(memcheck-gras-all2all-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all/all2all.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%.2i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/all2all/)
ADD_TEST(memcheck-gras-pmm-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm/../../msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm/pmm.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%2i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/pmm/)
ADD_TEST(memcheck-gras-synchro-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro/synchro.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
endif(HAVE_RAWCTX)

ELSE(${ARCH_32_BITS})
ADD_TEST(memcheck-gras-ping-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/ping/ping_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/ping/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/ping/ping.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/ping/)
ADD_TEST(memcheck-gras-rpc-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc/rpc.xml "--log=root.fmt:[0]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/rpc/)
ADD_TEST(memcheck-gras-spawn-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn/spawn.xml --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-timer-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/timer/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/timer/timer.xml --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-chrono-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono/chrono.xml --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-simple-token-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token/../../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token/simple_token.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/)
ADD_TEST(memcheck-gras-mmrpc-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc/mmrpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/)
ADD_TEST(memcheck-gras-all2all-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all/all2all.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%.2i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/all2all/)
ADD_TEST(memcheck-gras-pmm-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm/../../msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm/pmm.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%2i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/pmm/)
ADD_TEST(memcheck-gras-synchro-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro/synchro.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
if(CONTEXT_UCONTEXT)
ADD_TEST(memcheck-gras-ping-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/ping/ping_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/ping/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/ping/ping.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/ping/)
ADD_TEST(memcheck-gras-rpc-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc/rpc.xml "--log=root.fmt:[0]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/rpc/)
ADD_TEST(memcheck-gras-spawn-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn/spawn.xml --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-timer-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/timer/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/timer/timer.xml --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-chrono-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono/chrono.xml --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-simple-token-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token/../../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token/simple_token.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/)
ADD_TEST(memcheck-gras-mmrpc-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc/mmrpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/)
ADD_TEST(memcheck-gras-all2all-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all/all2all.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%.2i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/all2all/)
ADD_TEST(memcheck-gras-pmm-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm/../../msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm/pmm.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%2i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/pmm/)
ADD_TEST(memcheck-gras-synchro-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro/synchro.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
endif(CONTEXT_UCONTEXT)
if(HAVE_RAWCTX)
ADD_TEST(memcheck-gras-ping-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/ping/ping_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/ping/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/ping/ping.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/ping/)
ADD_TEST(memcheck-gras-rpc-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc/rpc.xml "--log=root.fmt:[0]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/rpc/)
ADD_TEST(memcheck-gras-spawn-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn/spawn.xml --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-timer-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/timer/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/timer/timer.xml --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-chrono-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono/chrono.xml --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-simple-token-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token/../../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token/simple_token.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/)
ADD_TEST(memcheck-gras-mmrpc-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc/mmrpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/)
ADD_TEST(memcheck-gras-all2all-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all/all2all.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%.2i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/all2all/)
ADD_TEST(memcheck-gras-pmm-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm/../../msg/msg_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm/pmm.xml --cfg=network/crosstraffic:0 "--log=root.fmt:[%10.6r]%e(%2i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/pmm/)
ADD_TEST(memcheck-gras-synchro-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro/../../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro/synchro.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
endif(HAVE_RAWCTX)

ENDIF(${ARCH_32_BITS})
ADD_TEST(memcheck-gras-properties-sg-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/properties/properties_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/properties/../../platforms/prop.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/properties/properties.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/properties/)
if(CONTEXT_UCONTEXT)
ADD_TEST(memcheck-gras-properties-sg-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/properties/properties_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/properties/../../platforms/prop.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/properties/properties.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/properties/)
endif(CONTEXT_UCONTEXT)
if(HAVE_RAWCTX)
ADD_TEST(memcheck-gras-properties-sg-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/properties/properties_simulator ${CMAKE_HOME_DIRECTORY}/examples/gras/properties/../../platforms/prop.xml ${CMAKE_HOME_DIRECTORY}/examples/gras/properties/properties.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/properties/)
endif(HAVE_RAWCTX)

# amok examples

IF(${ARCH_32_BITS})
ADD_TEST(memcheck-amok-bandwidth-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth_simulator ${CMAKE_HOME_DIRECTORY}/examples/amok/../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/amok/bandwidth/bandwidth.xml --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-saturate-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate_simulator ${CMAKE_HOME_DIRECTORY}/examples/amok/../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/amok/saturate/saturate.xml --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
  if(HAVE_RAWCTX)
ADD_TEST(memcheck-amok-bandwidth-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth_simulator ${CMAKE_HOME_DIRECTORY}/examples/amok/../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/amok/bandwidth/bandwidth.xml --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-saturate-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate_simulator ${CMAKE_HOME_DIRECTORY}/examples/amok/../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/amok/saturate/saturate.xml --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
  endif(HAVE_RAWCTX)
  if(CONTEXT_UCONTEXT)
ADD_TEST(memcheck-amok-bandwidth-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth_simulator ${CMAKE_HOME_DIRECTORY}/examples/amok/../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/amok/bandwidth/bandwidth.xml --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-saturate-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate_simulator ${CMAKE_HOME_DIRECTORY}/examples/amok/../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/amok/saturate/saturate.xml --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
  endif(CONTEXT_UCONTEXT)
ELSE(${ARCH_32_BITS})
ADD_TEST(memcheck-amok-bandwidth-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth_simulator ${CMAKE_HOME_DIRECTORY}/examples/amok/../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/amok/bandwidth/bandwidth.xml --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-saturate-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate_simulator ${CMAKE_HOME_DIRECTORY}/examples/amok/../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/amok/saturate/saturate.xml --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
  if(HAVE_RAWCTX)
ADD_TEST(memcheck-amok-bandwidth-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth_simulator ${CMAKE_HOME_DIRECTORY}/examples/amok/../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/amok/bandwidth/bandwidth.xml --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-saturate-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate_simulator ${CMAKE_HOME_DIRECTORY}/examples/amok/../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/amok/saturate/saturate.xml --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
  endif(HAVE_RAWCTX)
  if(CONTEXT_UCONTEXT)
ADD_TEST(memcheck-amok-saturate-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate_simulator ${CMAKE_HOME_DIRECTORY}/examples/amok/../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/amok/saturate/saturate.xml --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-bandwidth-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth_simulator ${CMAKE_HOME_DIRECTORY}/examples/amok/../msg/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/amok/bandwidth/bandwidth.xml --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
  endif(CONTEXT_UCONTEXT)
ENDIF(${ARCH_32_BITS})

# simdag examples
ADD_TEST(memcheck-simdag-test-simdag-0 ${CMAKE_BINARY_DIR}/examples/simdag/sd_test ${CMAKE_HOME_DIRECTORY}/examples/simdag/../msg/msg_platform.xml --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-simdag2-0 ${CMAKE_BINARY_DIR}/examples/simdag/sd_test2 ${CMAKE_HOME_DIRECTORY}/examples/simdag/2clusters.xml --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-simdag-seq-access-0 ${CMAKE_BINARY_DIR}/examples/simdag/sd_seq_access ${CMAKE_HOME_DIRECTORY}/examples/simdag/2clusters.xml --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-prop-0 ${CMAKE_BINARY_DIR}/examples/simdag/properties/sd_prop ${CMAKE_HOME_DIRECTORY}/examples/simdag/../platforms/prop.xml --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-minmin-test-0 ${CMAKE_BINARY_DIR}/examples/simdag/scheduling/minmin_test --log=sd_daxparse.thresh:critical ./simulacrum_7_hosts.xml ./Montage_25.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/simdag/scheduling/)
ADD_TEST(memcheck-simdag-minmin-test-1 cmake -E remove -f ./Montage_25.jed --cd ${CMAKE_HOME_DIRECTORY}/examples/simdag/scheduling/)

ADD_TEST(memcheck-msg-gtnets-crosstraffic-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/crosstraffic-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/crosstraffic-d.xml --cfg=network/crosstraffic:0 --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-crosstraffic-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/crosstraffic-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/crosstraffic-d.xml --cfg=network/crosstraffic:1 --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
if(CONTEXT_UCONTEXT)
ADD_TEST(memcheck-msg-gtnets-crosstraffic-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/crosstraffic-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/crosstraffic-d.xml --cfg=network/crosstraffic:0 --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-crosstraffic-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/crosstraffic-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/crosstraffic-d.xml --cfg=network/crosstraffic:1 --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
endif(CONTEXT_UCONTEXT)
if(HAVE_RAWCTX)
ADD_TEST(memcheck-msg-gtnets-crosstraffic-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/crosstraffic-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/crosstraffic-d.xml --cfg=network/crosstraffic:0 --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-crosstraffic-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/crosstraffic-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/crosstraffic-d.xml --cfg=network/crosstraffic:1 --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
endif(HAVE_RAWCTX)

if(HAVE_GTNETS)
ADD_TEST(memcheck-msg-gtnets-waxman-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/waxman-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/waxman-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-dogbone-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-onelink-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-dogbone-lv08-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:LV08 --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-onelink-lv08-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01  --cfg=network/model:LV08 2>&1 | grep --color=auto -v root/INFO | grep -v simix_network/INFO --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
if(CONTEXT_UCONTEXT)
ADD_TEST(memcheck-msg-gtnets-waxman-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/waxman-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/waxman-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-dogbone-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-onelink-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-dogbone-lv08-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:LV08 --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-onelink-lv08-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01  --cfg=network/model:LV08 2>&1 | grep --color=auto -v root/INFO | grep -v simix_network/INFO --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
endif(CONTEXT_UCONTEXT)
if(HAVE_RAWCTX)
ADD_TEST(memcheck-msg-gtnets-waxman-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/waxman-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/waxman-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-dogbone-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-onelink-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-dogbone-lv08-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:LV08 --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-onelink-lv08-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01  --cfg=network/model:LV08 2>&1 | grep --color=auto -v root/INFO | grep -v simix_network/INFO --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
endif(HAVE_RAWCTX)

  if(HAVE_TRACING)
ADD_TEST(memcheck-msg-tracing-gtnets-waxman-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/waxman-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/waxman-d.xml --cfg=tracing/filename:waxman_gtnets.trace --cfg=tracing/categorized:1 --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-tracing-gtnets-dogbone-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-d.xml --cfg=tracing/filename:dogbone_gtnets.trace --cfg=tracing/categorized:1 --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-tracing-gtnets-onelink-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-d.xml --cfg=tracing/filename:onelink_gtnets.trace --cfg=tracing/categorized:1 --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-tracing-gtnets-dogbone-lv08-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/dogbone-d.xml --cfg=tracing/filename:dogbone_lv08.trace --cfg=tracing/categorized:1 --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:LV08 --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-tracing-gtnets-onelink-lv08-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/gtnets/onelink-d.xml --cfg=tracing/filename:onelink_lv08.trace --cfg=tracing/categorized:1 --cfg=workstation/model:compound --cfg=cpu/model:Cas01  --cfg=network/model:LV08 2>&1 | grep --color=auto -v root/INFO | grep -v simix_network/INFO --cd ${CMAKE_BINARY_DIR}/examples/msg/)
  endif(HAVE_TRACING)
endif(HAVE_GTNETS)

if(HAVE_NS3)
ADD_TEST(memcheck-msg-ns3-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3hosts_2links_p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3hosts_2links_d.xml --cfg=network/model:NS3 --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3links-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3links-d.xml --cfg=network/model:NS3 --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-thread-2 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3links-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3links-d-timer.xml --cfg=network/model:NS3 --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-thread-3 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/platforms/cluster.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/One_cluster-d.xml --cfg=network/model:NS3 --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-thread-4 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/platforms/clusters_routing_full.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/Two_clusters-d.xml --cfg=network/model:NS3 --cfg=contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3hosts_2links_p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3hosts_2links_d.xml --cfg=network/model:NS3 --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3links-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3links-d.xml --cfg=network/model:NS3 --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-ucontext-2 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3links-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3links-d-timer.xml --cfg=network/model:NS3 --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-ucontext-3 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/platforms/cluster.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/One_cluster-d.xml --cfg=network/model:NS3 --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-ucontext-4 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/platforms/clusters_routing_full.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/Two_clusters-d.xml --cfg=network/model:NS3 --cfg=contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3hosts_2links_p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3hosts_2links_d.xml --cfg=network/model:NS3 --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3links-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3links-d.xml --cfg=network/model:NS3 --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-raw-2 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3links-p.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/3links-d-timer.xml --cfg=network/model:NS3 --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-raw-3 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/platforms/cluster.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/One_cluster-d.xml --cfg=network/model:NS3 --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ns3-raw-4 ${CMAKE_BINARY_DIR}/examples/msg/ns3/ns3 ${CMAKE_HOME_DIRECTORY}/examples/platforms/clusters_routing_full.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/ns3/Two_clusters-d.xml --cfg=network/model:NS3 --cfg=contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
endif(HAVE_NS3)

IF(HAVE_TRACING)
  ADD_TEST(tracing-help             ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test --help-tracing)
ADD_TEST(memcheck-tracing-ms-0 ${CMAKE_BINARY_DIR}/examples/msg/tracing/ms --cfg=tracing:1 --cfg=tracing/buffer:1 --cfg=tracing/filename:tracing/ms.trace --cfg=tracing/categorized:1 --cfg=tracing/uncategorized:1 --cfg=triva/categorized:tracing/ms.cat.plist --cfg=triva/uncategorized:tracing/ms.uncat.plist ./tracing/platform.xml ./tracing/deployment.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-ms-1 ${CMAKE_BINARY_DIR}/examples/msg/tracing/ms ./tracing/platform.xml ./tracing/deployment.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-ms-2 ${CMAKE_BINARY_DIR}/examples/msg/tracing/ms --cfg=tracing:1 --cfg=tracing/msg/process:1 --cfg=tracing/buffer:1 --cfg=tracing/filename:tracing/ms.trace --cfg=tracing/categorized:1 --cfg=tracing/uncategorized:1 --cfg=triva/categorized:tracing/ms.cat.plist --cfg=triva/uncategorized:tracing/ms.uncat.plist ./tracing/platform.xml ./tracing/deployment.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-ms-3 cat tracing/ms.uncat.plist --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-ms-4 cat tracing/ms.cat.plist --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-ms-5 rm -rf tracing/ms.trace tracing/ms.cat.plist tracing/ms.uncat.plist --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-trace_platform-0 ${CMAKE_BINARY_DIR}/examples/msg/tracing/trace_platform --cfg=tracing:1 --cfg=tracing/categorized:1 ./tracing/platform.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-trace_platform-1 cat simgrid.trace --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-trace_platform-2 ${CMAKE_BINARY_DIR}/examples/msg/tracing/trace_platform --cfg=tracing:1 --cfg=tracing/categorized:1 ./../platforms/g5k.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-trace_platform-3 cat simgrid.trace --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-trace_platform-4 rm -rf simgrid.trace --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-user_variables-0 ${CMAKE_BINARY_DIR}/examples/msg/tracing/user_variables --cfg=tracing:1 --cfg=tracing/platform:1 ./tracing/platform.xml ./tracing/deployment.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-user_variables-1 rm triva_graph.plist --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-user_variables-2 ${CMAKE_BINARY_DIR}/examples/msg/tracing/user_variables ./tracing/platform.xml ./tracing/deployment.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-link_user_variables-0 ${CMAKE_BINARY_DIR}/examples/msg/tracing/link_user_variables --cfg=tracing:1 --cfg=tracing/platform:1 ./tracing/platform.xml ./tracing/deployment.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-link_srcdst_user_variables-0 ${CMAKE_BINARY_DIR}/examples/msg/tracing/link_srcdst_user_variables --cfg=tracing:1 --cfg=tracing/platform:1 ./tracing/platform.xml ./tracing/deployment.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-categories-0 ${CMAKE_BINARY_DIR}/examples/msg/tracing/categories --cfg=tracing:1 --cfg=tracing/buffer:1 --cfg=tracing/filename:tracing/categories.trace --cfg=tracing/categorized:1 --cfg=tracing/uncategorized:1 --cfg=triva/categorized:tracing/categories.cat.plist --cfg=triva/uncategorized:tracing/categories.uncat.plist ./tracing/platform.xml ./tracing/deployment.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-categories-1 cat tracing/categories.cat.plist --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-categories-2 cat tracing/categories.uncat.plist --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-categories-3 rm -rf tracing/categories.trace tracing/categories.cat.plist tracing/categories.uncat.plist --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-process-migration-0 ${CMAKE_BINARY_DIR}/examples/msg/tracing/procmig --cfg=tracing:1 --cfg=tracing/buffer:1 --cfg=tracing/filename:tracing/procmig.trace --cfg=tracing/msg/process:1 ./tracing/platform.xml ./tracing/procmig-deploy.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-process-migration-1 ${CMAKE_BINARY_DIR}/examples/msg/tracing/procmig --cfg=tracing:1 --cfg=tracing/categorized:1 --cfg=tracing/uncategorized:1 --cfg=tracing/buffer:1 --cfg=tracing/filename:tracing/procmig.trace --cfg=tracing/msg/process:1 ./tracing/platform.xml ./tracing/procmig-deploy.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-process-migration-2 ${CMAKE_BINARY_DIR}/examples/msg/tracing/procmig --cfg=tracing/categorized:1 --cfg=tracing/uncategorized:1 --cfg=tracing/buffer:0 --cfg=tracing/filename:tracing/procmig.trace --cfg=tracing/msg/process:1 ./tracing/platform.xml ./tracing/procmig-deploy.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-process-migration-3 ${CMAKE_BINARY_DIR}/examples/msg/tracing/procmig ./tracing/platform.xml ./tracing/procmig-deploy.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-process-migration-4 ${CMAKE_BINARY_DIR}/examples/msg/tracing/procmig --cfg=tracing:0 ./tracing/platform.xml ./tracing/procmig-deploy.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-process-migration-5 ${CMAKE_BINARY_DIR}/examples/msg/tracing/procmig --cfg=tracing:1 --cfg=tracing/categorized:1 ./tracing/platform.xml ./tracing/procmig-deploy.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-process-migration-6 ${CMAKE_BINARY_DIR}/examples/msg/tracing/procmig --cfg=tracing:1 --cfg=tracing/uncategorized:1 ./tracing/platform.xml ./tracing/procmig-deploy.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-process-migration-7 ${CMAKE_BINARY_DIR}/examples/msg/tracing/procmig --cfg=tracing:1 --cfg=tracing/msg/process:1 ./tracing/platform.xml ./tracing/procmig-deploy.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-tracing-process-migration-8 rm -rf tracing/procmig.trace simgrid.trace --cd ${CMAKE_HOME_DIRECTORY}/examples/msg/)
ADD_TEST(memcheck-graphicator-0 ${CMAKE_BINARY_DIR}/bin/graphicator ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/one_cluster.xml --cfg=tracing:1 --cfg=tracing/platform:1 test.dot --cd ${CMAKE_HOME_DIRECTORY}/tools/graphicator/)
ADD_TEST(memcheck-graphicator-1 rm test.dot --cd ${CMAKE_HOME_DIRECTORY}/tools/graphicator/)
ENDIF(HAVE_TRACING)

# Lua examples
if(HAVE_LUA)
ADD_TEST(memcheck-lua-duplicated-globals-0 lua duplicated_globals.lua --cd ${CMAKE_HOME_DIRECTORY}/examples/lua/state_cloner/)
ADD_TEST(memcheck-lua-masterslave-0 lua master_slave.lua ../../msg/small_platform.xml ../deploy.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/lua/masterslave/)
ADD_TEST(memcheck-lua-mult-matrix-0 lua mult_matrix.lua "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_HOME_DIRECTORY}/examples/lua/multi_matrix/)
ADD_TEST(memcheck-lua-masterslave-bypass-0 lua master_slave_bypass.lua --log=surf_parse.thres:critical --cd ${CMAKE_HOME_DIRECTORY}/examples/lua/console/)
ADD_TEST(memcheck-lua-msg-masterslave-console-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_console ${CMAKE_HOME_DIRECTORY}/examples/msg/masterslave/platform_script.lua --log=surf_parse.thres:critical "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/examples/msg/masterslave/)
ADD_TEST(memcheck-lua-chord-0 lua chord.lua ../../msg/msg_platform.xml ../../msg/chord/chord.xml --cd ${CMAKE_HOME_DIRECTORY}/examples/lua/chord/)
set_tests_properties(memcheck-lua-duplicated-globals-0 				PROPERTIES ENVIRONMENT "LUA_CPATH=${CMAKE_BINARY_DIR}/examples/lua/?.so")
set_tests_properties(memcheck-lua-masterslave-0 				PROPERTIES ENVIRONMENT "LUA_CPATH=${CMAKE_BINARY_DIR}/examples/lua/?.so")
set_tests_properties(memcheck-lua-mult-matrix-0  				PROPERTIES ENVIRONMENT "LUA_CPATH=${CMAKE_BINARY_DIR}/examples/lua/?.so")
set_tests_properties(memcheck-lua-masterslave-bypass-0  		PROPERTIES ENVIRONMENT "LUA_CPATH=${CMAKE_BINARY_DIR}/examples/lua/?.so")
set_tests_properties(memcheck-lua-msg-masterslave-console-0  	PROPERTIES ENVIRONMENT "LUA_CPATH=${CMAKE_BINARY_DIR}/examples/lua/?.so")
set_tests_properties(memcheck-lua-chord-0 				PROPERTIES ENVIRONMENT "LUA_CPATH=${CMAKE_BINARY_DIR}/examples/lua/?.so")
endif(HAVE_LUA)

