/*
  A symbol table.
  Copyright (C) 2005 The MITRE Corporation

  Author: John D. Ramsdell

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <obstack.h>
#include <search.h>
#include <slat/xmalloc.h>
#include <slat/symbol.h>
#include <slat/intern.h>

/* Initial hash table size */
#define HSIZE (1 << 13)

/* Allocation using obstack */

#define obstack_chunk_alloc xmalloc
#define obstack_chunk_free free

static struct obstack stack[1];

void
intern_init(void)
{
  hcreate(HSIZE);
  obstack_init(stack);
}

void
intern_free(void)
{
  obstack_free(stack, 0);
}

symbol_t
intern(const char *s)
{
  ENTRY e, *ep;
  e.key = (char *)s;
  ep = hsearch(e, FIND);
  if (!ep) {
    char *t = (char *)obstack_copy0(stack, s, strlen(s));
    e.key = t;
    e.data = make_symbol(s);
    ep = hsearch(e, ENTER);
  }
  if (!ep) {
    fprintf(stderr,
	    "In symbol table, malloc failed during hash table entry\n");
    exit(1);
  }
  return (symbol_t)ep->data;
}
