/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <gnome.h>
#include "ag_defs.h"


/**
 * The input and output texts
 **/
GtkWidget *input_text;
GtkWidget *output_text;

/**
 * The buttons
 **/
GtkWidget* button_map[AG_NB_KEYS];

/**
 * The error status
 **/
AgError    errState;

/**
 * The execution status
 **/
gint       exe_state = 1;


/**
 * Preferences
 **/
AgTextPref text_prefs;
AgModePref mode_prefs;
 

gint angle_mode;
gint size_mode;
gint format_mode;

void
ag_set_button_map(gint id, GtkWidget* button)
{
	if (id != AG_KEY_NONE)
		button_map[id] = button;	
}

GtkWidget*
ag_get_button_map(gint id) {	
	return button_map[id];		
}


GtkWidget*
ag_get_button_map_char(gchar ch) {		
	static gchar char_key_map[] = "0123456789.*/^-+()!";
	static gint button_key_map[] = {
		AG_KEY_0, AG_KEY_1, AG_KEY_2, AG_KEY_3, AG_KEY_4, AG_KEY_5,
		AG_KEY_6, AG_KEY_7, AG_KEY_8, AG_KEY_9, AG_KEY_DOT, 
		AG_KEY_MUL, AG_KEY_DIV, AG_KEY_POW, AG_KEY_MINUS, AG_KEY_PLUS, 
		AG_KEY_P_OPEN, AG_KEY_P_CLOSE, AG_KEY_FAC };

	gint idx = 0;
	while (char_key_map[idx] != ch && char_key_map[idx] != 0)
		idx++;
		
	if (char_key_map[idx] == 0) return NULL;
	else return ag_get_button_map(button_key_map[idx]);	
}








