/*
 * -------------------------------------------------------------------------
 *
 * Remote Frame buffer protocol server
 *
 * (C) 2006 Jochen Karrer
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ------------------------------------------------------------------------
 */

#include <stdint.h>
#include <fbdisplay.h>
#include <keyboard.h>
/*
 * ----------------------------------------------------------------
 * A display has to set the Display info
 * ----------------------------------------------------------------
 */
typedef struct DisplayInfo {
        uint32_t xres;
        uint32_t yres;
	int is_color;
} DisplayInfo;

/*
 * ------------------------------------------------------
 * The PixelDataInfo comes from the displaycontroller
 * which provides the data
 * ------------------------------------------------------
 */
typedef struct PixelDataInfo {
	uint8_t bits_per_pixel;
        uint8_t depth;
        uint8_t big_endian_flag;
        uint8_t true_color_flag;
        uint16_t red_max;
        uint16_t blue_max;
        uint16_t green_max;
        uint8_t red_shift;
        uint8_t green_shift;
        uint8_t blue_shift;
} PixelDataInfo;

typedef struct RfbServer RfbServer;
void RfbServer_New(const char *name,FbDisplay **fbdisplay,Keyboard **kbd,void **mouse);
