/*
 * -----------------------------------------------------------------------------
 *
 * Emulation of an USB Hub 
 * (C) 2006 Jochen Karrer
 *
 * State:
 *      Detected by linux kernel, but does nothing useful
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ------------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <usbdevice.h>
#include <usbstdrq.h>
#include <usbhub.h.h>


#define         HUBFEAT_C_HUB_LOCAL_POWER       (0)
#define         HUBFEAT_C_HUB_OVER_CURRENT      (1)

/* Destination Port */
#define         HUBFEAT_PORT_CONNECTION         (0)
#define         HUBFEAT_PORT_ENABLE             (1)
#define         HUBFEAT_PORT_SUSPEND            (2)
#define         HUBFEAT_PORT_OVER_CURRENT       (3)
#define         HUBFEAT_PORT_RESET              (4)
#define         HUBFEAT_PORT_POWER              (8)
#define         HUBFEAT_PORT_LOW_SPEED          (9)
#define         HUBFEAT_C_PORT_CONNECTION       (16)
#define         HUBFEAT_C_PORT_ENABLE           (17)
#define         HUBFEAT_C_PORT_SUSPEND          (18)
#define         HUBFEAT_C_PORT_OVER_CURRENT     (19)
#define         HUBFEAT_C_PORT_RESET            (20)
#define         HUBFEAT_PORT_TEST               (21)
#define         HUBFEAT_PORT_INDICATOR          (22)

#define USB_RQT_HUB        (USB_RQT_TCLASS | USB_RQT_RDEVICE)
#define USB_RQT_PORT       (USB_RQT_TCLASS | USB_RQT_ROTHER)

/*
 * The following requests are only valid for RQT_HUB or RQT_PORT
 */
#define	UHUBRQ_GET_STATUS	(0)
#define	UHUBRQ_CLEAR_FEATURE	(1)
#define UHUBRQ_SET_FEATURE	(3)
#define	UHUBRQ_GET_DESCRIPTOR	(6)
#define	UHUBRQ_SET_DESCRIPTOR	(7)
#define UHUBRQ_CLEAR_TT_BUFFER	(8)
#define	UHUBRQ_RESET_TT		(9)
#define	UHUBRQ_GET_TT_STATE	(10)
#define	UHUBRQ_STOP_TT		(11)

typedef struct UsbHub {
        UsbDevice *udev;
} UsbHub;

UsbDevice *
UsbHub_New(const char *name) 
{
	UsbHub *hub = (UsbHub*)malloc(sizeof(UsbHub));
        UsbDevice *udev;
        int i;
        if(!hub) {
                fprintf(stderr,"Out of memory for UsbHub\n");
                exit(1);
        }
        memset(hub,0,sizeof(*hub));
	udev = hub->udev = UsbDev_New(hub,USB_SPEED_FULL);
	return udev;
}
