#!/usr/bin/env python
"""Sonata is a simple GTK+ client for the Music Player Daemon.
"""

__author__ = "Scott Horowitz"
__email__ = "stonecrest@gmail.com"
__license__ = """
Sonata, an elegant GTK+ client for the Music Player Daemon
Copyright 2006-2008 Scott Horowitz <stonecrest@gmail.com>

This file is part of Sonata.

Sonata is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

Sonata is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from sonata import main
import sys

try:
	import dbus
	import dbus.service
	if getattr(dbus, "version", (0,0,0)) >= (0,41,0):
		import dbus.glib
	HAVE_DBUS = True
except:
	HAVE_DBUS = False

if __name__ == "__main__":
	if HAVE_DBUS:
		try:
			session_bus = dbus.SessionBus()
			bus_name = dbus.service.BusName('org.MPD', bus=session_bus)
			app = main.BaseDBus(bus_name, '/org/MPD/Sonata')
		except SystemExit:
			sys.exit()
		except:
			app = main.Base()
	else:
		app = main.Base()
	try:
		app.main()
	except KeyboardInterrupt:
		pass
