#ifndef _HdlArgumentConstraint_h
#define _HdlArgumentConstraint_h

#include <set>
#include "util.h"

class HdlToken;

class HdlArgumentConstraint
{
public:
  HdlArgumentConstraint()
    : m_intOK(false),
      m_doubleOK(false),
      m_stringOK(false),
      m_idOK(false)
  {
  }

  ~HdlArgumentConstraint()
  {
  }

  void acceptID()
  {
    m_idOK = true;
  }

  void acceptID(const CRef<HdlToken> &id);

  void acceptInteger()
  {
    m_intOK = true;
  }

  void acceptDouble()
  {
    m_intOK = true;
    m_doubleOK = true;
  }

  void acceptString()
  {
    m_stringOK = true;
  }

  void validateArgument(const CRef<HdlToken> &arg) const;

private:
  void throwInvalidArgument(const CRef<HdlToken> &arg) const;

private:
  /// Not implemented.
  HdlArgumentConstraint(const HdlArgumentConstraint &);

  /// Not implemented.
  HdlArgumentConstraint& operator=(const HdlArgumentConstraint &);

private:
  bool m_intOK;
  bool m_doubleOK;
  bool m_stringOK;
  bool m_idOK;
  set<string> m_validIDs;
};

#endif // _HdlArgumentConstraint_h
