-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

---------------------------------------------------------------------------------
-- Package for generating an XML version of the summary file.                  --
---------------------------------------------------------------------------------

with E_Strings;
with SPARK_IO;

--# inherit CommandLine,
--#         E_Strings,
--#         OSFiling,
--#         PathFormatter,
--#         SPARK_IO,
--#         SPARK_XML;

package XMLSummary
--# own State;
is

   type Summary_Section is (
                            SS_Totals,
                            SS_Percentages,
                            SS_Assert_Post,
                            SS_Check,
                            SS_Inheritance,
                            SS_Precondition,
                            SS_Refinement,
                            SS_Runtime,
                            SS_Undetermined);

   type Item_Type is (
                      IT_Examiner,
                      IT_Simplifier,
                      IT_Simplifier_User_Rule,
                      IT_Victor,
                      IT_Checker,
                      IT_Review,
                      IT_False,
                      IT_Contra,
                      IT_User,
                      IT_Undischarged,
                      IT_Undetermined);

   type VC_Status is (
                      VCG,
                      SIV,
                      VCTR,
                      PLG,
                      REV,
                      WRONG, -- can't redeclare False!!
                      CONTRA,
                      USER,
                      TODO);

   type File_Type is (VCG_File, SIV_File, VCTR_File, PLG_File, REV_File);

   procedure Init;
   --# global out State;
   --# derives State from ;

   -- Producers for simple container tags.
   -- These have no attributes of their own and only contain other tags.

   procedure Start_Pogs
     (Report_Name  : in E_Strings.T;
      Pogs_Version : in E_Strings.T;
      Licensee     : in E_Strings.T;
      Ignore_Dates : in Boolean;
      Report       : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Ignore_Dates,
   --#                                Licensee,
   --#                                Pogs_Version,
   --#                                Report,
   --#                                Report_Name,
   --#                                State &
   --#         State             from *,
   --#                                Ignore_Dates,
   --#                                Licensee,
   --#                                Pogs_Version,
   --#                                Report_Name;

   procedure End_Pogs (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure Start_Types (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure End_Types (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure Start_Results (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure End_Results (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure Start_Summary (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure End_Summary (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure Start_Subprogram_Summary (Total_Subprogs : in Natural;
                                       Report         : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State,
   --#                                Total_Subprogs &
   --#         State             from *,
   --#                                Total_Subprogs;

   procedure End_Subprogram_Summary (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure Start_Subprograms_In_Error_Summary (Total_Subprogs_In_Error : in Natural;
                                                 Report                  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State,
   --#                                Total_Subprogs_In_Error &
   --#         State             from *,
   --#                                Total_Subprogs_In_Error;

   procedure End_Subprograms_In_Error_Summary (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure Start_VC_Summary (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure End_VC_Summary (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   ---------------------------------
   -- Container tags with attributes
   ---------------------------------

   -- For optional attributes, if the Empty_String is supplied then the attribute
   -- will not be added to the tag.

   procedure Start_File
     (Name       : in E_Strings.T;
      Proc       : in E_Strings.T;
      Generated  : in E_Strings.T;
      Simplified : in E_Strings.T;
      Checked    : in E_Strings.T;
      Report     : in SPARK_IO.File_Type);
   --# global in     CommandLine.Data;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Checked,
   --#                                CommandLine.Data,
   --#                                Generated,
   --#                                Name,
   --#                                Proc,
   --#                                Report,
   --#                                Simplified,
   --#                                State &
   --#         State             from *,
   --#                                Checked,
   --#                                CommandLine.Data,
   --#                                Generated,
   --#                                Name,
   --#                                Proc,
   --#                                Simplified;

   procedure End_File (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure File_Error (Message : in E_Strings.T;
                         F_Type  : in File_Type;
                         Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                F_Type,
   --#                                Message,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                F_Type;

   procedure VC
     (VC_Number     : in E_Strings.T;
      From_Point    : in E_Strings.T;
      To_Point_Type : in E_Strings.T;
      To_Point      : in E_Strings.T;
      Status        : in VC_Status;
      Report        : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                From_Point,
   --#                                Report,
   --#                                State,
   --#                                Status,
   --#                                To_Point,
   --#                                To_Point_Type,
   --#                                VC_Number &
   --#         State             from *,
   --#                                From_Point,
   --#                                Status,
   --#                                To_Point,
   --#                                To_Point_Type,
   --#                                VC_Number;

   procedure Start_Summary_Section (Section : in Summary_Section;
                                    Total   : in Integer;
                                    Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                Section,
   --#                                State,
   --#                                Total &
   --#         State             from *,
   --#                                Section,
   --#                                Total;

   -- Summary sections cannot enclose each other, so calls to this
   -- procedure will just close the last opened section.
   procedure End_Summary_Section (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   -- Simple non-container tags.
   -- These either have just attributes or values

   procedure Directory (Directory_Name : in E_Strings.T;
                        Report         : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Directory_Name,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure Produced (Produced_Date : in E_Strings.T;
                       Report        : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Produced_Date,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure Summary_Item_Str (Item   : in Item_Type;
                               Value  : in E_Strings.T;
                               Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Report,
   --#                                State,
   --#                                Value &
   --#         State             from *,
   --#                                Item;

   procedure Summary_Item_Int (Item   : in Item_Type;
                               Value  : in Integer;
                               Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Report,
   --#                                State,
   --#                                Value &
   --#         State             from *,
   --#                                Item;

   procedure Analysis_Type (Typ    : in E_Strings.T;
                            Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State,
   --#                                Typ &
   --#         State             from *;

end XMLSummary;
