% -----------------------------------------------------------------------------
%  (C) Altran Praxis Limited
% -----------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
% =============================================================================

%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Support to declare operator precedences and fixivity.
%###############################################################################

%###############################################################################
% MODULE
%###############################################################################
:- module(opdeclar,
          [declare_operators/0,
           hide_operators/0]).

%###############################################################################
% DEPENDENCIES
%###############################################################################

%###############################################################################
% TYPES
%###############################################################################

%###############################################################################
% DYNAMICS
%###############################################################################

%###############################################################################
% PREDICATES
%###############################################################################

%===============================================================================
% declare_operators.
%-------------------------------------------------------------------------------
% Declare operator precedence and fixivity as used by the spark tools.
%===============================================================================



declare_operators :-
    %--------------------
    op(350, xfx, ** ),
    % INITIAL VALUE POSTFIX
    op(350, xf, ~),
    % Attributes
    op(350, yfx, #),
    %--------------------

    %--------------------
    op(375,  fx, +  ),
    op(375,  fx, -  ),
    %--------------------

    %--------------------
    op(400, yfx, *  ),
    op(400, yfx, /  ),
    op(400, yfx, div),
    op(400, yfx, mod),
    op(400, yfx, rem),
    op(400, yfx, @  ),
    op(400, yfx, /\ ),
    %--------------------

    %--------------------
    op(500, yfx, +  ),
    op(500, yfx, -  ),
    op(500, yfx, \/ ),
    op(500, yfx, \  ),
    %--------------------

    %--------------------
    op(700, yfx, <> ),
    op(700, yfx, <= ),
    op(700, yfx, in ),
    op(700, yfx, not_in ),
    op(700, yfx, subset_of ),
    op(700, yfx, strict_subset_of ),
    % Signed 'is'
    op(700, xfx, iss),
    % Arithmetic
    op(700, yfx, less_than),
    % Sets
    op(700, fy,  set),
    %--------------------

    %--------------------
    op(900,  fy, not ),
    %--------------------

    %--------------------
    op(925, yfx, and ),
    %--------------------

    %--------------------
    op(950, yfx, or  ),
    % Guesstimated precedence!
    op(950, yfx, xor ),
    %--------------------

    %--------------------
    op(975, yfx, ->  ),
    op(975, yfx, <-> ),
    %--------------------

    %--------------------
    % for range notation
    op(990, yfx, '..'),
    % Used for "unit function"
    op(990, fx, unit),
    %--------------------

    %--------------------
    op(992, yfx, requires),
    %--------------------

    %--------------------
    % Used in array aggregates
    op(995, yfx, ':='),
    %--------------------

    %--------------------
    % Used in array aggregates
    op(997, yfx, &),
    op(997, fx, rule_family),
    %--------------------

    %--------------------
    op(998, yfx, may_be_deduced_from),
    op(998, yfx, may_be_replaced_by),
    op(998, xf, are_interchangeable),
    op(998, yfx, if),
    op(998, xf, may_be_deduced),
    %--------------------

    %--------------------
    % Used in quantification
    op(999, xfy, :),
    %--------------------
    !.

%===============================================================================
% hide_operators.
%-------------------------------------------------------------------------------
% After all dynamic predicates have been introduced, we need to disable
% "dynamic" as an operator in case a user has an fdl entity called
% "dynamic".  Same goes for the other predefined prolog operators that might
% look like fdl identifiers. See the sicstus manual section "Standard
% Operators".
%===============================================================================

hide_operators:-
    op(0, fx, mode),
    op(0, fx, public),
    op(0, fx, dynamic),
    op(0, fx, multifile),
    op(0, fx, volatile),
    op(0, fx, block),
    op(0, fx, meta_predicate),
    op(0, fx, discontiguous),
    op(0, fx, initialization),
    op(0, fx, spy),
    op(0, fx, nospy),
    !.

%###############################################################################
% END-OF-FILE
