-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

package body Files is

   function Filetype_From_Extension (Extension : in SPARK.Ada.Strings.Unbounded.Unbounded_String) return File_Types is
      Result : File_Types;
   begin
      if SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "vcg") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "dpc") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "fdl") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "rls") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "rep") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "lst") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "sli") then

         Result := Examiner_Files;

      elsif SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "siv") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "slg") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "sdp") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "zsl") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "log") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "zlg") then

         Result := Simplifier_Files;

      elsif SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "vct") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "vlg") or
        SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "vsm") then

         Result := Victor_Files;

      elsif SPARK.Ada.Strings.Unbounded.Equal_Unbounded_String_String (Extension, "sum") then

         Result := POGS_Files;

      else
         Result := Unknown;

      end if;
      return Result;
   end Filetype_From_Extension;

end Files;
